/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.flow;

import java.util.List;
import org.apache.fop.apps.StructureHandler;
import org.apache.fop.area.Trait;
import org.apache.fop.area.inline.InlineArea;
import org.apache.fop.area.inline.Word;
import org.apache.fop.datatypes.ColorType;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.FObj;
import org.apache.fop.layout.AccessibilityProps;
import org.apache.fop.layout.AuralProps;
import org.apache.fop.layout.BackgroundProps;
import org.apache.fop.layout.BorderAndPadding;
import org.apache.fop.layout.FontInfo;
import org.apache.fop.layout.FontState;
import org.apache.fop.layout.MarginInlineProps;
import org.apache.fop.layout.RelativePositionProps;
import org.apache.fop.layout.TextState;
import org.apache.fop.layoutmgr.LayoutContext;
import org.apache.fop.layoutmgr.LeafNodeLayoutManager;
import org.apache.fop.util.CharUtilities;

public class PageNumber
extends FObj {
    protected FontInfo fontInfo = null;
    protected FontState fontState;
    private float red;
    private float green;
    private float blue;
    private int wrapOption;
    private int whiteSpaceCollapse;
    private TextState ts;

    public PageNumber(FONode parent) {
        super(parent);
    }

    public void setStructHandler(StructureHandler st) {
        super.setStructHandler(st);
        this.fontInfo = st.getFontInfo();
    }

    public void addLayoutManager(List lms) {
        this.setup();
        LeafNodeLayoutManager lm = new LeafNodeLayoutManager(){

            public InlineArea get(LayoutContext context) {
                Word inline = new Word();
                String str = this.parentLM.getCurrentPageNumber();
                int width = 0;
                int count = 0;
                while (count < str.length()) {
                    width += CharUtilities.getCharWidth(str.charAt(count), PageNumber.this.fontState);
                    ++count;
                }
                inline.setWord(str);
                inline.setIPD(width);
                inline.setHeight(PageNumber.this.fontState.getAscender() - PageNumber.this.fontState.getDescender());
                inline.setOffset(PageNumber.this.fontState.getAscender());
                inline.addTrait(Trait.FONT_NAME, PageNumber.this.fontState.getFontName());
                inline.addTrait(Trait.FONT_SIZE, new Integer(PageNumber.this.fontState.getFontSize()));
                return inline;
            }

            protected void offsetArea(LayoutContext context) {
                this.curArea.setOffset(context.getBaseline());
            }
        };
        lm.setUserAgent(this.getUserAgent());
        lm.setFObj(this);
        lms.add(lm);
    }

    public void setup() {
        AccessibilityProps mAccProps = this.propMgr.getAccessibilityProps();
        AuralProps mAurProps = this.propMgr.getAuralProps();
        BorderAndPadding bap = this.propMgr.getBorderAndPadding();
        BackgroundProps bProps = this.propMgr.getBackgroundProps();
        this.fontState = this.propMgr.getFontState(this.fontInfo);
        MarginInlineProps mProps = this.propMgr.getMarginInlineProps();
        RelativePositionProps mRelProps = this.propMgr.getRelativePositionProps();
        this.setupID();
        ColorType c = this.properties.get("color").getColorType();
        this.red = c.getRed();
        this.green = c.getGreen();
        this.blue = c.getBlue();
        this.wrapOption = this.properties.get("wrap-option").getEnum();
        this.whiteSpaceCollapse = this.properties.get("white-space-collapse").getEnum();
        this.ts = new TextState();
    }
}

