/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.flow;

import java.util.List;
import org.apache.fop.apps.StructureHandler;
import org.apache.fop.area.PageViewport;
import org.apache.fop.area.Resolveable;
import org.apache.fop.area.Trait;
import org.apache.fop.area.inline.InlineArea;
import org.apache.fop.area.inline.UnresolvedPageNumber;
import org.apache.fop.area.inline.Word;
import org.apache.fop.datatypes.ColorType;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.FObj;
import org.apache.fop.layout.AccessibilityProps;
import org.apache.fop.layout.AuralProps;
import org.apache.fop.layout.BackgroundProps;
import org.apache.fop.layout.BorderAndPadding;
import org.apache.fop.layout.FontInfo;
import org.apache.fop.layout.FontState;
import org.apache.fop.layout.MarginInlineProps;
import org.apache.fop.layout.RelativePositionProps;
import org.apache.fop.layout.TextState;
import org.apache.fop.layoutmgr.LayoutContext;
import org.apache.fop.layoutmgr.LayoutProcessor;
import org.apache.fop.layoutmgr.LeafNodeLayoutManager;
import org.apache.fop.layoutmgr.PositionIterator;
import org.apache.fop.util.CharUtilities;

public class PageNumberCitation
extends FObj {
    protected FontInfo fontInfo = null;
    protected FontState fontState;
    private float red;
    private float green;
    private float blue;
    private int wrapOption;
    private int whiteSpaceCollapse;
    private String pageNumber;
    private String refId;
    private TextState ts;
    private InlineArea inline = null;
    private boolean unresolved = false;

    public PageNumberCitation(FONode parent) {
        super(parent);
    }

    public void setStructHandler(StructureHandler st) {
        super.setStructHandler(st);
        this.fontInfo = st.getFontInfo();
    }

    public void addLayoutManager(List lms) {
        this.setup();
        LeafNodeLayoutManager lm = new LeafNodeLayoutManager(){

            public InlineArea get(LayoutContext context) {
                return PageNumberCitation.this.getInlineArea(this.parentLM);
            }

            public void addAreas(PositionIterator posIter, LayoutContext context) {
                super.addAreas(posIter, context);
                if (PageNumberCitation.this.unresolved) {
                    this.parentLM.addUnresolvedArea(PageNumberCitation.this.refId, (Resolveable)((Object)PageNumberCitation.this.inline));
                }
            }

            protected void offsetArea(LayoutContext context) {
                this.curArea.setOffset(context.getBaseline());
            }
        };
        lm.setUserAgent(this.getUserAgent());
        lm.setFObj(this);
        lms.add(lm);
    }

    private InlineArea getInlineArea(LayoutProcessor parentLM) {
        if (this.refId.equals("")) {
            this.getLogger().error("page-number-citation must contain \"ref-id\"");
            return null;
        }
        PageViewport page = parentLM.resolveRefID(this.refId);
        if (page != null) {
            String str = page.getPageNumber();
            Word word = new Word();
            this.inline = word;
            int width = this.getStringWidth(str);
            word.setWord(str);
            this.inline.setIPD(width);
            this.inline.setHeight(this.fontState.getAscender() - this.fontState.getDescender());
            this.inline.setOffset(this.fontState.getAscender());
            this.inline.addTrait(Trait.FONT_NAME, this.fontState.getFontName());
            this.inline.addTrait(Trait.FONT_SIZE, new Integer(this.fontState.getFontSize()));
            this.unresolved = false;
        } else {
            this.unresolved = true;
            this.inline = new UnresolvedPageNumber(this.refId);
            String str = "MMM";
            int width = this.getStringWidth(str);
            this.inline.setIPD(width);
            this.inline.setHeight(this.fontState.getAscender() - this.fontState.getDescender());
            this.inline.setOffset(this.fontState.getAscender());
            this.inline.addTrait(Trait.FONT_NAME, this.fontState.getFontName());
            this.inline.addTrait(Trait.FONT_SIZE, new Integer(this.fontState.getFontSize()));
        }
        return this.inline;
    }

    protected int getStringWidth(String str) {
        int width = 0;
        int count = 0;
        while (count < str.length()) {
            width += CharUtilities.getCharWidth(str.charAt(count), this.fontState);
            ++count;
        }
        return width;
    }

    public void setup() {
        AccessibilityProps mAccProps = this.propMgr.getAccessibilityProps();
        AuralProps mAurProps = this.propMgr.getAuralProps();
        BorderAndPadding bap = this.propMgr.getBorderAndPadding();
        BackgroundProps bProps = this.propMgr.getBackgroundProps();
        this.fontState = this.propMgr.getFontState(this.fontInfo);
        MarginInlineProps mProps = this.propMgr.getMarginInlineProps();
        RelativePositionProps mRelProps = this.propMgr.getRelativePositionProps();
        this.setupID();
        ColorType c = this.properties.get("color").getColorType();
        this.red = c.getRed();
        this.green = c.getGreen();
        this.blue = c.getBlue();
        this.wrapOption = this.properties.get("wrap-option").getEnum();
        this.whiteSpaceCollapse = this.properties.get("white-space-collapse").getEnum();
        this.refId = this.properties.get("ref-id").getString();
        if (this.refId.equals("")) {
            // empty if block
        }
    }
}

