/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.flow;

import java.util.List;
import org.apache.fop.datatypes.ColorType;
import org.apache.fop.datatypes.KeepValue;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.Property;
import org.apache.fop.layout.AccessibilityProps;
import org.apache.fop.layout.AuralProps;
import org.apache.fop.layout.BackgroundProps;
import org.apache.fop.layout.BorderAndPadding;
import org.apache.fop.layout.RelativePositionProps;
import org.apache.fop.layoutmgr.table.Row;

public class TableRow
extends FObj {
    private boolean setup = false;
    private int breakAfter;
    private ColorType backgroundColor;
    private KeepValue keepWithNext;
    private KeepValue keepWithPrevious;
    private KeepValue keepTogether;
    private int minHeight = 0;

    public TableRow(FONode parent) {
        super(parent);
    }

    public void addLayoutManager(List list) {
        Row rlm = new Row();
        rlm.setUserAgent(this.getUserAgent());
        rlm.setFObj(this);
        list.add(rlm);
    }

    public KeepValue getKeepWithPrevious() {
        return this.keepWithPrevious;
    }

    public void doSetup() {
        AccessibilityProps mAccProps = this.propMgr.getAccessibilityProps();
        AuralProps mAurProps = this.propMgr.getAuralProps();
        BorderAndPadding bap = this.propMgr.getBorderAndPadding();
        BackgroundProps bProps = this.propMgr.getBackgroundProps();
        RelativePositionProps mRelProps = this.propMgr.getRelativePositionProps();
        this.setupID();
        this.breakAfter = this.properties.get("break-after").getEnum();
        this.backgroundColor = this.properties.get("background-color").getColorType();
        this.keepTogether = this.getKeepValue("keep-together.within-column");
        this.keepWithNext = this.getKeepValue("keep-with-next.within-column");
        this.keepWithPrevious = this.getKeepValue("keep-with-previous.within-column");
        this.minHeight = this.properties.get("height").getLength().getValue();
        this.setup = true;
    }

    private KeepValue getKeepValue(String sPropName) {
        Property p = this.properties.get(sPropName);
        Number n = p.getNumber();
        if (n != null) {
            return new KeepValue("KEEP_WITH_VALUE", n.intValue());
        }
        switch (p.getEnum()) {
            case 6: {
                return new KeepValue("KEEP_WITH_ALWAYS", 0);
            }
        }
        return new KeepValue("KEEP_WITH_AUTO", 0);
    }
}

