/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.pagination;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.fop.apps.FOPException;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.pagination.PageSequenceMaster;
import org.apache.fop.fo.pagination.Region;
import org.apache.fop.fo.pagination.Root;
import org.apache.fop.fo.pagination.SimplePageMaster;
import org.xml.sax.Attributes;

public class LayoutMasterSet
extends FObj {
    private Map simplePageMasters;
    private Map pageSequenceMasters;

    public LayoutMasterSet(FONode parent) {
        super(parent);
    }

    public void handleAttrs(Attributes attlist) throws FOPException {
        super.handleAttrs(attlist);
        if (!this.parent.getName().equals("fo:root")) {
            throw new FOPException("fo:layout-master-set must be child of fo:root, not " + this.parent.getName());
        }
        Root root = (Root)this.parent;
        root.setLayoutMasterSet(this);
        this.simplePageMasters = new HashMap();
        this.pageSequenceMasters = new HashMap();
    }

    protected void addSimplePageMaster(SimplePageMaster simplePageMaster) throws FOPException {
        if (this.existsName(simplePageMaster.getMasterName())) {
            throw new FOPException("'master-name' (" + simplePageMaster.getMasterName() + ") must be unique " + "across page-masters and page-sequence-masters");
        }
        this.simplePageMasters.put(simplePageMaster.getMasterName(), simplePageMaster);
    }

    public SimplePageMaster getSimplePageMaster(String masterName) {
        return (SimplePageMaster)this.simplePageMasters.get(masterName);
    }

    protected void addPageSequenceMaster(String masterName, PageSequenceMaster pageSequenceMaster) throws FOPException {
        if (this.existsName(masterName)) {
            throw new FOPException("'master-name' (" + masterName + ") must be unique " + "across page-masters and page-sequence-masters");
        }
        this.pageSequenceMasters.put(masterName, pageSequenceMaster);
    }

    public PageSequenceMaster getPageSequenceMaster(String masterName) {
        return (PageSequenceMaster)this.pageSequenceMasters.get(masterName);
    }

    private boolean existsName(String masterName) {
        return this.simplePageMasters.containsKey(masterName) || this.pageSequenceMasters.containsKey(masterName);
    }

    protected void checkRegionNames() throws FOPException {
        HashMap<String, String> allRegions = new HashMap<String, String>();
        Iterator spm = this.simplePageMasters.values().iterator();
        while (spm.hasNext()) {
            SimplePageMaster simplePageMaster = (SimplePageMaster)spm.next();
            Map spmRegions = simplePageMaster.getRegions();
            Iterator e = spmRegions.values().iterator();
            while (e.hasNext()) {
                String localClass;
                Region region = (Region)e.next();
                if (allRegions.containsKey(region.getRegionName()) && !(localClass = (String)allRegions.get(region.getRegionName())).equals(region.getRegionClass())) {
                    throw new FOPException("Duplicate region-names (" + region.getRegionName() + ") must map " + "to the same region-class (" + localClass + "!=" + region.getRegionClass() + ")");
                }
                allRegions.put(region.getRegionName(), region.getRegionClass());
            }
        }
    }

    protected boolean regionNameExists(String regionName) {
        Iterator e = this.simplePageMasters.values().iterator();
        while (e.hasNext()) {
            if (!((SimplePageMaster)e.next()).regionNameExists(regionName)) continue;
            return true;
        }
        return false;
    }
}

