/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.pagination;

import org.apache.fop.apps.FOPException;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.pagination.PageMasterReference;
import org.apache.fop.fo.pagination.PageSequenceMaster;
import org.apache.fop.fo.pagination.SubSequenceSpecifier;
import org.xml.sax.Attributes;

public class RepeatablePageMasterReference
extends PageMasterReference
implements SubSequenceSpecifier {
    private static final int INFINITE = -1;
    private PageSequenceMaster pageSequenceMaster;
    private int maximumRepeats;
    private int numberConsumed = 0;

    public RepeatablePageMasterReference(FONode parent) {
        super(parent);
    }

    public void handleAttrs(Attributes attlist) throws FOPException {
        super.handleAttrs(attlist);
        String mr = this.getProperty("maximum-repeats").getString();
        if (mr.equals("no-limit")) {
            this.maximumRepeats = -1;
        } else {
            try {
                this.maximumRepeats = Integer.parseInt(mr);
                if (this.maximumRepeats < 0) {
                    this.getLogger().debug("negative maximum-repeats: " + this.maximumRepeats);
                    this.maximumRepeats = 0;
                }
            }
            catch (NumberFormatException nfe) {
                throw new FOPException("Invalid number for 'maximum-repeats' property");
            }
        }
    }

    public String getNextPageMasterName(boolean isOddPage, boolean isFirstPage, boolean isEmptyPage) {
        if (this.maximumRepeats != -1) {
            if (this.numberConsumed < this.maximumRepeats) {
                ++this.numberConsumed;
            } else {
                return null;
            }
        }
        return this.getMasterName();
    }

    public void reset() {
        this.numberConsumed = 0;
    }
}

