/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.pagination;

import java.awt.Rectangle;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.fop.apps.FOPException;
import org.apache.fop.area.CTM;
import org.apache.fop.area.Page;
import org.apache.fop.area.PageViewport;
import org.apache.fop.area.RegionViewport;
import org.apache.fop.datatypes.FODimension;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.pagination.LayoutMasterSet;
import org.apache.fop.fo.pagination.Region;
import org.apache.fop.layout.MarginProps;
import org.apache.fop.layout.PageMaster;
import org.xml.sax.Attributes;

public class SimplePageMaster
extends FObj {
    private Map regions;
    private PageMaster pageMaster;
    private String masterName;

    public SimplePageMaster(FONode parent) {
        super(parent);
    }

    public void handleAttrs(Attributes attlist) throws FOPException {
        super.handleAttrs(attlist);
        if (this.parent.getName().equals("fo:layout-master-set")) {
            LayoutMasterSet layoutMasterSet = (LayoutMasterSet)this.parent;
            this.masterName = this.properties.get("master-name").getString();
            if (this.masterName == null) {
                this.getLogger().warn("simple-page-master does not have a master-name and so is being ignored");
            } else {
                layoutMasterSet.addSimplePageMaster(this);
            }
        } else {
            throw new FOPException("fo:simple-page-master must be child of fo:layout-master-set, not " + this.parent.getName());
        }
        this.regions = new HashMap(5);
    }

    protected void end() {
        int pageWidth = this.properties.get("page-width").getLength().getValue();
        int pageHeight = this.properties.get("page-height").getLength().getValue();
        MarginProps mProps = this.propMgr.getMarginProps();
        Rectangle pageRefRect = new Rectangle(mProps.marginLeft, mProps.marginTop, pageWidth - mProps.marginLeft - mProps.marginRight, pageHeight - mProps.marginTop - mProps.marginBottom);
        Page page = new Page();
        FODimension reldims = new FODimension(0, 0);
        CTM pageCTM = this.propMgr.getCTMandRelDims(pageRefRect, reldims);
        boolean bHasBody = false;
        Iterator regenum = this.regions.values().iterator();
        while (regenum.hasNext()) {
            Region r = (Region)regenum.next();
            RegionViewport rvp = r.makeRegionViewport(reldims, pageCTM);
            rvp.setRegion(r.makeRegionReferenceArea(rvp.getViewArea()));
            page.setRegion(r.getRegionAreaClass(), rvp);
            if (r.getRegionAreaClass() != 2) continue;
            bHasBody = true;
        }
        if (!bHasBody) {
            this.getLogger().error("simple-page-master has no region-body");
        }
        this.pageMaster = new PageMaster(new PageViewport(page, new Rectangle(0, 0, pageWidth, pageHeight)));
        this.children = null;
        this.properties = null;
    }

    public boolean generatesReferenceAreas() {
        return true;
    }

    public PageMaster getPageMaster() {
        return this.pageMaster;
    }

    public PageMaster getNextPageMaster() {
        return this.pageMaster;
    }

    public String getMasterName() {
        return this.masterName;
    }

    protected void addChild(FONode child) {
        if (child instanceof Region) {
            this.addRegion((Region)child);
        } else {
            this.getLogger().error("SimplePageMaster cannot have child of type " + child.getName());
        }
    }

    protected void addRegion(Region region) {
        String key = region.getRegionClass();
        if (this.regions.containsKey(key)) {
            this.getLogger().error("Only one region of class " + key + " allowed within a simple-page-master. The duplicate" + " region (" + region.getName() + ") is ignored.");
        } else {
            this.regions.put(key, region);
        }
    }

    public Region getRegion(String regionClass) {
        return (Region)this.regions.get(regionClass);
    }

    protected Map getRegions() {
        return this.regions;
    }

    protected boolean regionNameExists(String regionName) {
        Iterator regenum = this.regions.values().iterator();
        while (regenum.hasNext()) {
            Region r = (Region)regenum.next();
            if (!r.getRegionName().equals(regionName)) continue;
            return true;
        }
        return false;
    }
}

