/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.image;

import java.awt.color.ColorSpace;
import java.awt.color.ICC_Profile;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.apache.fop.fo.FOUserAgent;
import org.apache.fop.image.AbstractFopImage;
import org.apache.fop.image.FopImage;

public class JpegImage
extends AbstractFopImage {
    private ICC_Profile iccProfile = null;
    private boolean foundICCProfile = false;
    private boolean foundDimensions = false;

    public JpegImage(FopImage.ImageInfo imgInfo) {
        super(imgInfo);
    }

    /*
     * WARNING - void declaration
     */
    protected boolean loadOriginalData(FOUserAgent ua) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ByteArrayOutputStream iccStream = new ByteArrayOutputStream();
        int index = 0;
        boolean cont = true;
        try {
            int bytesRead;
            byte[] readBuf = new byte[4096];
            while ((bytesRead = this.inputStream.read(readBuf)) != -1) {
                void var7_8;
                baos.write(readBuf, 0, (int)var7_8);
            }
            this.inputStream.close();
            this.inputStream = null;
        }
        catch (IOException ex) {
            ua.getLogger().error("Error while loading image  : " + ex.getClass() + " - " + ex.getMessage(), (Throwable)ex);
            return false;
        }
        this.bitmaps = baos.toByteArray();
        this.bitsPerPixel = 8;
        this.isTransparent = false;
        if (this.bitmaps.length > index + 2 && this.uByte(this.bitmaps[index]) == 255 && this.uByte(this.bitmaps[index + 1]) == 216) {
            index += 2;
            while (index < this.bitmaps.length && cont) {
                if (this.bitmaps.length > index + 2 && this.uByte(this.bitmaps[index]) == 255) {
                    if (this.uByte(this.bitmaps[index + 1]) == 192 || this.uByte(this.bitmaps[index + 1]) == 194) {
                        this.height = this.calcBytes(this.bitmaps[index + 5], this.bitmaps[index + 6]);
                        this.width = this.calcBytes(this.bitmaps[index + 7], this.bitmaps[index + 8]);
                        if (this.bitmaps[index + 9] == 1) {
                            this.colorSpace = ColorSpace.getInstance(1003);
                        } else if (this.bitmaps[index + 9] == 3) {
                            this.colorSpace = ColorSpace.getInstance(1004);
                        } else if (this.bitmaps[index + 9] == 4) {
                            this.colorSpace = ColorSpace.getInstance(1001);
                        } else {
                            ua.getLogger().error("Unknown ColorSpace for image: ");
                            return false;
                        }
                        this.foundDimensions = true;
                        if (this.foundICCProfile) {
                            cont = false;
                            break;
                        }
                        index += this.calcBytes(this.bitmaps[index + 2], this.bitmaps[index + 3]) + 2;
                        continue;
                    }
                    if (this.uByte(this.bitmaps[index + 1]) == 226 && this.bitmaps.length > index + 60) {
                        byte[] iccString = new byte[11];
                        System.arraycopy(this.bitmaps, index + 4, iccString, 0, 11);
                        if ("ICC_PROFILE".equals(new String(iccString))) {
                            int chunkSize = this.calcBytes(this.bitmaps[index + 2], this.bitmaps[index + 3]) + 2;
                            iccStream.write(this.bitmaps, index + 18, chunkSize - 18);
                        }
                        index += this.calcBytes(this.bitmaps[index + 2], this.bitmaps[index + 3]) + 2;
                        continue;
                    }
                    index += this.calcBytes(this.bitmaps[index + 2], this.bitmaps[index + 3]) + 2;
                    continue;
                }
                cont = false;
            }
        } else {
            ua.getLogger().error("Error while loading JpegImage - Invalid JPEG Header.");
            return false;
        }
        if (iccStream.size() > 0) {
            byte[] align = new byte[iccStream.size() % 8 + 8];
            try {
                iccStream.write(align);
            }
            catch (Exception e) {
                ua.getLogger().error("Error while loading image  : " + e.getMessage(), (Throwable)e);
                return false;
            }
            try {
                this.iccProfile = ICC_Profile.getInstance(iccStream.toByteArray());
            }
            catch (Exception e) {
                ua.getLogger().error("Invalid ICC profile: " + e, (Throwable)e);
                return false;
            }
        }
        if (this.colorSpace == null) {
            ua.getLogger().error("ColorSpace not specified for JPEG image");
            return false;
        }
        return true;
    }

    public ICC_Profile getICCProfile() {
        return this.iccProfile;
    }

    private int calcBytes(byte bOne, byte bTwo) {
        return this.uByte(bOne) * 256 + this.uByte(bTwo);
    }

    private int uByte(byte bIn) {
        if (bIn < 0) {
            return 256 + bIn;
        }
        return bIn;
    }
}

