/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr;

import org.apache.fop.area.Area;
import org.apache.fop.area.Block;
import org.apache.fop.area.BlockParent;
import org.apache.fop.layoutmgr.AbstractLayoutManager;
import org.apache.fop.layoutmgr.BreakCost;
import org.apache.fop.layoutmgr.LayoutProcessor;
import org.apache.fop.layoutmgr.MinOptMax;
import org.apache.fop.layoutmgr.SpaceSpecifier;

public abstract class BlockStackingLayoutManager
extends AbstractLayoutManager {
    protected LayoutProcessor curChildLM = null;
    protected BlockParent parentArea = null;

    private BreakCost evaluateBreakCost(Area parent, Area child) {
        return new BreakCost(child, 0);
    }

    protected BlockParent getCurrentArea() {
        return this.parentArea;
    }

    protected void setCurrentArea(BlockParent parentArea) {
        this.parentArea = parentArea;
    }

    protected MinOptMax resolveSpaceSpecifier(Area nextArea) {
        SpaceSpecifier spaceSpec = new SpaceSpecifier(false);
        return spaceSpec.resolve(false);
    }

    public void addBlockSpacing(double adjust, MinOptMax minoptmax) {
        int sp = minoptmax.opt;
        sp = adjust > 0.0 ? (sp += (int)(adjust * (double)(minoptmax.max - minoptmax.opt))) : (sp += (int)(adjust * (double)(minoptmax.opt - minoptmax.min)));
        if (sp != 0) {
            Block spacer = new Block();
            spacer.setHeight(sp);
            this.parentLM.addChild(spacer);
        }
    }

    protected void addChildToArea(Area childArea, BlockParent parentArea) {
        if (!(childArea instanceof Block)) {
            // empty if block
        }
        MinOptMax spaceBefore = this.resolveSpaceSpecifier(childArea);
        parentArea.addBlock((Block)childArea);
        this.flush();
    }

    public void addChild(Area childArea) {
        this.addChildToArea(childArea, this.getCurrentArea());
    }

    protected void flush() {
        if (this.getCurrentArea() != null) {
            this.parentLM.addChild(this.getCurrentArea());
        }
    }
}

