/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.apache.fop.area.LineArea;
import org.apache.fop.area.Resolveable;
import org.apache.fop.fo.PropertyManager;
import org.apache.fop.layout.HyphenationProps;
import org.apache.fop.layout.MarginProps;
import org.apache.fop.layout.hyphenation.Hyphenation;
import org.apache.fop.layout.hyphenation.Hyphenator;
import org.apache.fop.layoutmgr.BreakCost;
import org.apache.fop.layoutmgr.BreakPoss;
import org.apache.fop.layoutmgr.BreakPossPosIter;
import org.apache.fop.layoutmgr.HyphContext;
import org.apache.fop.layoutmgr.InlineStackingLayoutManager;
import org.apache.fop.layoutmgr.LayoutContext;
import org.apache.fop.layoutmgr.LayoutProcessor;
import org.apache.fop.layoutmgr.LeafPosition;
import org.apache.fop.layoutmgr.MinOptMax;
import org.apache.fop.layoutmgr.Position;
import org.apache.fop.layoutmgr.PositionIterator;
import org.apache.fop.layoutmgr.SpaceSpecifier;
import org.apache.fop.traits.BlockProps;

public class LineLayoutManager
extends InlineStackingLayoutManager {
    private List vecInlineBreaks = new ArrayList();
    private BreakPoss prevBP = null;
    private int bTextAlignment = 42;
    private int iTextIndent = 0;
    private int iIndents = 0;
    private HyphenationProps hyphProps;
    private int lineHeight;
    private int lead;
    private int follow;
    private int iStartPos = 0;

    public LineLayoutManager(int lh, int l, int f) {
        this.lineHeight = lh;
        this.lead = l;
        this.follow = f;
        this.init();
    }

    protected void initProperties(PropertyManager propMgr) {
        MarginProps marginProps = propMgr.getMarginProps();
        this.iIndents = marginProps.startIndent + marginProps.endIndent;
        BlockProps blockProps = propMgr.getBlockProps();
        this.bTextAlignment = blockProps.textAlign;
        this.iTextIndent = blockProps.firstIndent;
        this.hyphProps = propMgr.getHyphenationProps();
    }

    /*
     * WARNING - void declaration
     */
    public BreakPoss getNextBreakPoss(LayoutContext context) {
        LayoutProcessor curLM;
        BreakPoss prev = null;
        BreakPoss bp = null;
        ArrayList<BreakCost> vecPossEnd = new ArrayList<BreakCost>();
        MinOptMax availIPD = context.getStackLimit();
        LayoutContext inlineLC = new LayoutContext(context);
        this.clearPrevIPD();
        int iPrevLineEnd = this.vecInlineBreaks.size();
        this.prevBP = null;
        while ((curLM = this.getChildLM()) != null) {
            void var2_8;
            boolean bFirstBPforLM = this.vecInlineBreaks.isEmpty() || ((BreakPoss)this.vecInlineBreaks.get(this.vecInlineBreaks.size() - 1)).getLayoutManager() != var2_8;
            prev = this.vecInlineBreaks.isEmpty() ? null : (BreakPoss)this.vecInlineBreaks.get(this.vecInlineBreaks.size() - 1);
            this.initChildLC(inlineLC, prev, this.vecInlineBreaks.size() == iPrevLineEnd, bFirstBPforLM, new SpaceSpecifier(true));
            inlineLC.setFlags(16, this.vecInlineBreaks.size() == iPrevLineEnd && !this.vecInlineBreaks.isEmpty() && !((BreakPoss)this.vecInlineBreaks.get(this.vecInlineBreaks.size() - 1)).isForcedBreak());
            bp = var2_8.getNextBreakPoss(inlineLC);
            if (bp != null) {
                MinOptMax prevIPD = this.updatePrevIPD(bp, prev, this.vecInlineBreaks.size() == iPrevLineEnd, inlineLC.isFirstArea());
                MinOptMax bpDim = MinOptMax.add(bp.getStackingSize(), prevIPD);
                boolean bBreakOK = this.couldEndLine(bp);
                if (bBreakOK) {
                    bpDim.add(bp.resolveTrailingSpace(true));
                }
                if (bpDim.min > availIPD.max) {
                    if (this.bTextAlignment != 42 && this.prevBP != null || inlineLC.tryHyphenate()) break;
                    if (!bBreakOK) {
                        this.vecInlineBreaks.add(bp);
                        continue;
                    }
                    inlineLC.setHyphContext(this.getHyphenContext(this.prevBP, bp));
                    if (inlineLC.getHyphContext() == null) break;
                    inlineLC.setFlags(64, true);
                    this.reset();
                } else {
                    this.vecInlineBreaks.add(bp);
                    if (bBreakOK) {
                        this.prevBP = bp;
                        if (bp.isForcedBreak()) break;
                        if (bpDim.max >= availIPD.min) {
                            vecPossEnd.add(new BreakCost(bp, Math.abs(availIPD.opt - bpDim.opt)));
                        }
                    }
                }
            }
            if (inlineLC.tryHyphenate() && !inlineLC.getHyphContext().hasMoreHyphPoints()) break;
        }
        if ((curLM = this.getChildLM()) == null) {
            this.setFinished(true);
        }
        if (bp == null) {
            return null;
        }
        if (this.prevBP == null) {
            this.prevBP = bp;
        }
        if (!bp.isForcedBreak() && vecPossEnd.size() > 0) {
            this.prevBP = this.getBestBP(vecPossEnd);
        }
        if (bp != this.prevBP && !bp.couldEndLine()) {
            this.reset();
        }
        int talign = this.bTextAlignment;
        if (this.bTextAlignment == 42 && (this.prevBP.isForcedBreak() || this.isFinished())) {
            talign = 87;
        }
        return this.makeLineBreak(iPrevLineEnd, availIPD, talign);
    }

    private void reset() {
        while (this.vecInlineBreaks.get(this.vecInlineBreaks.size() - 1) != this.prevBP) {
            this.vecInlineBreaks.remove(this.vecInlineBreaks.size() - 1);
        }
        this.reset(this.prevBP.getPosition());
    }

    protected boolean couldEndLine(BreakPoss bp) {
        if (bp.canBreakAfter()) {
            return true;
        }
        if (bp.isSuppressible()) {
            return false;
        }
        LayoutContext lc = new LayoutContext(0);
        LayoutProcessor nextLM = this.getChildLM();
        return nextLM == null || nextLM.canBreakBefore(lc);
    }

    private BreakPoss getBestBP(ArrayList vecPossEnd) {
        if (vecPossEnd.size() == 1) {
            return ((BreakCost)vecPossEnd.get(0)).getBP();
        }
        Iterator iter = vecPossEnd.iterator();
        int minCost = Integer.MAX_VALUE;
        BreakPoss bestBP = null;
        while (iter.hasNext()) {
            BreakCost bc = (BreakCost)iter.next();
            if (bc.getCost() >= minCost) continue;
            minCost = bc.getCost();
            bestBP = bc.getBP();
        }
        return bestBP;
    }

    protected boolean hasLeadingFence(boolean bNotFirst) {
        return true;
    }

    protected boolean hasTrailingFence(boolean bNotLast) {
        return true;
    }

    private HyphContext getHyphenContext(BreakPoss prev, BreakPoss newBP) {
        this.vecInlineBreaks.add(newBP);
        ListIterator bpIter = this.vecInlineBreaks.listIterator(this.vecInlineBreaks.size());
        while (bpIter.hasPrevious() && bpIter.previous() != prev) {
        }
        if (bpIter.next() != prev) {
            this.getLogger().error("findHyphenPoss: problem!");
            return null;
        }
        StringBuffer sbChars = new StringBuffer(30);
        while (bpIter.hasNext()) {
            BreakPoss bp = (BreakPoss)bpIter.next();
            if (bp.getLayoutManager() == prev.getLayoutManager()) {
                bp.getLayoutManager().getWordChars(sbChars, prev.getPosition(), bp.getPosition());
            } else {
                bp.getLayoutManager().getWordChars(sbChars, null, bp.getPosition());
            }
            prev = bp;
        }
        this.vecInlineBreaks.remove(this.vecInlineBreaks.size() - 1);
        this.getLogger().debug("Word to hyphenate: " + sbChars.toString());
        Hyphenation hyph = Hyphenator.hyphenate(this.hyphProps.language, this.hyphProps.country, sbChars.toString(), this.hyphProps.hyphenationRemainCharacterCount, this.hyphProps.hyphenationPushCharacterCount);
        if (hyph != null) {
            return new HyphContext(hyph.getHyphenationPoints());
        }
        return null;
    }

    private BreakPoss makeLineBreak(int prevLineEnd, MinOptMax target, int textalign) {
        int maxtb;
        int halfLeading = (this.lineHeight - this.lead - this.follow) / 2;
        int lineLead = this.lead + halfLeading;
        int middlefollow = maxtb = this.follow + halfLeading;
        MinOptMax actual = new MinOptMax();
        BreakPoss lastBP = null;
        LayoutProcessor lastLM = null;
        ListIterator iter = this.vecInlineBreaks.listIterator(prevLineEnd);
        while (iter.hasNext()) {
            BreakPoss bp = (BreakPoss)iter.next();
            if (bp.getLead() > lineLead) {
                lineLead = bp.getLead();
            }
            if (bp.getTotal() > maxtb) {
                maxtb = bp.getTotal();
            }
            if (bp.getMiddle() > middlefollow) {
                middlefollow = bp.getMiddle();
            }
            if (bp.getLayoutManager() != lastLM) {
                if (lastLM != null) {
                    actual.add(lastBP.getStackingSize());
                }
                lastLM = bp.getLayoutManager();
            }
            lastBP = bp;
        }
        if (lastBP != null) {
            actual.add(lastBP.getStackingSize());
            actual.add(lastBP.resolveTrailingSpace(true));
        }
        if (maxtb - lineLead > middlefollow) {
            middlefollow = maxtb - lineLead;
        }
        double ipdAdjust = 0.0;
        int targetWith = target.opt;
        int realWidth = actual.opt;
        if (actual.opt > targetWith) {
            if (actual.opt - targetWith < actual.opt - actual.min) {
                ipdAdjust = (float)(-(actual.opt - targetWith)) / (float)(actual.opt - actual.min);
                realWidth = targetWith;
            } else {
                ipdAdjust = -1.0;
                realWidth = actual.max;
            }
        } else if (targetWith - actual.opt < actual.max - actual.opt) {
            ipdAdjust = (float)(targetWith - actual.opt) / (float)(actual.max - actual.opt);
            realWidth = targetWith;
        } else {
            ipdAdjust = 1.0;
            realWidth = actual.min;
        }
        double dAdjust = 0.0;
        int indent = 0;
        switch (textalign) {
            case 42: {
                if (realWidth == 0) break;
                dAdjust = (targetWith - realWidth) / realWidth;
                break;
            }
            case 87: {
                break;
            }
            case 14: {
                indent = (targetWith - realWidth) / 2;
                break;
            }
            case 23: {
                indent = targetWith - realWidth;
            }
        }
        LineBreakPosition lbp = new LineBreakPosition(this, this.vecInlineBreaks.size() - 1, ipdAdjust, dAdjust, indent, lineLead + middlefollow, lineLead);
        BreakPoss curLineBP = new BreakPoss(lbp);
        curLineBP.setFlag(2, this.isFinished());
        curLineBP.setStackingSize(new MinOptMax(lineLead + middlefollow));
        return curLineBP;
    }

    public void resetPosition(Position resetPos) {
        if (resetPos == null) {
            this.iStartPos = 0;
            this.reset(null);
            this.vecInlineBreaks.clear();
            this.prevBP = null;
        } else {
            this.prevBP = (BreakPoss)this.vecInlineBreaks.get(((LineBreakPosition)resetPos).getLeafPos());
            while (this.vecInlineBreaks.get(this.vecInlineBreaks.size() - 1) != this.prevBP) {
                this.vecInlineBreaks.remove(this.vecInlineBreaks.size() - 1);
            }
            this.reset(this.prevBP.getPosition());
        }
    }

    public void addAreas(PositionIterator parentIter, LayoutContext context) {
        this.addAreas(parentIter, 0.0);
        this.prevBP = null;
    }

    /*
     * WARNING - void declaration
     */
    public void addAreas(PositionIterator parentIter, double dSpaceAdjust) {
        LayoutContext lc = new LayoutContext(0);
        while (parentIter.hasNext()) {
            LayoutProcessor childLM;
            LineBreakPosition lbp = (LineBreakPosition)parentIter.next();
            LineArea lineArea = new LineArea();
            lineArea.setStartIndent(lbp.startIndent);
            lineArea.setHeight(lbp.lineHeight);
            lc.setBaseline(lbp.baseline);
            lc.setLineHeight(lbp.lineHeight);
            this.setCurrentArea(lineArea);
            BreakPossPosIter inlinePosIter = new BreakPossPosIter(this.vecInlineBreaks, this.iStartPos, lbp.getLeafPos() + 1);
            this.iStartPos = lbp.getLeafPos() + 1;
            lc.setSpaceAdjust(lbp.dAdjust);
            lc.setIPDAdjust(lbp.ipdAdjust);
            lc.setLeadingSpace(new SpaceSpecifier(true));
            lc.setFlags(256, true);
            this.setChildContext(lc);
            while ((childLM = inlinePosIter.getNextChildLM()) != null) {
                void var4_4;
                var4_4.addAreas(inlinePosIter, lc);
                lc.setLeadingSpace(lc.getTrailingSpace());
                lc.setTrailingSpace(new SpaceSpecifier(false));
            }
            if (lc.getTrailingSpace() != null) {
                this.addSpace(lineArea, lc.getTrailingSpace().resolve(true), lc.getSpaceAdjust());
            }
            this.parentLM.addChild(lineArea);
        }
        this.setCurrentArea(null);
    }

    public void addUnresolvedArea(String id, Resolveable res) {
        this.parentLM.addUnresolvedArea(id, res);
    }

    private static class LineBreakPosition
    extends LeafPosition {
        double dAdjust;
        double ipdAdjust;
        int startIndent;
        int lineHeight;
        int baseline;

        LineBreakPosition(LayoutProcessor lm, int iBreakIndex, double ipdA, double adjust, int ind, int lh, int bl) {
            super(lm, iBreakIndex);
            this.ipdAdjust = ipdA;
            this.dAdjust = adjust;
            this.startIndent = ind;
            this.lineHeight = lh;
            this.baseline = bl;
        }
    }
}

