/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.fop.area.Area;
import org.apache.fop.area.Block;
import org.apache.fop.area.RegionReference;
import org.apache.fop.layoutmgr.BlockStackingLayoutManager;
import org.apache.fop.layoutmgr.BreakPoss;
import org.apache.fop.layoutmgr.BreakPossPosIter;
import org.apache.fop.layoutmgr.LayoutContext;
import org.apache.fop.layoutmgr.LayoutProcessor;
import org.apache.fop.layoutmgr.LeafPosition;
import org.apache.fop.layoutmgr.PositionIterator;

public class StaticContentLayoutManager
extends BlockStackingLayoutManager {
    private RegionReference region;
    private List blockBreaks = new ArrayList();

    public void setRegionReference(RegionReference region) {
        this.region = region;
    }

    /*
     * WARNING - void declaration
     */
    public BreakPoss getNextBreakPoss(LayoutContext context) {
        LayoutProcessor curLM;
        while ((curLM = this.getChildLM()) != null) {
            BreakPoss bp;
            void var2_2;
            LayoutContext childLC = context;
            if (var2_2.isFinished() || (bp = var2_2.getNextBreakPoss(childLC)) == null) continue;
            this.blockBreaks.add(bp);
            if (!bp.isForcedBreak()) continue;
            this.getLogger().error("Forced breaks are not allowed in static content - ignoring");
            return null;
        }
        this.setFinished(true);
        if (this.blockBreaks.size() > 0) {
            return new BreakPoss(new LeafPosition(this, this.blockBreaks.size() - 1));
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public void addAreas(PositionIterator parentIter, LayoutContext layoutContext) {
        int iStartPos = 0;
        LayoutContext lc = new LayoutContext(0);
        while (parentIter.hasNext()) {
            LayoutProcessor childLM;
            LeafPosition lfp = (LeafPosition)parentIter.next();
            BreakPossPosIter breakPosIter = new BreakPossPosIter(this.blockBreaks, iStartPos, lfp.getLeafPos() + 1);
            iStartPos = lfp.getLeafPos() + 1;
            while ((childLM = breakPosIter.getNextChildLM()) != null) {
                void var3_5;
                var3_5.addAreas(breakPosIter, lc);
            }
        }
        this.blockBreaks.clear();
        this.flush();
        this.region = null;
    }

    public void addChild(Area childArea) {
        this.region.addBlock((Block)childArea);
    }

    public Area getParentArea(Area childArea) {
        return this.region;
    }

    public void addMarker(Map marks, boolean start, boolean isfirst) {
        this.getLogger().error("Cannot add marker to static areas");
    }
}

