/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr;

import java.util.ArrayList;
import org.apache.fop.area.Trait;
import org.apache.fop.area.inline.InlineArea;
import org.apache.fop.area.inline.Space;
import org.apache.fop.area.inline.Word;
import org.apache.fop.fo.TextInfo;
import org.apache.fop.layoutmgr.AbstractLayoutManager;
import org.apache.fop.layoutmgr.BreakPoss;
import org.apache.fop.layoutmgr.HyphContext;
import org.apache.fop.layoutmgr.LayoutContext;
import org.apache.fop.layoutmgr.LeafPosition;
import org.apache.fop.layoutmgr.MinOptMax;
import org.apache.fop.layoutmgr.Position;
import org.apache.fop.layoutmgr.PositionIterator;
import org.apache.fop.layoutmgr.SpaceSpecifier;
import org.apache.fop.traits.SpaceVal;
import org.apache.fop.util.CharUtilities;

public class TextLayoutManager
extends AbstractLayoutManager {
    private ArrayList vecAreaInfo;
    private static final String BREAK_CHARS = "-/";
    private char[] chars;
    private TextInfo textInfo;
    private static final char NEWLINE = '\n';
    private static final char SPACE = ' ';
    private static final char NBSPACE = '\u00a0';
    private static final char LINEBREAK = '\u2028';
    private static final char ZERO_WIDTH_SPACE = '\u200b';
    private static final char ZERO_WIDTH_NOBREAK_SPACE = '\ufeff';
    private short iAreaStart = 0;
    private short iNextStart = 0;
    private MinOptMax ipdTotal;
    private int spaceCharIPD;
    private int hyphIPD;
    private SpaceVal halfWS;
    private int iNbSpacesPending;

    public TextLayoutManager(char[] chars, TextInfo textInfo) {
        this.chars = chars;
        this.textInfo = textInfo;
        this.vecAreaInfo = new ArrayList();
        this.spaceCharIPD = CharUtilities.getCharWidth(' ', textInfo.fs);
        this.hyphIPD = CharUtilities.getCharWidth('-', textInfo.fs);
        SpaceVal ws = textInfo.wordSpacing;
        this.halfWS = new SpaceVal(MinOptMax.multiply(ws.getSpace(), 0.5), ws.isConditional(), ws.isForcing(), ws.getPrecedence());
    }

    public boolean generatesInlineAreas() {
        return true;
    }

    public void getWordChars(StringBuffer sbChars, Position bp1, Position bp2) {
        LeafPosition endPos = (LeafPosition)bp2;
        AreaInfo ai = (AreaInfo)this.vecAreaInfo.get(endPos.getLeafPos());
        int i = ai.iStartIndex;
        while (i < ai.iBreakIndex && CharUtilities.isAnySpace(this.chars[i])) {
            ++i;
        }
        sbChars.append(new String(this.chars, i, ai.iBreakIndex - i));
    }

    public boolean canBreakBefore(LayoutContext context) {
        char c = this.chars[this.iNextStart];
        return c == '\n' || this.textInfo.bWrap && (CharUtilities.isSpace(c) || BREAK_CHARS.indexOf(c) >= 0);
    }

    public void resetPosition(Position prevPos) {
        if (prevPos != null) {
            LeafPosition tbp;
            AreaInfo ai;
            if (prevPos.getLM() != this) {
                this.getLogger().error("TextLayoutManager.resetPosition: LM mismatch!!!");
            }
            if ((ai = (AreaInfo)this.vecAreaInfo.get((tbp = (LeafPosition)prevPos).getLeafPos())).iBreakIndex != this.iNextStart) {
                this.iNextStart = ai.iBreakIndex;
                this.vecAreaInfo.ensureCapacity(tbp.getLeafPos() + 1);
                this.ipdTotal = ai.ipdArea;
                this.setFinished(false);
            }
        } else {
            this.vecAreaInfo.clear();
            this.iNextStart = 0;
            this.setFinished(false);
        }
    }

    private boolean getHyphenIPD(HyphContext hc, MinOptMax hyphIPD) {
        boolean bCanHyphenate = true;
        int iStopIndex = this.iNextStart + hc.getNextHyphPoint();
        if (this.chars.length < iStopIndex || !this.textInfo.bCanHyphenate) {
            iStopIndex = this.chars.length;
            bCanHyphenate = false;
        }
        hc.updateOffset(iStopIndex - this.iNextStart);
        while (this.iNextStart < iStopIndex) {
            char c = this.chars[this.iNextStart];
            hyphIPD.opt += CharUtilities.getCharWidth(c, this.textInfo.fs);
            this.iNextStart = (short)(this.iNextStart + 1);
        }
        return bCanHyphenate;
    }

    /*
     * Unable to fully structure code
     */
    public BreakPoss getNextBreakPoss(LayoutContext context) {
        block22: {
            iFlags = 0;
            if (context.startsNewArea()) {
                this.ipdTotal = new MinOptMax(0);
                iFlags |= 4;
            }
            if (context.suppressLeadingSpace()) {
                while (this.iNextStart < this.chars.length && this.chars[this.iNextStart] == ' ') {
                    this.iNextStart = (short)(this.iNextStart + 1);
                }
                if (this.iNextStart >= this.chars.length) {
                    this.setFinished(true);
                    return null;
                }
            }
            pendingSpace = new SpaceSpecifier(false);
            iThisStart = this.iNextStart;
            spaceIPD = new MinOptMax(0);
            wordIPD = 0;
            iWScount = 0;
            bSawNonSuppressible = false;
            while (this.iNextStart < this.chars.length) {
                c = this.chars[this.iNextStart];
                if (!CharUtilities.isAnySpace(c)) break;
                if (c == ' ' || c == '\u00a0') {
                    iWScount = (short)(iWScount + 1);
                    if (this.iNextStart == iThisStart && (iFlags & 4) != 0) {
                        if (context.getLeadingSpace().hasSpaces()) {
                            context.getLeadingSpace().addSpace(this.halfWS);
                        } else {
                            spaceIPD.add(this.halfWS.getSpace());
                        }
                    } else {
                        pendingSpace.addSpace(this.halfWS);
                        spaceIPD.add(pendingSpace.resolve(false));
                    }
                    wordIPD += this.spaceCharIPD;
                    pendingSpace.clear();
                    pendingSpace.addSpace(this.halfWS);
                    if (c == '\u00a0') {
                        bSawNonSuppressible = true;
                    }
                } else {
                    bSawNonSuppressible = true;
                    spaceIPD.add(pendingSpace.resolve(false));
                    pendingSpace.clear();
                    wordIPD += CharUtilities.getCharWidth(c, this.textInfo.fs);
                }
                this.iNextStart = (short)(this.iNextStart + 1);
            }
            if (this.iNextStart >= this.chars.length) {
                if (!bSawNonSuppressible) {
                    iFlags |= 128;
                }
                return this.makeBreakPoss(iThisStart, spaceIPD, wordIPD, context.getLeadingSpace(), pendingSpace, iFlags, iWScount);
            }
            spaceIPD.add(pendingSpace.resolve(false));
            if (!context.tryHyphenate()) ** GOTO lbl72
            hyphIPD = new MinOptMax(0);
            if (this.getHyphenIPD(context.getHyphContext(), hyphIPD)) {
                iFlags |= 257;
            }
            wordIPD += hyphIPD.opt;
            break block22;
lbl-1000:
            // 1 sources

            {
                c = this.chars[this.iNextStart];
                if (c == '\n' || this.textInfo.bWrap && (CharUtilities.isSpace(c) || "-/".indexOf(c) >= 0)) {
                    iFlags |= 1;
                    if (c != ' ') {
                        this.iNextStart = (short)(this.iNextStart + 1);
                        if (c != '\n') {
                            wordIPD += CharUtilities.getCharWidth(c, this.textInfo.fs);
                        } else {
                            iFlags |= 8;
                        }
                    }
                    iLastChar = this.iNextStart;
                    while (iLastChar < this.chars.length && this.chars[iLastChar] == ' ') {
                        ++iLastChar;
                    }
                    if (iLastChar == this.chars.length) {
                        iFlags |= 512;
                    }
                    return this.makeBreakPoss(iThisStart, spaceIPD, wordIPD, context.getLeadingSpace(), null, iFlags, iWScount);
                }
                wordIPD += CharUtilities.getCharWidth(c, this.textInfo.fs);
                this.iNextStart = (short)(this.iNextStart + 1);
lbl72:
                // 2 sources

                ** while (this.iNextStart < this.chars.length)
            }
        }
        return this.makeBreakPoss(iThisStart, spaceIPD, wordIPD, context.getLeadingSpace(), null, iFlags, iWScount);
    }

    private BreakPoss makeBreakPoss(short iWordStart, MinOptMax spaceIPD, int wordDim, SpaceSpecifier leadingSpace, SpaceSpecifier trailingSpace, int flags, short iWScount) {
        MinOptMax ipd = new MinOptMax(wordDim);
        ipd.add(spaceIPD);
        if (this.ipdTotal != null) {
            ipd.add(this.ipdTotal);
        }
        this.vecAreaInfo.add(new AreaInfo(iWordStart, this.iNextStart, iWScount, ipd));
        BreakPoss bp = new BreakPoss(new LeafPosition(this, this.vecAreaInfo.size() - 1));
        this.ipdTotal = ipd;
        if ((flags & 0x100) != 0) {
            bp.setStackingSize(MinOptMax.add(ipd, new MinOptMax(this.hyphIPD)));
        } else {
            bp.setStackingSize(ipd);
        }
        bp.setNonStackingSize(new MinOptMax(this.textInfo.lineHeight));
        if (this.iNextStart == this.chars.length) {
            flags |= 2;
            this.setFinished(true);
        }
        bp.setFlag(flags);
        if (trailingSpace != null) {
            bp.setTrailingSpace(trailingSpace);
        } else {
            bp.setTrailingSpace(new SpaceSpecifier(false));
        }
        if (leadingSpace != null) {
            bp.setLeadingSpace(leadingSpace);
        } else {
            bp.setLeadingSpace(new SpaceSpecifier(false));
        }
        return bp;
    }

    public void addAreas(PositionIterator posIter, LayoutContext context) {
        String str;
        AreaInfo ai = null;
        int iStart = -1;
        int iWScount = 0;
        while (posIter.hasNext()) {
            LeafPosition tbpNext = (LeafPosition)posIter.next();
            ai = (AreaInfo)this.vecAreaInfo.get(tbpNext.getLeafPos());
            if (iStart == -1) {
                iStart = ai.iStartIndex;
            }
            iWScount += ai.iWScount;
        }
        if (ai == null) {
            return;
        }
        int iAdjust = 0;
        double dSpaceAdjust = context.getSpaceAdjust();
        if (dSpaceAdjust > 0.0) {
            iAdjust = (int)((double)(((AreaInfo)ai).ipdArea.max - ((AreaInfo)ai).ipdArea.opt) * dSpaceAdjust);
        } else if (dSpaceAdjust < 0.0) {
            iAdjust = (int)((double)(((AreaInfo)ai).ipdArea.opt - ((AreaInfo)ai).ipdArea.min) * dSpaceAdjust);
        }
        InlineArea word = null;
        int adjust = 0;
        if (this.chars[ai.iBreakIndex - 1] == '\n') {
            adjust = 1;
        }
        if (" ".equals(str = new String(this.chars, iStart, ai.iBreakIndex - iStart - adjust))) {
            word = new Space();
            word.setWidth(((AreaInfo)ai).ipdArea.opt + iAdjust);
        } else {
            Word w = this.createWord(str, ((AreaInfo)ai).ipdArea.opt + iAdjust, context.getBaseline());
            if (iWScount > 0) {
                w.setWSadjust(iAdjust / iWScount);
            }
            word = w;
        }
        if ((this.chars[iStart] == ' ' || this.chars[iStart] == '\u00a0') && context.getLeadingSpace().hasSpaces()) {
            context.getLeadingSpace().addSpace(this.halfWS);
        }
        int iLastChar = ai.iBreakIndex;
        while (iLastChar < this.chars.length && this.chars[iLastChar] == ' ') {
            ++iLastChar;
        }
        context.setFlags(128, iLastChar == this.chars.length);
        context.setTrailingSpace(new SpaceSpecifier(false));
        if (this.chars[ai.iBreakIndex - 1] == ' ' || this.chars[ai.iBreakIndex - 1] == '\u00a0') {
            context.getTrailingSpace().addSpace(this.halfWS);
        }
        if (word != null) {
            this.parentLM.addChild(word);
        }
    }

    protected Word createWord(String str, int width, int base) {
        Word curWordArea = new Word();
        curWordArea.setWidth(width);
        curWordArea.setHeight(this.textInfo.fs.getAscender() - this.textInfo.fs.getDescender());
        curWordArea.setOffset(this.textInfo.fs.getAscender());
        curWordArea.setOffset(base);
        curWordArea.setWord(str);
        curWordArea.addTrait(Trait.FONT_NAME, this.textInfo.fs.getFontName());
        curWordArea.addTrait(Trait.FONT_SIZE, new Integer(this.textInfo.fs.getFontSize()));
        curWordArea.addTrait(Trait.COLOR, this.textInfo.color);
        return curWordArea;
    }

    private class AreaInfo {
        private short iStartIndex;
        private short iBreakIndex;
        private short iWScount;
        private MinOptMax ipdArea;

        public AreaInfo(short iSIndex, short iBIndex, short iWS, MinOptMax ipd) {
            this.iStartIndex = iSIndex;
            this.iBreakIndex = iBIndex;
            this.iWScount = iWS;
            this.ipdArea = ipd;
        }
    }
}

