/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr.list;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.fop.area.Area;
import org.apache.fop.area.Block;
import org.apache.fop.fo.PropertyManager;
import org.apache.fop.layout.BackgroundProps;
import org.apache.fop.layout.BorderAndPadding;
import org.apache.fop.layoutmgr.BlockStackingLayoutManager;
import org.apache.fop.layoutmgr.BreakPoss;
import org.apache.fop.layoutmgr.BreakPossPosIter;
import org.apache.fop.layoutmgr.LayoutContext;
import org.apache.fop.layoutmgr.LayoutProcessor;
import org.apache.fop.layoutmgr.LeafPosition;
import org.apache.fop.layoutmgr.MinOptMax;
import org.apache.fop.layoutmgr.Position;
import org.apache.fop.layoutmgr.PositionIterator;
import org.apache.fop.layoutmgr.list.Item;

public class ListItemLayoutManager
extends BlockStackingLayoutManager {
    private Item label;
    private Item body;
    private Block curBlockArea = null;
    private List cellList = null;
    private int listItemHeight;
    private BorderAndPadding borderProps = null;
    private BackgroundProps backgroundProps;

    protected void initProperties(PropertyManager propMgr) {
        this.borderProps = propMgr.getBorderAndPadding();
        this.backgroundProps = propMgr.getBackgroundProps();
    }

    public void setLabel(Item item) {
        this.label = item;
        this.label.setParent(this);
    }

    public void setBody(Item item) {
        this.body = item;
        this.body.setParent(this);
    }

    public BreakPoss getNextBreakPoss(LayoutContext context) {
        this.label.setUserAgent(this.getUserAgent());
        this.body.setUserAgent(this.getUserAgent());
        BreakPoss lastPos = null;
        ArrayList breakList = new ArrayList();
        int min = 0;
        int opt = 0;
        int max = 0;
        int stage = 0;
        boolean over = false;
        while (true) {
            Item curLM;
            if (stage == 0) {
                curLM = this.label;
            } else {
                if (stage != true) break;
                curLM = this.body;
            }
            ArrayList<BreakPoss> childBreaks = new ArrayList<BreakPoss>();
            MinOptMax stackSize = new MinOptMax();
            int ipd = context.getRefIPD();
            LayoutContext childLC = new LayoutContext(0);
            childLC.setStackLimit(MinOptMax.subtract(context.getStackLimit(), stackSize));
            if (stage == 0) {
                childLC.setRefIPD(24000);
            } else if (stage == 1) {
                childLC.setRefIPD(context.getRefIPD() - 24000);
            }
            ++stage;
            while (!curLM.isFinished()) {
                BreakPoss bp = curLM.getNextBreakPoss(childLC);
                if (bp == null) continue;
                if (stackSize.opt + bp.getStackingSize().opt > context.getStackLimit().max) {
                    if (lastPos != null) {
                        LayoutProcessor lm = lastPos.getLayoutManager();
                        lm.resetPosition(lastPos.getPosition());
                        if (lm != curLM) {
                            curLM.resetPosition(null);
                        }
                    } else {
                        curLM.resetPosition(null);
                    }
                    over = true;
                    break;
                }
                lastPos = bp;
                stackSize.add(bp.getStackingSize());
                childBreaks.add(bp);
                if (bp.nextBreakOverflows()) {
                    over = true;
                    break;
                }
                childLC.setStackLimit(MinOptMax.subtract(context.getStackLimit(), stackSize));
            }
            if (stackSize.min > min) {
                min = stackSize.min;
            }
            if (stackSize.opt > opt) {
                opt = stackSize.opt;
            }
            if (stackSize.max > max) {
                max = stackSize.max;
            }
            breakList.add(childBreaks);
        }
        this.listItemHeight = opt;
        MinOptMax itemSize = new MinOptMax(min, opt, max);
        if (this.label.isFinished() && this.body.isFinished()) {
            this.setFinished(true);
        }
        ItemPosition rp = new ItemPosition(this, breakList.size() - 1, breakList);
        BreakPoss breakPoss = new BreakPoss(rp);
        if (over) {
            breakPoss.setFlag(1024, true);
        }
        breakPoss.setStackingSize(itemSize);
        return breakPoss;
    }

    /*
     * WARNING - void declaration
     */
    public void addAreas(PositionIterator parentIter, LayoutContext layoutContext) {
        this.getParentArea(null);
        this.addID();
        LayoutContext lc = new LayoutContext(0);
        while (parentIter.hasNext()) {
            ItemPosition lfp = (ItemPosition)parentIter.next();
            Iterator iter = lfp.cellBreaks.iterator();
            while (iter.hasNext()) {
                Item childLM;
                List cellsbr = (List)iter.next();
                BreakPossPosIter breakPosIter = new BreakPossPosIter(cellsbr, 0, cellsbr.size());
                while ((childLM = (Item)breakPosIter.getNextChildLM()) != null) {
                    void var3_4;
                    if (var3_4 == this.body) {
                        var3_4.setXOffset(24000);
                    }
                    var3_4.addAreas(breakPosIter, lc);
                }
            }
        }
        this.curBlockArea.setHeight(this.listItemHeight);
        this.flush();
        this.curBlockArea = null;
    }

    public int getListItemHeight() {
        return this.listItemHeight;
    }

    public Area getParentArea(Area childArea) {
        if (this.curBlockArea == null) {
            this.curBlockArea = new Block();
            Area parentArea = this.parentLM.getParentArea(this.curBlockArea);
            int referenceIPD = parentArea.getIPD();
            this.curBlockArea.setIPD(referenceIPD);
            this.curBlockArea.setWidth(referenceIPD);
            this.setCurrentArea(this.curBlockArea);
        }
        return this.curBlockArea;
    }

    public void addChild(Area childArea) {
        if (this.curBlockArea != null) {
            this.curBlockArea.addBlock((Block)childArea);
        }
    }

    public void resetPosition(Position resetPos) {
        if (resetPos == null) {
            this.reset(null);
        }
    }

    private class ItemPosition
    extends LeafPosition {
        protected List cellBreaks;

        protected ItemPosition(LayoutProcessor lm, int pos, List l) {
            super(lm, pos);
            this.cellBreaks = l;
        }
    }
}

