/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr.table;

import java.util.ArrayList;
import java.util.List;
import org.apache.fop.area.Area;
import org.apache.fop.area.Block;
import org.apache.fop.fo.PropertyManager;
import org.apache.fop.layout.BackgroundProps;
import org.apache.fop.layout.BorderAndPadding;
import org.apache.fop.layoutmgr.BlockStackingLayoutManager;
import org.apache.fop.layoutmgr.BreakPoss;
import org.apache.fop.layoutmgr.BreakPossPosIter;
import org.apache.fop.layoutmgr.LayoutContext;
import org.apache.fop.layoutmgr.LayoutProcessor;
import org.apache.fop.layoutmgr.LeafPosition;
import org.apache.fop.layoutmgr.MinOptMax;
import org.apache.fop.layoutmgr.Position;
import org.apache.fop.layoutmgr.PositionIterator;
import org.apache.fop.layoutmgr.TraitSetter;
import org.apache.fop.layoutmgr.table.Row;

public class Body
extends BlockStackingLayoutManager {
    private BorderAndPadding borderProps = null;
    private BackgroundProps backgroundProps;
    private boolean rows = true;
    private List columns;
    private int yoffset;
    private int bodyHeight;
    private Block curBlockArea;
    private List childBreaks = new ArrayList();

    protected void initProperties(PropertyManager propMgr) {
        this.borderProps = propMgr.getBorderAndPadding();
        this.backgroundProps = propMgr.getBackgroundProps();
    }

    public void setColumns(List cols) {
        this.columns = cols;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public BreakPoss getNextBreakPoss(LayoutContext context) {
        void var2_4;
        MinOptMax stackSize = new MinOptMax();
        BreakPoss lastPos = null;
        if (this.columns == null) {
            this.setFinished(true);
            this.getLogger().warn("ignoring table body with undefined columns");
            return null;
        }
        Row curLM = (Row)this.getChildLM();
        if (curLM == null) {
            this.setFinished(true);
            return null;
        }
        int ipd = context.getRefIPD();
        LayoutContext childLC = new LayoutContext(0);
        childLC.setStackLimit(MinOptMax.subtract(context.getStackLimit(), stackSize));
        childLC.setRefIPD(ipd);
        var2_4.setColumns(this.columns);
        boolean over = false;
        while (!var2_4.isFinished()) {
            BreakPoss bp = var2_4.getNextBreakPoss(childLC);
            if (bp == null) continue;
            if (stackSize.opt + bp.getStackingSize().opt > context.getStackLimit().max) {
                if (lastPos != null) {
                    LayoutProcessor lm = lastPos.getLayoutManager();
                    lm.resetPosition(lastPos.getPosition());
                    if (lm != var2_4) {
                        var2_4.resetPosition(null);
                    }
                } else {
                    var2_4.resetPosition(null);
                }
                over = true;
                break;
            }
            stackSize.add(bp.getStackingSize());
            lastPos = bp;
            this.childBreaks.add(bp);
            if (bp.nextBreakOverflows()) {
                over = true;
                break;
            }
            childLC.setStackLimit(MinOptMax.subtract(context.getStackLimit(), stackSize));
        }
        BreakPoss breakPoss = new BreakPoss(new LeafPosition(this, this.childBreaks.size() - 1));
        if (over) {
            breakPoss.setFlag(1024, true);
        }
        breakPoss.setStackingSize(stackSize);
        return breakPoss;
    }

    public void setYOffset(int off) {
        this.yoffset = off;
    }

    /*
     * WARNING - void declaration
     */
    public void addAreas(PositionIterator parentIter, LayoutContext layoutContext) {
        this.getParentArea(null);
        this.addID();
        int iStartPos = 0;
        LayoutContext lc = new LayoutContext(0);
        int rowoffset = 0;
        while (parentIter.hasNext()) {
            Row childLM;
            LeafPosition lfp = (LeafPosition)parentIter.next();
            BreakPossPosIter breakPosIter = new BreakPossPosIter(this.childBreaks, iStartPos, lfp.getLeafPos() + 1);
            iStartPos = lfp.getLeafPos() + 1;
            int lastheight = 0;
            while ((childLM = (Row)breakPosIter.getNextChildLM()) != null) {
                void var3_6;
                var3_6.setYOffset(this.yoffset + rowoffset);
                var3_6.addAreas(breakPosIter, lc);
                lastheight = var3_6.getRowHeight();
            }
            rowoffset += lastheight;
        }
        this.bodyHeight = rowoffset;
        this.flush();
        this.childBreaks.clear();
        this.curBlockArea = null;
    }

    public int getBodyHeight() {
        return this.bodyHeight;
    }

    public Area getParentArea(Area childArea) {
        return this.parentLM.getParentArea(childArea);
    }

    public void addChild(Area childArea) {
        this.parentLM.addChild(childArea);
    }

    public void resetPosition(Position resetPos) {
        if (resetPos == null) {
            this.reset(null);
        }
    }

    public Area createColumnArea() {
        Block curBlockArea = new Block();
        if (this.backgroundProps != null) {
            TraitSetter.addBackground(curBlockArea, this.backgroundProps);
        }
        return curBlockArea;
    }
}

