/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr.table;

import java.util.ArrayList;
import java.util.List;
import org.apache.fop.area.Area;
import org.apache.fop.area.Block;
import org.apache.fop.fo.PropertyManager;
import org.apache.fop.layout.BackgroundProps;
import org.apache.fop.layout.BorderAndPadding;
import org.apache.fop.layoutmgr.BlockStackingLayoutManager;
import org.apache.fop.layoutmgr.BreakPoss;
import org.apache.fop.layoutmgr.BreakPossPosIter;
import org.apache.fop.layoutmgr.LayoutContext;
import org.apache.fop.layoutmgr.LayoutProcessor;
import org.apache.fop.layoutmgr.LeafPosition;
import org.apache.fop.layoutmgr.MinOptMax;
import org.apache.fop.layoutmgr.Position;
import org.apache.fop.layoutmgr.PositionIterator;
import org.apache.fop.layoutmgr.TraitSetter;
import org.apache.fop.layoutmgr.table.Body;

public class TableLayoutManager
extends BlockStackingLayoutManager {
    private List columns = null;
    private Body tableHeader = null;
    private Body tableFooter = null;
    private BorderAndPadding borderProps = null;
    private BackgroundProps backgroundProps;
    private Block curBlockArea;
    private List bodyBreaks = new ArrayList();
    private BreakPoss headerBreak;
    private BreakPoss footerBreak;

    protected void initProperties(PropertyManager propMgr) {
        this.borderProps = propMgr.getBorderAndPadding();
        this.backgroundProps = propMgr.getBackgroundProps();
    }

    public void setColumns(List cols) {
        this.columns = cols;
    }

    public void setTableHeader(Body th) {
        this.tableHeader = th;
        this.tableHeader.setParent(this);
    }

    public void setTableFooter(Body tf) {
        this.tableFooter = tf;
        this.tableFooter.setParent(this);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public BreakPoss getNextBreakPoss(LayoutContext context) {
        void var2_8;
        MinOptMax stackSize = new MinOptMax();
        BreakPoss lastPos = null;
        MinOptMax headerSize = null;
        if (this.tableHeader != null) {
            this.tableHeader.setUserAgent(this.getUserAgent());
            this.tableHeader.resetPosition(null);
            this.headerBreak = this.getHeight(this.tableHeader, context);
            headerSize = this.headerBreak.getStackingSize();
            stackSize.add(headerSize);
        }
        MinOptMax footerSize = null;
        if (this.tableFooter != null) {
            this.tableFooter.setUserAgent(this.getUserAgent());
            this.tableFooter.resetPosition(null);
            this.footerBreak = this.getHeight(this.tableFooter, context);
            footerSize = this.footerBreak.getStackingSize();
            stackSize.add(footerSize);
        }
        if (stackSize.opt > context.getStackLimit().max) {
            BreakPoss breakPoss = new BreakPoss(new LeafPosition(this, 0));
            breakPoss.setFlag(1024, true);
            breakPoss.setStackingSize(stackSize);
            return breakPoss;
        }
        Body curLM = (Body)this.getChildLM();
        if (curLM == null) {
            this.setFinished(true);
            return null;
        }
        int ipd = context.getRefIPD();
        LayoutContext childLC = new LayoutContext(0);
        childLC.setStackLimit(MinOptMax.subtract(context.getStackLimit(), stackSize));
        childLC.setRefIPD(ipd);
        var2_8.setColumns(this.columns);
        boolean over = false;
        while (!var2_8.isFinished()) {
            BreakPoss bp = var2_8.getNextBreakPoss(childLC);
            if (bp == null) continue;
            if (stackSize.opt + bp.getStackingSize().opt > context.getStackLimit().max) {
                if (lastPos != null) {
                    LayoutProcessor lm = lastPos.getLayoutManager();
                    lm.resetPosition(lastPos.getPosition());
                    if (lm != var2_8) {
                        var2_8.resetPosition(null);
                    }
                } else {
                    var2_8.resetPosition(null);
                }
                over = true;
                break;
            }
            stackSize.add(bp.getStackingSize());
            lastPos = bp;
            this.bodyBreaks.add(bp);
            if (bp.nextBreakOverflows()) {
                over = true;
                break;
            }
            childLC.setStackLimit(MinOptMax.subtract(context.getStackLimit(), stackSize));
        }
        BreakPoss breakPoss = new BreakPoss(new LeafPosition(this, this.bodyBreaks.size() - 1));
        if (over) {
            breakPoss.setFlag(1024, true);
        }
        breakPoss.setStackingSize(stackSize);
        return breakPoss;
    }

    protected BreakPoss getHeight(Body lm, LayoutContext context) {
        int ipd = context.getRefIPD();
        MinOptMax stackSize = new MinOptMax();
        LayoutContext childLC = new LayoutContext(0);
        childLC.setStackLimit(context.getStackLimit());
        childLC.setRefIPD(ipd);
        lm.setColumns(this.columns);
        ArrayList<BreakPoss> breaks = new ArrayList<BreakPoss>();
        while (!lm.isFinished()) {
            BreakPoss bp = lm.getNextBreakPoss(childLC);
            if (bp == null) continue;
            stackSize.add(bp.getStackingSize());
            breaks.add(bp);
            childLC.setStackLimit(MinOptMax.subtract(context.getStackLimit(), stackSize));
        }
        BreakPoss breakPoss = new BreakPoss(new SectionPosition(this, breaks.size() - 1, breaks));
        breakPoss.setStackingSize(stackSize);
        return breakPoss;
    }

    /*
     * WARNING - void declaration
     */
    public void addAreas(PositionIterator parentIter, LayoutContext layoutContext) {
        Body childLM;
        BreakPossPosIter breakPosIter;
        this.getParentArea(null);
        this.addID();
        int tableHeight = 0;
        LayoutContext lc = new LayoutContext(0);
        if (this.headerBreak != null) {
            SectionPosition pos = (SectionPosition)this.headerBreak.getPosition();
            List list = pos.list;
            breakPosIter = new BreakPossPosIter(list, 0, list.size() + 1);
            while ((childLM = (Body)breakPosIter.getNextChildLM()) != null) {
                void var4_9;
                var4_9.addAreas(breakPosIter, lc);
                tableHeight += var4_9.getBodyHeight();
            }
        }
        int iStartPos = 0;
        while (parentIter.hasNext()) {
            LeafPosition lfp = (LeafPosition)parentIter.next();
            breakPosIter = new BreakPossPosIter(this.bodyBreaks, iStartPos, lfp.getLeafPos() + 1);
            iStartPos = lfp.getLeafPos() + 1;
            while ((childLM = (Body)breakPosIter.getNextChildLM()) != null) {
                childLM.setYOffset(tableHeight);
                childLM.addAreas(breakPosIter, lc);
                tableHeight += childLM.getBodyHeight();
            }
        }
        if (this.footerBreak != null) {
            SectionPosition pos = (SectionPosition)this.footerBreak.getPosition();
            List list = pos.list;
            BreakPossPosIter breakPosIter2 = new BreakPossPosIter(list, 0, list.size() + 1);
            while ((childLM = (Body)breakPosIter2.getNextChildLM()) != null) {
                childLM.setYOffset(tableHeight);
                childLM.addAreas(breakPosIter2, lc);
                tableHeight += childLM.getBodyHeight();
            }
        }
        this.curBlockArea.setHeight(tableHeight);
        if (this.borderProps != null) {
            TraitSetter.addBorders(this.curBlockArea, this.borderProps);
        }
        if (this.backgroundProps != null) {
            TraitSetter.addBackground(this.curBlockArea, this.backgroundProps);
        }
        this.flush();
        this.bodyBreaks.clear();
        this.curBlockArea = null;
    }

    public Area getParentArea(Area childArea) {
        if (this.curBlockArea == null) {
            this.curBlockArea = new Block();
            Area parentArea = this.parentLM.getParentArea(this.curBlockArea);
            int referenceIPD = parentArea.getIPD();
            this.curBlockArea.setIPD(referenceIPD);
            this.setCurrentArea(this.curBlockArea);
        }
        return this.curBlockArea;
    }

    public void addChild(Area childArea) {
        if (this.curBlockArea != null) {
            this.curBlockArea.addBlock((Block)childArea);
        }
    }

    public void resetPosition(Position resetPos) {
        if (resetPos == null) {
            this.reset(null);
        }
    }

    private class SectionPosition
    extends LeafPosition {
        protected List list;

        protected SectionPosition(LayoutProcessor lm, int pos, List l) {
            super(lm, pos);
            this.list = l;
        }
    }
}

