/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import org.apache.fop.pdf.PDFNumber;
import org.apache.fop.pdf.PDFPathPaint;
import org.apache.fop.pdf.PDFResources;
import org.apache.fop.pdf.PDFShading;
import org.apache.fop.pdf.PDFStream;

public class PDFPattern
extends PDFPathPaint {
    protected PDFResources resources = null;
    protected int patternType = 2;
    protected String patternName = null;
    protected int paintType = 2;
    protected int tilingType = 1;
    protected List bBox = null;
    protected double xStep = -1.0;
    protected double yStep = -1.0;
    protected PDFShading shading = null;
    protected List xUID = null;
    protected StringBuffer extGState = null;
    protected List matrix = null;
    protected StringBuffer patternDataStream = null;

    public PDFPattern(int theNumber, String thePatternName, PDFResources theResources, int thePatternType, int thePaintType, int theTilingType, List theBBox, double theXStep, double theYStep, List theMatrix, List theXUID, StringBuffer thePatternDataStream) {
        super(theNumber);
        this.patternName = thePatternName;
        this.resources = theResources;
        this.patternType = 1;
        this.paintType = thePaintType;
        this.tilingType = theTilingType;
        this.bBox = theBBox;
        this.xStep = theXStep;
        this.yStep = theYStep;
        this.matrix = theMatrix;
        this.xUID = theXUID;
        this.patternDataStream = thePatternDataStream;
    }

    public PDFPattern(int theNumber, String thePatternName, int thePatternType, PDFShading theShading, List theXUID, StringBuffer theExtGState, List theMatrix) {
        super(theNumber);
        this.patternName = thePatternName;
        this.patternType = 2;
        this.shading = theShading;
        this.xUID = theXUID;
        this.extGState = theExtGState;
        this.matrix = theMatrix;
    }

    public String getName() {
        return this.patternName;
    }

    public String getColorSpaceOut(boolean fillNotStroke) {
        if (fillNotStroke) {
            return "/Pattern cs /" + this.getName() + " scn \n";
        }
        return "/Pattern CS /" + this.getName() + " SCN \n";
    }

    protected int output(OutputStream stream) throws IOException {
        int vectorSize = 0;
        int tempInt = 0;
        StringBuffer p = new StringBuffer();
        p.append(this.number + " " + this.generation + " obj\n<< \n/Type /Pattern \n");
        if (this.resources != null) {
            p.append("/Resources " + this.resources.referencePDF() + " \n");
        }
        p.append("/PatternType " + this.patternType + " \n");
        PDFStream dataStream = null;
        if (this.patternType == 1) {
            p.append("/PaintType " + this.paintType + " \n");
            p.append("/TilingType " + this.tilingType + " \n");
            if (this.bBox != null) {
                vectorSize = this.bBox.size();
                p.append("/BBox [ ");
                tempInt = 0;
                while (tempInt < vectorSize) {
                    p.append(PDFNumber.doubleOut((Double)this.bBox.get(tempInt)));
                    p.append(" ");
                    ++tempInt;
                }
                p.append("] \n");
            }
            p.append("/XStep " + PDFNumber.doubleOut(new Double(this.xStep)) + " \n");
            p.append("/YStep " + PDFNumber.doubleOut(new Double(this.yStep)) + " \n");
            if (this.matrix != null) {
                vectorSize = this.matrix.size();
                p.append("/Matrix [ ");
                tempInt = 0;
                while (tempInt < vectorSize) {
                    p.append(PDFNumber.doubleOut((Double)this.matrix.get(tempInt)));
                    p.append(" ");
                    ++tempInt;
                }
                p.append("] \n");
            }
            if (this.xUID != null) {
                vectorSize = this.xUID.size();
                p.append("/XUID [ ");
                tempInt = 0;
                while (tempInt < vectorSize) {
                    p.append((Integer)this.xUID.get(tempInt) + " ");
                    ++tempInt;
                }
                p.append("] \n");
            }
            if (this.patternDataStream != null) {
                dataStream = new PDFStream(0);
                dataStream.add(this.patternDataStream.toString());
                dataStream.addDefaultFilters(new HashMap(), "content");
                p.append(dataStream.applyFilters());
                p.append("/Length " + (dataStream.getDataLength() + 1) + " \n");
            }
        } else {
            if (this.shading != null) {
                p.append("/Shading " + this.shading.referencePDF() + " \n");
            }
            if (this.xUID != null) {
                vectorSize = this.xUID.size();
                p.append("/XUID [ ");
                tempInt = 0;
                while (tempInt < vectorSize) {
                    p.append((Integer)this.xUID.get(tempInt) + " ");
                    ++tempInt;
                }
                p.append("] \n");
            }
            if (this.extGState != null) {
                p.append("/ExtGState " + this.extGState + " \n");
            }
            if (this.matrix != null) {
                vectorSize = this.matrix.size();
                p.append("/Matrix [ ");
                tempInt = 0;
                while (tempInt < vectorSize) {
                    p.append(PDFNumber.doubleOut((Double)this.matrix.get(tempInt)));
                    p.append(" ");
                    ++tempInt;
                }
                p.append("] \n");
            }
        }
        p.append(">> \n");
        String dict = p.toString();
        int length = dict.length();
        stream.write(dict.getBytes());
        if (dataStream != null) {
            length += dataStream.outputStreamData(stream);
        }
        String end = "endobj\n";
        stream.write(end.getBytes());
        return length += end.length();
    }

    public byte[] toPDF() {
        return null;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof PDFPattern)) {
            return false;
        }
        PDFPattern patt = (PDFPattern)obj;
        if (this.patternType != patt.patternType) {
            return false;
        }
        if (this.paintType != patt.paintType) {
            return false;
        }
        if (this.tilingType != patt.tilingType) {
            return false;
        }
        if (this.xStep != patt.xStep) {
            return false;
        }
        if (this.yStep != patt.yStep) {
            return false;
        }
        if (this.bBox != null ? !this.bBox.equals(patt.bBox) : patt.bBox != null) {
            return false;
        }
        if (this.bBox != null ? !this.bBox.equals(patt.bBox) : patt.bBox != null) {
            return false;
        }
        if (this.xUID != null ? !this.xUID.equals(patt.xUID) : patt.xUID != null) {
            return false;
        }
        if (this.extGState != null ? !this.extGState.equals(patt.extGState) : patt.extGState != null) {
            return false;
        }
        if (this.matrix != null ? !this.matrix.equals(patt.matrix) : patt.matrix != null) {
            return false;
        }
        if (this.resources != null ? !this.resources.equals(patt.resources) : patt.resources != null) {
            return false;
        }
        if (this.shading != null ? !this.shading.equals(patt.shading) : patt.shading != null) {
            return false;
        }
        return !(this.patternDataStream != null ? !this.patternDataStream.equals(patt.patternDataStream) : patt.patternDataStream != null);
    }
}

