/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.fop.pdf.PDFFilter;
import org.apache.fop.pdf.StreamCache;
import org.apache.fop.util.StreamUtilities;

public class TempFileStreamCache
extends StreamCache {
    private BufferedOutputStream output;
    private File tempFile = File.createTempFile("org.apache.fop.pdf.StreamCache-", ".temp");

    public TempFileStreamCache() throws IOException {
        this.tempFile.deleteOnExit();
    }

    public OutputStream getOutputStream() throws IOException {
        if (this.output == null) {
            this.output = new BufferedOutputStream(new FileOutputStream(this.tempFile));
        }
        return this.output;
    }

    public void applyFilter(PDFFilter filter) throws IOException {
        if (this.output == null) {
            return;
        }
        this.output.close();
        this.output = null;
        File newTempFile = File.createTempFile("org.apache.fop.pdf.StreamCache-", ".temp");
        newTempFile.deleteOnExit();
        BufferedInputStream input = new BufferedInputStream(new FileInputStream(this.tempFile));
        BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(newTempFile));
        filter.encode(input, output, (int)this.tempFile.length());
        input.close();
        output.close();
        this.tempFile.delete();
        this.tempFile = newTempFile;
    }

    public void outputStreamData(OutputStream stream) throws IOException {
        if (this.output == null) {
            return;
        }
        this.output.close();
        this.output = null;
        FileInputStream input = new FileInputStream(this.tempFile);
        StreamUtilities.streamCopy(input, this.output);
        input.close();
    }

    public int getSize() throws IOException {
        if (this.output != null) {
            this.output.flush();
        }
        return (int)this.tempFile.length();
    }

    public void close() throws IOException {
        if (this.output != null) {
            this.output.close();
            this.output = null;
        }
        if (this.tempFile.exists()) {
            this.tempFile.delete();
        }
    }

    public void reset() throws IOException {
        if (this.output != null) {
            this.output.close();
            this.output = null;
        }
        if (this.tempFile.exists()) {
            this.tempFile.delete();
        }
    }
}

