/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render;

import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.fop.apps.FOPException;
import org.apache.fop.area.Area;
import org.apache.fop.area.BeforeFloat;
import org.apache.fop.area.Block;
import org.apache.fop.area.BlockViewport;
import org.apache.fop.area.BodyRegion;
import org.apache.fop.area.CTM;
import org.apache.fop.area.Flow;
import org.apache.fop.area.Footnote;
import org.apache.fop.area.LineArea;
import org.apache.fop.area.MainReference;
import org.apache.fop.area.Page;
import org.apache.fop.area.PageViewport;
import org.apache.fop.area.RegionReference;
import org.apache.fop.area.RegionViewport;
import org.apache.fop.area.Span;
import org.apache.fop.area.Title;
import org.apache.fop.area.TreeExt;
import org.apache.fop.area.inline.Character;
import org.apache.fop.area.inline.Container;
import org.apache.fop.area.inline.ForeignObject;
import org.apache.fop.area.inline.Image;
import org.apache.fop.area.inline.InlineArea;
import org.apache.fop.area.inline.InlineParent;
import org.apache.fop.area.inline.Leader;
import org.apache.fop.area.inline.Space;
import org.apache.fop.area.inline.Viewport;
import org.apache.fop.area.inline.Word;
import org.apache.fop.fo.FOUserAgent;
import org.apache.fop.render.Renderer;

public abstract class AbstractRenderer
extends AbstractLogEnabled
implements Renderer,
Configurable {
    protected FOUserAgent userAgent;
    protected Map options;
    protected int currentBPPosition = 0;
    protected int currentIPPosition = 0;
    protected int currentBlockIPPosition = 0;
    protected int containingBPPosition = 0;
    protected int containingIPPosition = 0;

    public void configure(Configuration conf) throws ConfigurationException {
    }

    public void setProducer(String producer) {
    }

    public void setCreator(String creator) {
    }

    public void setUserAgent(FOUserAgent agent) {
        this.userAgent = agent;
    }

    public void setOptions(Map opt) {
        this.options = opt;
    }

    public boolean supportsOutOfOrder() {
        return false;
    }

    public void renderExtension(TreeExt ext) {
    }

    public void preparePage(PageViewport page) {
    }

    protected String convertTitleToString(Title title) {
        List children = title.getInlineAreas();
        String str = this.convertToString(children);
        return str.trim();
    }

    private String convertToString(List children) {
        StringBuffer sb = new StringBuffer();
        int count = 0;
        while (count < children.size()) {
            InlineArea inline = (InlineArea)children.get(count);
            if (inline instanceof Character) {
                sb.append(((Character)inline).getChar());
            } else if (inline instanceof Word) {
                sb.append(((Word)inline).getWord());
            } else if (inline instanceof InlineParent) {
                sb.append(this.convertToString(((InlineParent)inline).getChildAreas()));
            } else {
                sb.append(" ");
            }
            ++count;
        }
        return sb.toString();
    }

    public void startPageSequence(Title seqTitle) {
    }

    public void renderPage(PageViewport page) throws IOException, FOPException {
        Page p = page.getPage();
        this.renderPageAreas(p);
    }

    protected void renderPageAreas(Page page) {
        RegionViewport viewport = page.getRegion(0);
        this.renderRegionViewport(viewport);
        viewport = page.getRegion(1);
        this.renderRegionViewport(viewport);
        viewport = page.getRegion(2);
        this.renderRegionViewport(viewport);
        viewport = page.getRegion(3);
        this.renderRegionViewport(viewport);
        viewport = page.getRegion(4);
        this.renderRegionViewport(viewport);
    }

    protected void renderRegionViewport(RegionViewport port) {
        if (port != null) {
            Rectangle2D view = port.getViewArea();
            this.currentBPPosition = 0;
            this.currentBlockIPPosition = this.currentIPPosition = 0;
            RegionReference region = port.getRegion();
            this.startVParea(region.getCTM());
            this.handleViewportTraits(port);
            if (region.getRegionClass() == 2) {
                this.renderBodyRegion((BodyRegion)region);
            } else {
                this.renderRegion(region);
            }
            this.endVParea();
        }
    }

    protected void startVParea(CTM ctm) {
    }

    protected void handleViewportTraits(RegionViewport rv) {
    }

    protected void endVParea() {
    }

    protected void renderRegion(RegionReference region) {
        List blocks = region.getBlocks();
        this.renderBlocks(blocks);
    }

    protected void renderBodyRegion(BodyRegion region) {
        Footnote foot;
        MainReference mr;
        BeforeFloat bf = region.getBeforeFloat();
        if (bf != null) {
            this.renderBeforeFloat(bf);
        }
        if ((mr = region.getMainReference()) != null) {
            this.renderMainReference(mr);
        }
        if ((foot = region.getFootnote()) != null) {
            this.renderFootnote(foot);
        }
    }

    protected void renderBeforeFloat(BeforeFloat bf) {
        List blocks = bf.getChildAreas();
        if (blocks != null) {
            this.renderBlocks(blocks);
            Block sep = bf.getSeparator();
            if (sep != null) {
                this.renderBlock(sep);
            }
        }
    }

    protected void renderFootnote(Footnote footnote) {
        List blocks = footnote.getChildAreas();
        if (blocks != null) {
            Block sep = footnote.getSeparator();
            if (sep != null) {
                this.renderBlock(sep);
            }
            this.renderBlocks(blocks);
        }
    }

    protected void renderMainReference(MainReference mr) {
        int saveIPPos = this.currentIPPosition;
        Span span = null;
        List spans = mr.getSpans();
        int count = 0;
        while (count < spans.size()) {
            span = (Span)spans.get(count);
            int offset = (mr.getWidth() - (span.getColumnCount() - 1) * mr.getColumnGap()) / span.getColumnCount() + mr.getColumnGap();
            int c = 0;
            while (c < span.getColumnCount()) {
                Flow flow = span.getFlow(c);
                this.renderFlow(flow);
                this.currentIPPosition += offset;
                ++c;
            }
            this.currentIPPosition = saveIPPos;
            this.currentBPPosition += span.getHeight();
            ++count;
        }
    }

    protected void renderFlow(Flow flow) {
        List blocks = flow.getChildAreas();
        if (blocks != null) {
            this.renderBlocks(blocks);
        }
    }

    protected void renderBlock(Block block) {
        List children = block.getChildAreas();
        if (children == null) {
            this.handleBlockTraits(block);
            this.currentBPPosition += block.getHeight();
        } else if (block instanceof BlockViewport) {
            this.renderBlockViewport((BlockViewport)block, children);
        } else {
            int saveIP = this.currentIPPosition;
            int saveBP = this.currentBPPosition;
            if (block.getPositioning() == 2) {
                this.currentIPPosition = this.containingIPPosition + block.getXOffset();
                this.currentBPPosition = this.containingBPPosition + block.getYOffset();
                this.handleBlockTraits(block);
                this.renderBlocks(children);
                this.currentBPPosition = saveBP;
            } else {
                this.currentIPPosition += block.getXOffset();
                this.currentBPPosition += block.getYOffset();
                this.handleBlockTraits(block);
                this.renderBlocks(children);
                this.currentBPPosition = saveBP + block.getHeight();
            }
            this.currentIPPosition = saveIP;
        }
    }

    protected void handleBlockTraits(Block block) {
    }

    protected void renderBlockViewport(BlockViewport bv, List children) {
        if (bv.getPositioning() == 2) {
            int saveIP = this.currentIPPosition;
            int saveBP = this.currentBPPosition;
            CTM ctm = bv.getCTM();
            this.currentIPPosition = 0;
            this.currentBPPosition = 0;
            this.startVParea(ctm);
            this.handleBlockTraits(bv);
            this.renderBlocks(children);
            this.endVParea();
            this.currentIPPosition = saveIP;
            this.currentBPPosition = saveBP;
        } else {
            this.renderBlocks(children);
        }
    }

    protected void renderLineArea(LineArea line) {
        List children = line.getInlineAreas();
        int count = 0;
        while (count < children.size()) {
            InlineArea inline = (InlineArea)children.get(count);
            inline.render(this);
            ++count;
        }
    }

    public void renderViewport(Viewport viewport) {
        Area content = viewport.getContent();
        int saveBP = this.currentBPPosition;
        this.currentBPPosition += viewport.getOffset();
        Rectangle2D contpos = viewport.getContentPosition();
        if (content instanceof Image) {
            this.renderImage((Image)content, contpos);
        } else if (content instanceof Container) {
            this.renderContainer((Container)content);
        } else if (content instanceof ForeignObject) {
            this.renderForeignObject((ForeignObject)content, contpos);
        }
        this.currentBlockIPPosition += viewport.getWidth();
        this.currentBPPosition = saveBP;
    }

    public void renderImage(Image image, Rectangle2D pos) {
    }

    public void renderContainer(Container cont) {
        int saveIP = this.currentIPPosition;
        this.currentIPPosition = this.currentBlockIPPosition;
        int saveBlockIP = this.currentBlockIPPosition;
        int saveBP = this.currentBPPosition;
        List blocks = cont.getBlocks();
        this.renderBlocks(blocks);
        this.currentIPPosition = saveIP;
        this.currentBlockIPPosition = saveBlockIP;
        this.currentBPPosition = saveBP;
    }

    public void renderForeignObject(ForeignObject fo, Rectangle2D pos) {
    }

    public void renderCharacter(Character ch) {
        this.currentBlockIPPosition += ch.getWidth();
    }

    public void renderInlineSpace(Space space) {
        this.currentBlockIPPosition += space.getWidth();
    }

    public void renderLeader(Leader area) {
        this.currentBlockIPPosition += area.getWidth();
    }

    public void renderWord(Word word) {
        this.currentBlockIPPosition += word.getWidth();
    }

    public void renderInlineParent(InlineParent ip) {
        int saveIP = this.currentBlockIPPosition;
        Iterator iter = ip.getChildAreas().iterator();
        while (iter.hasNext()) {
            ((InlineArea)iter.next()).render(this);
        }
        this.currentBlockIPPosition = saveIP + ip.getWidth();
    }

    protected void renderBlocks(List blocks) {
        int contBP = this.currentBPPosition;
        int contIP = this.currentIPPosition;
        this.containingBPPosition = contBP;
        this.containingIPPosition = contIP;
        int count = 0;
        while (count < blocks.size()) {
            Object obj = blocks.get(count);
            if (obj instanceof Block) {
                this.containingBPPosition = contBP;
                this.containingIPPosition = contIP;
                this.renderBlock((Block)obj);
                this.containingBPPosition = contBP;
                this.containingIPPosition = contIP;
            } else {
                LineArea line = (LineArea)obj;
                this.currentBlockIPPosition = this.currentIPPosition + line.getStartIndent();
                this.renderLineArea(line);
                this.currentBPPosition += line.getHeight();
            }
            ++count;
        }
    }
}

