/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.ps;

import java.io.IOException;
import java.io.OutputStream;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Stack;
import org.apache.fop.render.ps.PSState;

public class PSGenerator {
    public static final AtendIndicator ATEND = new AtendIndicator(){};
    private OutputStream out;
    private Stack graphicsStateStack = new Stack();
    private PSState currentState;
    private StringBuffer tempBuffer = new StringBuffer(256);

    public PSGenerator(OutputStream out) {
        this.out = out;
        this.currentState = new PSState();
        this.graphicsStateStack.push(this.currentState);
    }

    public final void newLine() throws IOException {
        this.out.write(10);
    }

    public String formatDouble(double value) {
        DecimalFormat nf = new DecimalFormat("0.#");
        return nf.format(value);
    }

    public void write(String cmd) throws IOException {
        if (cmd.length() > 255) {
            throw new RuntimeException("PostScript command exceeded limit of 255 characters");
        }
        this.out.write(cmd.getBytes("US-ASCII"));
    }

    public void writeln(String cmd) throws IOException {
        this.write(cmd);
        this.newLine();
    }

    public void writeByteArr(byte[] cmd) throws IOException {
        this.out.write(cmd);
        this.newLine();
    }

    public void flush() throws IOException {
        this.out.flush();
    }

    public static final void escapeChar(char c, StringBuffer target) {
        if (c > '\u007f') {
            target.append("\\");
            target.append(Integer.toOctalString(c));
        } else {
            switch (c) {
                case '\n': {
                    target.append("\\n");
                    break;
                }
                case '\r': {
                    target.append("\\r");
                    break;
                }
                case '\t': {
                    target.append("\\t");
                    break;
                }
                case '\b': {
                    target.append("\\b");
                    break;
                }
                case '\f': {
                    target.append("\\f");
                    break;
                }
                case '\\': {
                    target.append("\\\\");
                    break;
                }
                case '(': {
                    target.append("\\(");
                    break;
                }
                case ')': {
                    target.append("\\)");
                    break;
                }
                default: {
                    target.append(c);
                }
            }
        }
    }

    public static final String convertStringToDSC(String text) {
        return PSGenerator.convertStringToDSC(text, false);
    }

    public static final String convertStringToDSC(String text, boolean forceParentheses) {
        if (text == null || text.length() == 0) {
            return "()";
        }
        int initialSize = text.length();
        initialSize += initialSize / 2;
        StringBuffer sb = new StringBuffer(initialSize);
        if (Long.getLong(text) != null || text.indexOf(" ") >= 0 || forceParentheses) {
            sb.append("(");
            int i = 0;
            while (i < text.length()) {
                char c = text.charAt(i);
                PSGenerator.escapeChar(c, sb);
                ++i;
            }
            sb.append(")");
            return sb.toString();
        }
        return text;
    }

    public void writeDSCComment(String name) throws IOException {
        this.writeln("%%" + name);
    }

    public void writeDSCComment(String name, Object param) throws IOException {
        this.writeDSCComment(name, new Object[]{param});
    }

    public void writeDSCComment(String name, Object[] params) throws IOException {
        this.tempBuffer.setLength(0);
        this.tempBuffer.append("%%");
        this.tempBuffer.append(name);
        if (params != null && params.length > 0) {
            this.tempBuffer.append(": ");
            int i = 0;
            while (i < params.length) {
                if (i > 0) {
                    this.tempBuffer.append(" ");
                }
                if (params[i] instanceof String) {
                    this.tempBuffer.append(PSGenerator.convertStringToDSC((String)params[i]));
                } else if (params[i] instanceof AtendIndicator) {
                    this.tempBuffer.append("(atend)");
                } else if (params[i] instanceof Number) {
                    this.tempBuffer.append(params[i].toString());
                } else if (params[i] instanceof Date) {
                    SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
                    this.tempBuffer.append(PSGenerator.convertStringToDSC(df.format((Date)params[i])));
                } else {
                    throw new IllegalArgumentException("Unsupported parameter type: " + params[i].getClass().getName());
                }
                ++i;
            }
        }
        this.writeln(this.tempBuffer.toString());
    }

    public void saveGraphicsState() throws IOException {
        this.writeln("gsave");
        PSState state = (PSState)this.currentState.clone();
        this.graphicsStateStack.push(this.currentState);
        this.currentState = state;
    }

    public void restoreGraphicsState() throws IOException {
        this.writeln("grestore");
        this.currentState = (PSState)this.graphicsStateStack.pop();
    }

    public void concatMatrix(double a, double b, double c, double d, double e, double f) throws IOException {
        this.writeln("[" + this.formatDouble(a) + " " + this.formatDouble(b) + " " + this.formatDouble(c) + " " + this.formatDouble(d) + " " + this.formatDouble(e) + " " + this.formatDouble(f) + "] concat");
    }

    public void concatMatrix(double[] matrix) throws IOException {
        this.concatMatrix(matrix[0], matrix[1], matrix[2], matrix[3], matrix[4], matrix[5]);
    }

    public PSState getCurrentState() {
        return this.currentState;
    }

    private static interface AtendIndicator {
    }
}

