/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.xml;

import java.io.IOException;
import java.io.Writer;
import org.apache.batik.dom.util.DOMUtilities;
import org.apache.fop.render.RendererContext;
import org.apache.fop.render.XMLHandler;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class XMLXMLHandler
implements XMLHandler {
    public static final String WRITER = "writer";

    public void handleXML(RendererContext context, Document doc, String ns) throws Exception {
        Writer writer = (Writer)context.getProperty(WRITER);
        String svg = "http://www.w3.org/2000/svg";
        if (svg.equals(ns)) {
            DOMUtilities.writeDocument((Document)doc, (Writer)writer);
        } else {
            XMLXMLHandler.writeDocument(doc, writer);
        }
        writer.write("\n");
    }

    public static void writeDocument(Document doc, Writer writer) throws IOException {
        Node n = doc.getFirstChild();
        while (n != null) {
            XMLXMLHandler.writeNode(n, writer);
            n = n.getNextSibling();
        }
    }

    public static void writeNode(Node node, Writer writer) throws IOException {
        switch (node.getNodeType()) {
            case 1: {
                Node c;
                writer.write("<");
                writer.write(node.getNodeName());
                if (node.hasAttributes()) {
                    NamedNodeMap attr = node.getAttributes();
                    int len = attr.getLength();
                    int i = 0;
                    while (i < len) {
                        Attr a = (Attr)attr.item(i);
                        writer.write(" ");
                        writer.write(a.getNodeName());
                        writer.write("=\"");
                        writer.write(XMLXMLHandler.contentToString(a.getNodeValue()));
                        writer.write("\"");
                        ++i;
                    }
                }
                if ((c = node.getFirstChild()) != null) {
                    writer.write(">");
                    while (c != null) {
                        XMLXMLHandler.writeNode(c, writer);
                        c = c.getNextSibling();
                    }
                    writer.write("</");
                    writer.write(node.getNodeName());
                    writer.write(">");
                    break;
                }
                writer.write("/>");
                break;
            }
            case 3: {
                writer.write(XMLXMLHandler.contentToString(node.getNodeValue()));
                break;
            }
            case 4: {
                writer.write("<![CDATA[");
                writer.write(node.getNodeValue());
                writer.write("]]>");
                break;
            }
            case 5: {
                writer.write("&");
                writer.write(node.getNodeName());
                writer.write(";");
                break;
            }
            case 7: {
                writer.write("<?");
                writer.write(node.getNodeName());
                writer.write(node.getNodeValue());
                writer.write("?>");
                break;
            }
            case 8: {
                writer.write("<!--");
                writer.write(node.getNodeValue());
                writer.write("-->");
                break;
            }
            case 10: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected node type (" + node.getNodeType() + ")");
            }
        }
    }

    public static String contentToString(String s) {
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            switch (c) {
                case '<': {
                    result.append("&lt;");
                    break;
                }
                case '>': {
                    result.append("&gt;");
                    break;
                }
                case '&': {
                    result.append("&amp;");
                    break;
                }
                case '\"': {
                    result.append("&quot;");
                    break;
                }
                case '\'': {
                    result.append("&apos;");
                    break;
                }
                default: {
                    result.append(c);
                }
            }
            ++i;
        }
        return result.toString();
    }
}

