/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.tools;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.logger.ConsoleLogger;
import org.apache.avalon.framework.logger.Logger;
import org.apache.fop.area.AreaTree;
import org.apache.fop.area.PageViewport;
import org.apache.fop.area.StorePagesModel;
import org.apache.fop.area.Title;
import org.apache.fop.fo.FOUserAgent;
import org.apache.fop.layout.FontInfo;
import org.apache.fop.render.AbstractRenderer;
import org.apache.fop.render.Renderer;
import org.apache.fop.render.pdf.PDFRenderer;
import org.apache.fop.render.svg.SVGRenderer;
import org.apache.fop.render.xml.XMLRenderer;
import org.apache.fop.tools.TreeLoader;

public class AreaTreeBuilder
extends AbstractLogEnabled {
    public static void main(String[] args) {
        AreaTreeBuilder atb = new AreaTreeBuilder();
        atb.enableLogging((Logger)new ConsoleLogger(0));
        atb.runTests(args[0], args[1], args[2]);
        System.exit(0);
    }

    protected void runTests(String in, String type, String out) {
        this.getLogger().debug("Starting tests");
        this.runTest(in, type, out);
        this.getLogger().debug("Finished");
    }

    protected void runTest(String in, String type, String out) {
        AbstractRenderer rend = null;
        if ("xml".equals(type)) {
            rend = new XMLRenderer();
        } else if ("pdf".equals(type)) {
            rend = new PDFRenderer();
        } else if ("svg".equals(type)) {
            rend = new SVGRenderer();
        }
        this.setupLogger(rend);
        FontInfo fi = new FontInfo();
        rend.setupFontInfo(fi);
        FOUserAgent ua = new FOUserAgent();
        this.setupLogger(ua);
        rend.setUserAgent(ua);
        StorePagesModel sm = AreaTree.createStorePagesModel();
        TreeLoader tl = new TreeLoader(fi);
        this.setupLogger((Object)tl);
        tl.setTreeModel(sm);
        try {
            BufferedInputStream is = new BufferedInputStream(new FileInputStream(in));
            tl.buildAreaTree(is);
            this.renderAreaTree(sm, rend, out);
        }
        catch (IOException e) {
            this.getLogger().error("error reading file" + e.getMessage(), (Throwable)e);
        }
    }

    protected void renderAreaTree(StorePagesModel sm, Renderer rend, String out) {
        try {
            BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(out));
            rend.startRenderer(os);
            int count = 0;
            int seqc = sm.getPageSequenceCount();
            while (count < seqc) {
                Title title = sm.getTitle(count);
                rend.startPageSequence(title);
                int pagec = sm.getPageCount(count);
                int c = 0;
                while (c < pagec) {
                    PageViewport page = sm.getPage(count, c);
                    ++c;
                    rend.renderPage(page);
                }
                ++count;
            }
            rend.stopRenderer();
            ((OutputStream)os).close();
        }
        catch (Exception e) {
            this.getLogger().error("error rendering output", (Throwable)e);
        }
    }
}

