/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.tools.anttasks;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import org.apache.fop.apps.Driver;
import org.apache.fop.apps.FOInputHandler;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.InputHandler;
import org.apache.fop.apps.Starter;
import org.apache.fop.fo.FOUserAgent;
import org.apache.fop.tools.anttasks.Fop;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.util.GlobPatternMapper;
import org.xml.sax.XMLReader;

class FOPTaskStarter
extends Starter {
    private Fop task;
    private String baseURL = null;

    FOPTaskStarter(Fop task) throws FOPException {
        this.task = task;
    }

    private int determineRenderer(String format) {
        if (format == null || format.equalsIgnoreCase("application/pdf") || format.equalsIgnoreCase("pdf")) {
            return 1;
        }
        if (format.equalsIgnoreCase("application/postscript") || format.equalsIgnoreCase("ps")) {
            return 7;
        }
        if (format.equalsIgnoreCase("application/vnd.mif") || format.equalsIgnoreCase("mif")) {
            return 3;
        }
        if (format.equalsIgnoreCase("application/msword") || format.equalsIgnoreCase("application/rtf") || format.equalsIgnoreCase("rtf")) {
            return 10;
        }
        if (format.equalsIgnoreCase("application/vnd.hp-PCL") || format.equalsIgnoreCase("pcl")) {
            return 6;
        }
        if (format.equalsIgnoreCase("text/plain") || format.equalsIgnoreCase("txt")) {
            return 8;
        }
        if (format.equalsIgnoreCase("text/xml") || format.equalsIgnoreCase("at") || format.equalsIgnoreCase("xml")) {
            return 4;
        }
        String err = "Couldn't determine renderer to use: " + format;
        throw new BuildException(err);
    }

    private String determineExtension(int renderer) {
        switch (renderer) {
            case 1: {
                return ".pdf";
            }
            case 7: {
                return ".ps";
            }
            case 3: {
                return ".mif";
            }
            case 10: {
                return ".rtf";
            }
            case 6: {
                return ".pcl";
            }
            case 8: {
                return ".txt";
            }
            case 4: {
                return ".xml";
            }
        }
        String err = "Unknown renderer: " + renderer;
        throw new BuildException(err);
    }

    private File replaceExtension(File file, String expectedExt, String newExt) {
        String name = file.getName();
        if (name.toLowerCase().endsWith(expectedExt)) {
            name = name.substring(0, name.length() - expectedExt.length());
        }
        name = name.concat(newExt);
        return new File(file.getParentFile(), name);
    }

    public void run() throws FOPException {
        if (this.task.getUserconfig() != null) {
            // empty if block
        }
        if (this.task.getBasedir() != null) {
            try {
                this.baseURL = this.task.getBasedir().toURL().toExternalForm();
            }
            catch (MalformedURLException mfue) {
                this.getLogger().error("Error creating base URL from base directory", (Throwable)mfue);
            }
        } else {
            try {
                if (this.task.getFofile() != null) {
                    this.baseURL = this.task.getFofile().getParentFile().toURL().toExternalForm();
                }
            }
            catch (MalformedURLException mfue) {
                this.getLogger().error("Error creating base URL from XSL-FO input file", (Throwable)mfue);
            }
        }
        this.task.log("Using base URL: " + this.baseURL, 4);
        int rint = this.determineRenderer(this.task.getFormat());
        String newExtension = this.determineExtension(rint);
        int actioncount = 0;
        if (this.task.getFofile() != null && this.task.getFofile().exists()) {
            File outf = this.task.getOutfile();
            if (outf == null) {
                throw new BuildException("outfile is required when fofile is used");
            }
            if (this.task.getOutdir() != null) {
                outf = new File(this.task.getOutdir(), outf.getName());
            }
            this.render(this.task.getFofile(), outf, rint);
            ++actioncount;
        }
        GlobPatternMapper mapper = new GlobPatternMapper();
        mapper.setFrom("*.fo");
        mapper.setTo("*" + newExtension);
        int i = 0;
        while (i < this.task.getFilesets().size()) {
            FileSet fs = (FileSet)this.task.getFilesets().get(i);
            DirectoryScanner ds = fs.getDirectoryScanner(this.task.getProject());
            String[] files = ds.getIncludedFiles();
            int j = 0;
            while (j < files.length) {
                File f = new File(fs.getDir(this.task.getProject()), files[j]);
                File outf = null;
                if (this.task.getOutdir() != null && files[j].endsWith(".fo")) {
                    String[] sa = mapper.mapFileName(files[j]);
                    outf = new File(this.task.getOutdir(), sa[0]);
                } else {
                    outf = this.replaceExtension(f, ".fo", newExtension);
                    if (this.task.getOutdir() != null) {
                        outf = new File(this.task.getOutdir(), outf.getName());
                    }
                }
                try {
                    if (this.baseURL == null) {
                        this.baseURL = fs.getDir(this.task.getProject()).toURL().toExternalForm();
                    }
                }
                catch (Exception e) {
                    this.task.log("Error setting base URL", 4);
                }
                this.render(f, outf, rint);
                ++actioncount;
                ++j;
            }
            ++i;
        }
        if (actioncount == 0) {
            this.task.log("No files processed. No files were selected by the filesets and no fofile was set.", 1);
        }
    }

    /*
     * Loose catch block
     */
    private void render(File foFile, File outFile, int renderer) throws FOPException {
        block10: {
            FOInputHandler inputHandler = new FOInputHandler(foFile);
            XMLReader parser = ((InputHandler)inputHandler).getParser();
            this.setParserFeatures(parser);
            FileOutputStream out = null;
            try {
                out = new FileOutputStream(outFile);
            }
            catch (Exception ex) {
                throw new BuildException("Failed to open " + outFile, (Throwable)ex);
            }
            if (this.task.getLogFiles()) {
                this.task.log(foFile + " -> " + outFile, 2);
            }
            Driver driver = new Driver();
            this.setupLogger(driver);
            driver.initialize();
            FOUserAgent userAgent = new FOUserAgent();
            userAgent.setBaseURL(this.baseURL);
            userAgent.enableLogging(this.getLogger());
            driver.setUserAgent(userAgent);
            driver.setRenderer(renderer);
            driver.setOutputStream(out);
            driver.render(parser, ((InputHandler)inputHandler).getInputSource());
            Object var10_11 = null;
            try {
                ((OutputStream)out).close();
            }
            catch (IOException ioe) {
                this.getLogger().error("Error closing output file", (Throwable)ioe);
            }
            break block10;
            {
                catch (Exception ex) {
                    throw new BuildException((Throwable)ex);
                }
            }
            catch (Throwable throwable) {
                Object var10_12 = null;
                try {
                    ((OutputStream)out).close();
                }
                catch (IOException ioe) {
                    this.getLogger().error("Error closing output file", (Throwable)ioe);
                }
                throw throwable;
            }
        }
    }
}

