/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.util;

import org.apache.fop.layout.FontState;

public class CharUtilities {
    public static final char CODE_EOT = '\u0000';
    public static final int UCWHITESPACE = 0;
    public static final int LINEFEED = 1;
    public static final int EOT = 2;
    public static final int NONWHITESPACE = 3;
    public static final int XMLWHITESPACE = 4;

    public static int classOf(char c) {
        if (c == '\u0000') {
            return 2;
        }
        if (c == '\n') {
            return 1;
        }
        if (c == ' ' || c == '\r' || c == '\t') {
            return 4;
        }
        if (CharUtilities.isAnySpace(c)) {
            return 0;
        }
        return 3;
    }

    public static int getCharWidth(char c, FontState fs) {
        int width;
        if (c == '\n' || c == '\r' || c == '\t' || c == '\u00a0') {
            width = CharUtilities.getCharWidth(' ', fs);
        } else {
            width = fs.getWidth(fs.mapChar(c));
            if (width <= 0) {
                int em = fs.getWidth(fs.mapChar('m'));
                int en = fs.getWidth(fs.mapChar('n'));
                if (em <= 0) {
                    em = 500 * fs.getFontSize();
                }
                if (en <= 0) {
                    en = em - 10;
                }
                if (c == ' ') {
                    width = em;
                }
                if (c == '\u2000') {
                    width = en;
                }
                if (c == '\u2001') {
                    width = em;
                }
                if (c == '\u2002') {
                    width = em / 2;
                }
                if (c == '\u2003') {
                    width = fs.getFontSize();
                }
                if (c == '\u2004') {
                    width = em / 3;
                }
                if (c == '\u2005') {
                    width = em / 4;
                }
                if (c == '\u2006') {
                    width = em / 6;
                }
                if (c == '\u2007') {
                    width = CharUtilities.getCharWidth(' ', fs);
                }
                if (c == '\u2008') {
                    width = CharUtilities.getCharWidth('.', fs);
                }
                if (c == '\u2009') {
                    width = em / 5;
                }
                if (c == '\u200a') {
                    width = 5;
                }
                if (c == '\u200b') {
                    width = 100;
                }
                if (c == '\u202f') {
                    width = CharUtilities.getCharWidth(' ', fs) / 2;
                }
                if (c == '\u3000') {
                    width = CharUtilities.getCharWidth(' ', fs) * 2;
                }
            }
        }
        return width;
    }

    public static boolean isSpace(char c) {
        return c == ' ' || c >= '\u2000' && c <= '\u200b';
    }

    public static boolean isNBSP(char c) {
        return c == '\u00a0' || c == '\u202f' || c == '\u3000' || c == '\ufeff';
    }

    public static boolean isAnySpace(char c) {
        boolean ret = CharUtilities.isSpace(c) || CharUtilities.isNBSP(c);
        return ret;
    }
}

