/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.viewer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import org.apache.fop.apps.AWTStarter;
import org.apache.fop.apps.FOPException;
import org.apache.fop.render.awt.AWTRenderer;
import org.apache.fop.viewer.Command;
import org.apache.fop.viewer.GoToPageDialog;
import org.apache.fop.viewer.PreviewDialogAboutBox;
import org.apache.fop.viewer.Translator;

public class PreviewDialog
extends JFrame {
    protected Translator translator;
    protected AWTRenderer renderer;
    protected AWTStarter starter;
    private int currentPage = 0;
    private int pageCount = 0;
    private Reloader reloader;
    private JComboBox scale;
    private JLabel processStatus;
    private JLabel pageLabel;
    private JLabel infoStatus;

    public PreviewDialog(AWTStarter aStarter, AWTRenderer aRenderer, Translator aRes) {
        this(aRenderer, aRes);
        this.starter = aStarter;
    }

    public PreviewDialog(AWTRenderer aRenderer, Translator aRes) {
        this.translator = aRes;
        this.renderer = aRenderer;
        Command printAction = new Command(this.translator.getString("Menu.Print"), "Print"){

            public void doit() {
                PreviewDialog.this.print();
            }
        };
        Command firstPageAction = new Command(this.translator.getString("Menu.First.page"), "firstpg"){

            public void doit() {
                PreviewDialog.this.goToFirstPage();
            }
        };
        Command previousPageAction = new Command(this.translator.getString("Menu.Prev.page"), "prevpg"){

            public void doit() {
                PreviewDialog.this.goToPreviousPage();
            }
        };
        Command nextPageAction = new Command(this.translator.getString("Menu.Next.page"), "nextpg"){

            public void doit() {
                PreviewDialog.this.goToNextPage();
            }
        };
        Command lastPageAction = new Command(this.translator.getString("Menu.Last.page"), "lastpg"){

            public void doit() {
                PreviewDialog.this.goToLastPage();
            }
        };
        Command reloadAction = new Command(this.translator.getString("Menu.Reload"), "reload"){

            public void doit() {
                PreviewDialog.this.reload();
            }
        };
        this.setTitle("FOP: AWT-" + this.translator.getString("Title.Preview"));
        this.setDefaultCloseOperation(2);
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        this.setSize(screen.width * 61 / 100, screen.height * 9 / 10);
        this.pageLabel = new JLabel();
        JScrollPane previewArea = new JScrollPane(this.pageLabel);
        previewArea.getViewport().setBackground(Color.gray);
        previewArea.setMinimumSize(new Dimension(50, 50));
        this.getContentPane().add((Component)previewArea, "Center");
        this.scale = new JComboBox();
        this.scale.addItem("25%");
        this.scale.addItem("50%");
        this.scale.addItem("75%");
        this.scale.addItem("100%");
        this.scale.addItem("150%");
        this.scale.addItem("200%");
        this.scale.setMaximumSize(new Dimension(80, 24));
        this.scale.setPreferredSize(new Dimension(80, 24));
        this.scale.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PreviewDialog.this.scaleActionPerformed(e);
            }
        });
        this.scale.setSelectedItem("100%");
        this.renderer.setScaleFactor(100.0);
        this.setJMenuBar(this.setupMenu());
        JToolBar toolBar = new JToolBar();
        toolBar.add(printAction);
        toolBar.add(reloadAction);
        toolBar.addSeparator();
        toolBar.add(firstPageAction);
        toolBar.add(previousPageAction);
        toolBar.add(nextPageAction);
        toolBar.add(lastPageAction);
        toolBar.addSeparator();
        toolBar.add(new JLabel(this.translator.getString("Menu.Zoom")));
        toolBar.addSeparator();
        toolBar.add(this.scale);
        this.getContentPane().add((Component)toolBar, "North");
        JPanel statusBar = new JPanel();
        this.processStatus = new JLabel();
        this.processStatus.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(0, 3, 0, 0)));
        this.infoStatus = new JLabel();
        this.infoStatus.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(0, 3, 0, 0)));
        statusBar.setLayout(new GridBagLayout());
        this.processStatus.setPreferredSize(new Dimension(200, 21));
        this.processStatus.setMinimumSize(new Dimension(200, 21));
        this.infoStatus.setPreferredSize(new Dimension(100, 21));
        this.infoStatus.setMinimumSize(new Dimension(100, 21));
        statusBar.add((Component)this.processStatus, new GridBagConstraints(0, 0, 1, 0, 2.0, 0.0, 10, 2, new Insets(0, 0, 0, 3), 0, 0));
        statusBar.add((Component)this.infoStatus, new GridBagConstraints(1, 0, 1, 0, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.getContentPane().add((Component)statusBar, "South");
    }

    private JMenuBar setupMenu() {
        JMenuBar menuBar = new JMenuBar();
        JMenu menu = new JMenu(this.translator.getString("Menu.File"));
        menu.add(new Command(this.translator.getString("Menu.Print")){

            public void doit() {
                PreviewDialog.this.print();
            }
        });
        menu.add(new Command(this.translator.getString("Menu.Reload")){

            public void doit() {
                PreviewDialog.this.reload();
            }
        });
        menu.addSeparator();
        menu.add(new Command(this.translator.getString("Menu.Exit")){

            public void doit() {
                PreviewDialog.this.dispose();
            }
        });
        menuBar.add(menu);
        menu = new JMenu(this.translator.getString("Menu.View"));
        menu.add(new Command(this.translator.getString("Menu.First.page")){

            public void doit() {
                PreviewDialog.this.goToFirstPage();
            }
        });
        menu.add(new Command(this.translator.getString("Menu.Prev.page")){

            public void doit() {
                PreviewDialog.this.goToPreviousPage();
            }
        });
        menu.add(new Command(this.translator.getString("Menu.Next.page")){

            public void doit() {
                PreviewDialog.this.goToNextPage();
            }
        });
        menu.add(new Command(this.translator.getString("Menu.Last.page")){

            public void doit() {
                PreviewDialog.this.goToLastPage();
            }
        });
        menu.add(new Command(this.translator.getString("Menu.Go.to.Page") + " ..."){

            public void doit() {
                PreviewDialog.this.showGoToPageDialog();
            }
        });
        menu.addSeparator();
        JMenu subMenu = new JMenu(this.translator.getString("Menu.Zoom"));
        subMenu.add(new Command("25%"){

            public void doit() {
                PreviewDialog.this.setScale(25.0);
            }
        });
        subMenu.add(new Command("50%"){

            public void doit() {
                PreviewDialog.this.setScale(50.0);
            }
        });
        subMenu.add(new Command("75%"){

            public void doit() {
                PreviewDialog.this.setScale(75.0);
            }
        });
        subMenu.add(new Command("100%"){

            public void doit() {
                PreviewDialog.this.setScale(100.0);
            }
        });
        subMenu.add(new Command("150%"){

            public void doit() {
                PreviewDialog.this.setScale(150.0);
            }
        });
        subMenu.add(new Command("200%"){

            public void doit() {
                PreviewDialog.this.setScale(200.0);
            }
        });
        menu.add(subMenu);
        menu.addSeparator();
        menu.add(new Command(this.translator.getString("Menu.Default.zoom")){

            public void doit() {
                PreviewDialog.this.setScale(100.0);
            }
        });
        menuBar.add(menu);
        menu = new JMenu(this.translator.getString("Menu.Help"));
        menu.add(new Command(this.translator.getString("Menu.About")){

            public void doit() {
                PreviewDialog.this.startHelpAbout();
            }
        });
        menuBar.add(menu);
        return menuBar;
    }

    private void startHelpAbout() {
        PreviewDialogAboutBox dlg = new PreviewDialogAboutBox((Frame)this, this.translator);
        Dimension dlgSize = dlg.getPreferredSize();
        Dimension frmSize = this.getSize();
        Point loc = this.getLocation();
        dlg.setLocation((frmSize.width - dlgSize.width) / 2 + loc.x, (frmSize.height - dlgSize.height) / 2 + loc.y);
        dlg.setVisible(true);
    }

    private void goToPage(int number) {
        this.currentPage = number;
        this.renderer.setPageNumber(number);
        this.showPage();
    }

    private void goToPreviousPage() {
        if (this.currentPage <= 0) {
            return;
        }
        --this.currentPage;
        this.goToPage(this.currentPage);
    }

    private void goToNextPage() {
        if (this.currentPage >= this.pageCount - 1) {
            return;
        }
        ++this.currentPage;
        this.goToPage(this.currentPage);
    }

    private void goToLastPage() {
        if (this.currentPage == this.pageCount - 1) {
            return;
        }
        this.currentPage = this.pageCount - 1;
        this.goToPage(this.currentPage);
    }

    private synchronized void reload() {
        if (this.reloader == null || !this.reloader.isAlive()) {
            this.reloader = new Reloader();
            this.reloader.start();
        }
    }

    private void showGoToPageDialog() {
        GoToPageDialog d = new GoToPageDialog((Frame)this, this.translator.getString("Menu.Go.to.Page"), this.translator);
        d.setLocation((int)this.getLocation().getX() + 50, (int)this.getLocation().getY() + 50);
        d.setVisible(true);
        this.currentPage = d.getPageNumber();
        if (this.currentPage < 1 || this.currentPage > this.pageCount) {
            return;
        }
        --this.currentPage;
        this.goToPage(this.currentPage);
    }

    private void goToFirstPage() {
        if (this.currentPage == 0) {
            return;
        }
        this.currentPage = 0;
        this.goToPage(this.currentPage);
    }

    private void print() {
        block2: {
            PrinterJob pj = PrinterJob.getPrinterJob();
            pj.setPageable(this.renderer);
            if (!pj.printDialog()) break block2;
            try {
                pj.print();
            }
            catch (PrinterException pe) {
                pe.printStackTrace();
            }
        }
    }

    private void setScale(double scaleFactor) {
        if (scaleFactor == 25.0) {
            this.scale.setSelectedIndex(0);
        } else if (scaleFactor == 50.0) {
            this.scale.setSelectedIndex(1);
        } else if (scaleFactor == 75.0) {
            this.scale.setSelectedIndex(2);
        } else if (scaleFactor == 100.0) {
            this.scale.setSelectedIndex(3);
        } else if (scaleFactor == 150.0) {
            this.scale.setSelectedIndex(4);
        } else if (scaleFactor == 200.0) {
            this.scale.setSelectedIndex(5);
        }
        this.renderer.setScaleFactor(scaleFactor);
        this.showPage();
    }

    private void scaleActionPerformed(ActionEvent e) {
        String item = (String)this.scale.getSelectedItem();
        this.setScale(Double.parseDouble(item.substring(0, item.indexOf(37))));
    }

    public void setStatus(String message) {
        SwingUtilities.invokeLater(new ShowStatus(message));
    }

    public void showPage() {
        ShowPageImage viewer = new ShowPageImage();
        if (SwingUtilities.isEventDispatchThread()) {
            viewer.run();
        } else {
            SwingUtilities.invokeLater(viewer);
        }
    }

    public void reportException(Exception e) {
        String msg = this.translator.getString("Exception.Occured");
        this.setStatus(msg);
        JOptionPane.showMessageDialog(this.getContentPane(), "<html><b>" + msg + ":</b><br>" + e.getClass().getName() + "<br>" + e.getMessage() + "</html>", this.translator.getString("Exception.Error"), 0);
    }

    private class ShowPageImage
    implements Runnable {
        private ShowPageImage() {
        }

        public void run() {
        }
    }

    private class ShowStatus
    implements Runnable {
        private String message;

        public ShowStatus(String message) {
            this.message = message;
        }

        public void run() {
            PreviewDialog.this.processStatus.setText(this.message.toString());
        }
    }

    private class Reloader
    extends Thread {
        private Reloader() {
        }

        public void run() {
            PreviewDialog.this.pageLabel.setIcon(null);
            PreviewDialog.this.infoStatus.setText("");
            PreviewDialog.this.currentPage = 0;
            try {
                PreviewDialog.this.starter.run();
            }
            catch (FOPException e) {
                PreviewDialog.this.reportException(e);
            }
        }
    }
}

