/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.decoder.pict;

import com.sun.jimi.core.JimiException;
import com.sun.jimi.core.compat.AdaptiveRasterImage;
import com.sun.jimi.core.compat.JimiDecoderBase;
import com.sun.jimi.core.decoder.pict.PICTBitmap;
import com.sun.jimi.core.decoder.pict.PICTColorTable;
import com.sun.jimi.core.decoder.pict.PICTFileHeader;
import com.sun.jimi.core.decoder.pict.PICTPixmap;
import com.sun.jimi.core.decoder.pict.PICTPixmap9A;
import com.sun.jimi.core.decoder.pict.PICTRectangle;
import com.sun.jimi.core.util.JimiUtil;
import com.sun.jimi.core.util.Packbits;
import com.sun.jimi.util.ByteCountInputStream;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;

public class PICTDecoder
extends JimiDecoderBase {
    private AdaptiveRasterImage ji;
    private InputStream in;
    private ByteCountInputStream bcis;
    private DataInputStream dIn;
    private int state;
    PICTFileHeader pictFH;
    public static final int PICT_CLIP_RGN = 1;
    public static final int PICT_BITSRECT = 144;
    public static final int PICT_BITSRGN = 145;
    public static final int PICT_PACKBITSRECT = 152;
    public static final int PICT_PACKBITSRGN = 153;
    public static final int PICT_9A = 154;
    public static final int PICT_HEADER = 3072;
    public static final int PICT_END = 255;
    public static final int PICT_LONGCOMMENT = 161;
    int rowBytes;
    static final int INITIAL = 1;
    static final int STATE2 = 2;
    int pictState;

    public boolean driveDecoder() throws JimiException {
        switch (this.pictState) {
            case 1: {
                try {
                    this.pictFH = new PICTFileHeader(this.dIn);
                }
                catch (IOException iOException) {
                    throw new JimiException("IO error reading PICT file");
                }
                this.pictState = 2;
                this.state |= 2;
                return true;
            }
            case 2: {
                try {
                    int n;
                    if (this.pictFH.ver1) {
                        n = this.dIn.readUnsignedByte();
                    } else {
                        if ((this.bcis.getCount() & 1L) != 0L) {
                            this.dIn.readByte();
                        }
                        n = this.dIn.readUnsignedShort();
                    }
                    boolean bl = this.drivePictDecoder(n);
                    return bl;
                }
                catch (IOException iOException) {
                    this.state |= 1;
                    throw new JimiException("reading opcode/version");
                }
                catch (JimiException jimiException) {
                    this.state |= 1;
                    throw jimiException;
                }
            }
        }
        return true;
    }

    boolean drivePictDecoder(int n) throws JimiException, IOException {
        boolean bl = false;
        switch (n) {
            case 145: {
                this.handlePackBits(n);
                break;
            }
            case 153: {
                this.handlePackBits(n);
                break;
            }
            case 1: {
                this.skip_01();
                break;
            }
            case 144: {
                this.handlePackBits(n);
                break;
            }
            case 152: {
                this.handlePackBits(n);
                break;
            }
            case 154: {
                this.handlePackBits(n);
                break;
            }
            case 161: {
                this.skip_06();
                break;
            }
            case 255: {
                this.state |= 4;
                return false;
            }
        }
        if (bl) {
            this.skipPictOpcode(n);
        }
        return true;
    }

    public void freeDecoder() throws JimiException {
        this.in = null;
        this.dIn = null;
        this.pictState = 1;
        this.ji = null;
    }

    public AdaptiveRasterImage getJimiImage() {
        return this.ji;
    }

    public int getState() {
        return this.state;
    }

    void handleBitmap(int n) throws IOException, JimiException {
        this.rowBytes &= 0x3FFF;
        DirectColorModel directColorModel = new DirectColorModel(1, 1, 1, 1);
        PICTBitmap pICTBitmap = new PICTBitmap(this.dIn);
        int n2 = pICTBitmap.bounding.brX - pICTBitmap.bounding.tlX;
        int n3 = pICTBitmap.bounding.brY - pICTBitmap.bounding.tlY;
        this.ji.setSize(n2, n3);
        this.ji.setColorModel(directColorModel);
        this.ji.setPixels();
        byte[] byArray = new byte[this.rowBytes + 1 + this.rowBytes / 128];
        byte[] byArray2 = new byte[this.rowBytes];
        byte[] byArray3 = new byte[n2];
        int n4 = 0;
        while (n4 < n3) {
            int n5;
            if (this.rowBytes < 8) {
                this.dIn.readFully(byArray, 0, this.rowBytes);
                n5 = byArray.length;
                while (--n5 >= 0) {
                    byArray[n5] = ~byArray[n5];
                }
                JimiUtil.expandPixels(1, byArray, byArray3, byArray3.length);
            } else {
                n5 = this.rowBytes > 250 ? this.dIn.readUnsignedShort() : this.dIn.readUnsignedByte();
                this.dIn.readFully(byArray, 0, n5);
                Packbits.unpackbits(byArray, byArray2);
                int n6 = byArray2.length;
                while (--n6 >= 0) {
                    byArray2[n6] = ~byArray2[n6];
                }
                JimiUtil.expandPixels(1, byArray2, byArray3, byArray3.length);
            }
            this.ji.setChannel(0, n4, byArray3);
            this.setProgress(n4 * 100 / (n3 - 1));
            ++n4;
        }
    }

    void handlePackBits(int n) throws IOException, JimiException {
        if (n == 154) {
            this.handlePixmap(n);
        } else {
            this.rowBytes = this.dIn.readUnsignedShort();
            if (this.pictFH.ver1 || (this.rowBytes & 0x8000) == 0) {
                this.handleBitmap(n);
            } else {
                this.handlePixmap(n);
            }
        }
        this.ji.addFullCoverage();
    }

    void handlePixmap(int n) throws IOException, JimiException {
        short s;
        short s2;
        int n2;
        int n3;
        ColorModel colorModel;
        block6: {
            PICTColorTable pICTColorTable;
            PICTPixmap pICTPixmap;
            block5: {
                pICTPixmap = null;
                PICTPixmap9A pICTPixmap9A = null;
                pICTColorTable = null;
                colorModel = null;
                if (n != 154) break block5;
                pICTPixmap9A = new PICTPixmap9A(this.dIn);
                n3 = pICTPixmap9A.bounding.brX - pICTPixmap9A.bounding.tlX;
                n2 = pICTPixmap9A.bounding.brY - pICTPixmap9A.bounding.tlY;
                s2 = pICTPixmap9A.pixelSize;
                s = pICTPixmap9A.compCount;
                switch (s2) {
                    case 32: {
                        this.rowBytes = n3 * pICTPixmap9A.compCount;
                        colorModel = new DirectColorModel(24, 0xFF0000, 65280, 255);
                        break block6;
                    }
                    case 16: {
                        this.rowBytes = n3 * 2;
                        colorModel = new DirectColorModel(16, 31744, 992, 31);
                        break block6;
                    }
                    default: {
                        throw new JimiException("Opcode 9a has pixelSize of " + s2);
                    }
                }
            }
            this.rowBytes &= 0x3FFF;
            pICTPixmap = new PICTPixmap(this.dIn);
            pICTColorTable = new PICTColorTable(this.dIn);
            colorModel = pICTColorTable.createColorModel(pICTPixmap);
            n3 = pICTPixmap.bounding.brX - pICTPixmap.bounding.tlX;
            n2 = pICTPixmap.bounding.brY - pICTPixmap.bounding.tlY;
            s2 = pICTPixmap.pixelSize;
            s = pICTPixmap.compCount;
        }
        PICTRectangle pICTRectangle = new PICTRectangle(this.dIn);
        PICTRectangle pICTRectangle2 = new PICTRectangle(this.dIn);
        short s3 = this.dIn.readShort();
        if (n == 145 || n == 153) {
            this.skip_01();
        }
        this.ji.setSize(n3, n2);
        this.ji.setColorModel(colorModel);
        this.ji.setPixels();
        this.handlePixmap(this.ji, this.rowBytes, s2, s);
    }

    private void handlePixmap(AdaptiveRasterImage adaptiveRasterImage, int n, int n2, short s) throws IOException, JimiException {
        boolean bl = n >= 8 || n2 == 32;
        int n3 = n;
        byte[] byArray = null;
        byte[] byArray2 = null;
        int[] nArray = null;
        int n4 = adaptiveRasterImage.getWidth();
        int n5 = adaptiveRasterImage.getHeight();
        int n6 = n4;
        switch (n2) {
            case 32: {
                if (!bl) {
                    nArray = new int[n4];
                    break;
                }
                byArray = new byte[n3];
                break;
            }
            case 16: {
                nArray = new int[n4];
                break;
            }
            case 8: {
                byArray = new byte[n3];
                break;
            }
            default: {
                byArray2 = new byte[n6];
                byArray = new byte[n3];
            }
        }
        if (!bl) {
            byte[] byArray3 = new byte[n3];
            int n7 = 0;
            while (n7 < n5) {
                this.dIn.readFully(byArray3, 0, n);
                switch (n2) {
                    case 16: {
                        int n8 = 0;
                        while (n8 < n4) {
                            nArray[n8] = ((byArray3[n8 * 2] & 0xFF) << 8) + (byArray3[n8 * 2 + 1] & 0xFF);
                            ++n8;
                        }
                        adaptiveRasterImage.setChannel(n7, nArray);
                        break;
                    }
                    case 8: {
                        adaptiveRasterImage.setChannel(0, n7, byArray3);
                        break;
                    }
                    default: {
                        JimiUtil.expandPixels(n2, byArray3, byArray2, byArray2.length);
                        adaptiveRasterImage.setChannel(0, n7, byArray2);
                    }
                }
                this.setProgress(n7 * 100 / n5);
                ++n7;
            }
        } else {
            byte[] byArray4 = new byte[n3 + 1 + n3 / 128];
            int n9 = 0;
            while (n9 < n5) {
                int n10 = n > 250 ? this.dIn.readUnsignedShort() : this.dIn.readUnsignedByte();
                if (n10 > n3 + 1 + n3 / 128) {
                    throw new JimiException("**** rawLen " + n10 + " bufSize " + n3);
                }
                this.dIn.readFully(byArray4, 0, n10);
                if (n2 == 16) {
                    Packbits.unpackbits(byArray4, nArray);
                    adaptiveRasterImage.setChannel(n9, nArray);
                } else {
                    try {
                        Packbits.unpackbitsLimit(byArray4, n10, byArray);
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        throw new JimiException("Error unpacking data");
                    }
                    if (n2 < 8) {
                        JimiUtil.expandPixels(n2, byArray, byArray2, byArray2.length);
                        adaptiveRasterImage.setChannel(0, n9, byArray2);
                    } else if (n2 == 8) {
                        adaptiveRasterImage.setChannel(0, n9, byArray);
                    } else if (n2 == 24 || n2 == 32) {
                        int n11 = 0;
                        if (s == 4) {
                            adaptiveRasterImage.setChannel(24, n9, byArray, n11, n4);
                            n11 += n4;
                        }
                        adaptiveRasterImage.setChannel(16, n9, byArray, n11, n4);
                        adaptiveRasterImage.setChannel(8, n9, byArray, n11 += n4, n4);
                        adaptiveRasterImage.setChannel(0, n9, byArray, n11 += n4, n4);
                    }
                }
                ++n9;
            }
            this.setProgress(n9 * 100 / n5);
        }
    }

    public void initDecoder(InputStream inputStream, AdaptiveRasterImage adaptiveRasterImage) throws JimiException {
        this.in = inputStream;
        this.bcis = new ByteCountInputStream(new BufferedInputStream(inputStream));
        this.dIn = new DataInputStream(this.bcis);
        this.ji = adaptiveRasterImage;
        this.state = 0;
        this.pictState = 1;
    }

    void skipPictOpcode(int n) {
    }

    void skip_01() throws IOException {
        short s = this.dIn.readShort();
        this.dIn.skip(s - 2);
    }

    void skip_02() throws IOException {
        this.dIn.skip(4L);
        this.skip_03();
    }

    void skip_03() throws IOException {
        int n = this.dIn.readUnsignedByte();
        this.dIn.skip(n);
    }

    void skip_04() throws IOException {
        this.dIn.skip(1L);
        this.skip_03();
    }

    void skip_05() throws IOException {
    }

    void skip_06() throws IOException {
        this.dIn.skip(2L);
        int n = this.dIn.readUnsignedShort();
        this.dIn.skip(n);
    }

    public boolean usesChanneledData() {
        return true;
    }
}

