/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.util;

import com.sun.jimi.core.util.OctreeCallback;
import com.sun.jimi.core.util.OctreeNode;
import com.sun.jimi.util.ExpandableArray;

public final class ColorOctree
implements OctreeCallback {
    int leaf_level = 8;
    int maxColors;
    OctreeNode tree;
    ExpandableArray[] reduce;
    int numLeaves = 0;
    protected boolean alpha;
    int cacheCount;
    public ExpandableArray cachedONodes;
    public static final int MAXCACHE = 25;
    boolean caching;

    public ColorOctree(int n) {
        this.maxColors = n;
        this.tree = new OctreeNode(this);
        this.reduce = new ExpandableArray[8];
        int n2 = 0;
        while (n2 < 8) {
            this.reduce[n2] = new ExpandableArray(10, 10);
            ++n2;
        }
        this.cachedONodes = new ExpandableArray(10);
    }

    public void addColor(int n) {
        if ((n & 0xFF000000) == 0) {
            if (!this.alpha) {
                this.alpha = true;
                --this.maxColors;
                if (this.numLeaves > this.maxColors) {
                    this.reduceColors();
                }
            }
        } else {
            this.numLeaves += this.tree.insertColor(n, this.leaf_level);
            if (this.numLeaves > this.maxColors) {
                this.reduceColors();
            }
        }
    }

    public void addColor(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            if ((nArray[n] & 0xFF000000) == 0) {
                if (!this.alpha) {
                    this.alpha = true;
                    --this.maxColors;
                    if (this.numLeaves > this.maxColors) {
                        this.reduceColors();
                    }
                }
            } else {
                this.numLeaves += this.tree.insertColor(nArray[n], this.leaf_level);
                if (this.numLeaves > this.maxColors) {
                    this.reduceColors();
                }
            }
            ++n;
        }
    }

    public void cacheONode(OctreeNode octreeNode) {
        int n = octreeNode.level;
        OctreeNode.levCounts[n] = OctreeNode.levCounts[n] - 1;
        if (this.caching && this.cacheCount < 25) {
            this.cachedONodes.addElement(octreeNode);
            ++this.cacheCount;
        }
    }

    public OctreeNode getONode(OctreeCallback octreeCallback, int n) {
        OctreeNode octreeNode;
        if (this.cacheCount > 0) {
            octreeNode = (OctreeNode)this.cachedONodes.lastElement();
            this.cachedONodes.removeElementAt(this.cacheCount - 1);
            --this.cacheCount;
            octreeNode.setFields(octreeCallback, n);
        } else {
            octreeNode = new OctreeNode(octreeCallback, n);
        }
        return octreeNode;
    }

    int getPalette(byte[] byArray) {
        byte[] byArray2 = new byte[1024];
        int n = this.tree.createPalette(byArray2, 0) / 3;
        n = Math.min(n, this.maxColors);
        int n2 = 0;
        int n3 = 0;
        while (n2 < n * 3) {
            byArray[n3++] = byArray2[n2++];
            byArray[n3++] = byArray2[n2++];
            byArray[n3++] = byArray2[n2++];
            byArray[n3++] = -1;
        }
        return this.alpha ? n + 1 : n;
    }

    public OctreeNode getReducible() {
        OctreeNode octreeNode = null;
        int n = this.leaf_level - 1;
        while (this.reduce[n].size() == 0) {
            --n;
        }
        ExpandableArray expandableArray = this.reduce[n];
        int n2 = expandableArray.size();
        if (n2 > 0) {
            int n3 = 0;
            octreeNode = (OctreeNode)expandableArray.elementAt(0);
            int n4 = 1;
            while (n4 < n2) {
                OctreeNode octreeNode2 = (OctreeNode)expandableArray.elementAt(n4);
                if (octreeNode2.count >= octreeNode.count) {
                    octreeNode = octreeNode2;
                    n3 = n4;
                }
                ++n4;
            }
            expandableArray.removeElementAt(n3);
        }
        return octreeNode;
    }

    public boolean hasAlpha() {
        return this.alpha;
    }

    public void markReducible(OctreeNode octreeNode) {
        octreeNode.marked = true;
        this.reduce[octreeNode.level].addElement(octreeNode);
    }

    int quantizeColor(int n) {
        if ((n & 0xFF000000) == 0) {
            return this.maxColors * 3;
        }
        return this.tree.quantizeColor(n);
    }

    void reduceColors() {
        this.caching = true;
        OctreeNode octreeNode = this.getReducible();
        this.numLeaves -= octreeNode.collapseOctree();
        octreeNode.leaf = true;
        ++this.numLeaves;
        if (octreeNode.level < this.leaf_level - 1) {
            this.leaf_level = octreeNode.level + 1;
        }
    }
}

