/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.util.launcher;

import java.net.URL;

public final class CompoundClassLoader
extends ClassLoader {
    private final ClassLoader m_secondary;

    private CompoundClassLoader(ClassLoader parent, ClassLoader secondary) {
        super(parent);
        this.m_secondary = secondary;
    }

    protected Class findClass(String name) throws ClassNotFoundException {
        return this.m_secondary.loadClass(name);
    }

    public URL getResource(String name) {
        URL url = super.getResource(name);
        if (null != url) {
            return url;
        }
        return this.m_secondary.getResource(name);
    }

    public static ClassLoader join(ClassLoader parent, ClassLoader secondary) {
        if (null == secondary) {
            return parent;
        }
        return new CompoundClassLoader(parent, secondary);
    }
}

