/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.util.launcher;

import java.io.File;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import org.openorb.util.launcher.ModuleClassLoader;
import org.openorb.util.launcher.PropertyManager;

public class Start {
    private static final String ORB_CLASS_KEY = "org.omg.CORBA.ORBClass";
    private static final String ORB_SINGLETON_CLASS_KEY = "org.omg.CORBA.ORBSingletonClass";
    private static final String OPENORB_ORB_CLASS = "org.openorb.orb.core.ORB";
    private static final String OPENORB_ORB_SINGLETON_CLASS = "org.openorb.orb.core.ORBSingleton";
    private URLClassLoader m_classLoader;
    static /* synthetic */ Class class$org$openorb$util$launcher$Start;

    public Start(String[] args) {
        String mainClass = args[0];
        try {
            this.m_classLoader = new ModuleClassLoader(mainClass);
        }
        catch (Exception e) {
            this.layout();
            e.printStackTrace();
            return;
        }
        Thread.currentThread().setContextClassLoader(this.m_classLoader);
        this.fixURLProtocolHandler();
        String[] mainArgs = null;
        if (args.length > 1) {
            mainArgs = new String[args.length - 1];
            System.arraycopy(args, 1, mainArgs, 0, mainArgs.length);
        }
        if (mainArgs == null) {
            mainArgs = new String[]{};
        }
        this.launchClass(mainClass, mainArgs);
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            Start.usage();
            return;
        }
        System.setProperty(ORB_CLASS_KEY, OPENORB_ORB_CLASS);
        System.setProperty(ORB_SINGLETON_CLASS_KEY, OPENORB_ORB_SINGLETON_CLASS);
        System.setProperty("javax.rmi.CORBA.StubClass", "org.openorb.orb.rmi.StubDelegateImpl");
        System.setProperty("javax.rmi.CORBA.UtilClass", "org.openorb.orb.rmi.UtilDelegateImpl");
        System.setProperty("javax.rmi.CORBA.PortableRemoteObjectClass", "org.openorb.orb.rmi.PortableRemoteObjectDelegateImpl");
        new Start(args);
    }

    private static void usage() {
        File file = new File((class$org$openorb$util$launcher$Start == null ? (class$org$openorb$util$launcher$Start = Start.class$("org.openorb.util.launcher.Start")) : class$org$openorb$util$launcher$Start).getProtectionDomain().getCodeSource().getLocation().getFile());
        String name = "-jar " + file.getName();
        if (!name.endsWith(".jar")) {
            name = (class$org$openorb$util$launcher$Start == null ? (class$org$openorb$util$launcher$Start = Start.class$("org.openorb.util.launcher.Start")) : class$org$openorb$util$launcher$Start).getName();
        }
        System.err.println("java " + name + " <class_to_start> [parameters]");
    }

    private void layout() {
        System.err.println("");
        System.err.println("The Community OpenORB (TCOO) environment has not been setup properly!");
        System.err.println("The following folder layout is required:");
        System.err.println("");
        System.err.println("    <TCOO_HOME>");
        System.err.println("        |- tools");
        System.err.println("        |- OpenORB");
        System.err.println("");
    }

    private void showClassPath() {
        System.err.println("ClassPath: ");
        URL[] cp = this.m_classLoader.getURLs();
        if (cp != null) {
            int i = 0;
            while (i < cp.length) {
                System.err.println("   " + cp[i].toExternalForm());
                ++i;
            }
        }
    }

    private void launchClass(String className, String[] args) {
        try {
            Class<?> mainClass = this.m_classLoader.loadClass(className);
            Method mainMethod = mainClass.getMethod("main", args.getClass());
            mainMethod.invoke(null, new Object[]{args});
        }
        catch (ClassNotFoundException cnf) {
            System.err.println("Unable to locate class: " + className);
            this.showClassPath();
        }
        catch (NoSuchMethodException nsm) {
            System.err.println("No main() method in class: " + className);
        }
        catch (NoClassDefFoundError ncdf) {
            ncdf.printStackTrace();
            this.showClassPath();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private void fixURLProtocolHandler() {
        PropertyManager.JAVA_PROTOCOL_HANDLER_PKGS.postfixValue("org.openorb.util.urlhandler");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

