/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.util;

public final class CharacterCache {
    private static final String DISABLE_CACHE_KEY = "openorb.cache.disable";
    private static final boolean DISABLE_CACHE = "true".equals(System.getProperty("openorb.cache.disable"));

    private CharacterCache() {
    }

    public static Character getCharacter(char value) {
        if (DISABLE_CACHE) {
            return new Character(value);
        }
        return Cache.getCharacter(value);
    }

    private static final class Cache {
        private static final String CACHE_MIN_KEY = "openorb.cache.character.min";
        private static final String CACHE_MAX_KEY = "openorb.cache.character.max";
        private static final char CACHE_MIN_DEFAULT = '\u0000';
        private static final char CACHE_MAX_DEFAULT = '\u00ff';
        private static final Character[] CACHE;
        private static final char CACHE_MIN;
        private static final char CACHE_MAX;

        private Cache() {
        }

        private static char parseValue(String key, char defaultValue) {
            String value = System.getProperty(key);
            if (null == value) {
                return defaultValue;
            }
            if (1 == value.length()) {
                return value.charAt(0);
            }
            if (!value.startsWith("\\u")) {
                return defaultValue;
            }
            try {
                return (char)Integer.parseInt(value.substring(2), 16);
            }
            catch (NumberFormatException e) {
                return defaultValue;
            }
        }

        static Character getCharacter(char value) {
            if (CACHE_MIN <= value && value <= CACHE_MIN) {
                return CACHE[value - CACHE_MIN];
            }
            return new Character(value);
        }

        static {
            CACHE_MIN = Cache.parseValue(CACHE_MIN_KEY, '\u0000');
            CACHE_MAX = Cache.parseValue(CACHE_MAX_KEY, '\u00ff');
            CACHE = new Character[CACHE_MAX - CACHE_MIN + 1];
            int i = 0;
            while (i < CACHE.length) {
                Cache.CACHE[i] = new Character((char)(i + CACHE_MIN));
                ++i;
            }
        }
    }
}

