/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.util;

import org.omg.CORBA.SystemException;
import org.omg.CORBA.UserException;
import org.openorb.util.JREVersion;

public final class ExceptionTool {
    private static final boolean JRE_1_4 = JREVersion.V1_4;

    private ExceptionTool() {
    }

    public static Throwable getCause(Throwable e) {
        return e.getCause();
    }

    public static SystemException initCause(SystemException e, Throwable cause) {
        if (JRE_1_4 && null != cause) {
            e.initCause(cause);
        }
        return e;
    }

    public static UserException initCause(UserException e, Throwable cause) {
        if (JRE_1_4 && null != cause) {
            e.initCause(cause);
        }
        return e;
    }

    public static Throwable initCause(Throwable e, Throwable cause) {
        if (JRE_1_4 && null != cause) {
            e.initCause(cause);
        }
        return e;
    }

    public static RuntimeException initCause(RuntimeException e, Throwable cause) {
        if (JRE_1_4 && null != cause) {
            e.initCause(cause);
        }
        return e;
    }

    public static Error initCause(Error e, Throwable cause) {
        if (JRE_1_4 && null != cause) {
            e.initCause(cause);
        }
        return e;
    }

    public static Throwable appendCause(Throwable e, Throwable cause) {
        if (!JRE_1_4 || null == cause) {
            return e;
        }
        Throwable current = e;
        while (null != current.getCause()) {
            current = current.getCause();
        }
        try {
            current.initCause(cause);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        return e;
    }

    public static Throwable appendPossibleCause(Throwable e, Throwable cause) {
        if (!JRE_1_4 || null == cause) {
            return e;
        }
        PossibleCause possibleCause = new PossibleCause(cause);
        return ExceptionTool.appendCause(e, possibleCause);
    }

    private static final class PossibleCause
    extends Throwable {
        private static final String STANDARD_MESSAGE = "The next cause is a possible cause of previous exception";
        private static final StackTraceElement[] NO_STACK = new StackTraceElement[0];

        public PossibleCause(Throwable cause) {
            super(STANDARD_MESSAGE, cause);
            this.setStackTrace(NO_STACK);
        }

        public Throwable fillInStackTrace() {
            return this;
        }
    }
}

