/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.util;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class HexPrintStream
extends FilterOutputStream {
    public static final int FORMAT_SIMPLE = 0;
    public static final int FORMAT_HEXONLY = 1;
    public static final int FORMAT_MIXED = 2;
    public static final int FORMAT_MIXED_TWOLINE = 3;
    private byte[] m_store = null;
    private int m_stoff;
    private int m_format;
    private byte[] m_hexbuf = null;
    private static final byte[] LINE_SEPARATOR = System.getProperty("line.separator").getBytes();

    public HexPrintStream(OutputStream out) {
        this(out, 0);
    }

    public HexPrintStream(OutputStream out, int format) {
        super(out);
        this.setFormat(format);
    }

    public void write(int val) throws IOException {
        if (this.m_store == null) {
            this.m_store = new byte[0];
            this.m_store[0] = (byte)val;
            this.m_stoff = 1;
            this.flush();
            this.m_store = null;
        } else {
            this.m_store[++this.m_stoff] = (byte)val;
            if (this.m_stoff >= this.m_store.length) {
                this.flush();
            }
        }
    }

    public void write(byte[] buf) throws IOException {
        this.write(buf, 0, buf.length);
    }

    public void write(byte[] buf, int off, int len) throws IOException {
        if (off + len > buf.length) {
            throw new IOException("Offset and length arguments are greater than the length of the buffer");
        }
        if (this.m_store == null) {
            if (off == 0) {
                this.m_store = buf;
            } else {
                this.m_store = new byte[len];
                System.arraycopy(buf, off, this.m_store, 0, len);
            }
            this.m_stoff = len;
            this.flush();
            this.m_store = null;
            return;
        }
        if (len < this.m_store.length - this.m_stoff) {
            System.arraycopy(buf, off, this.m_store, this.m_stoff, len);
            this.m_stoff += len;
            return;
        }
        if (this.m_stoff > 0) {
            System.arraycopy(buf, off, this.m_store, this.m_stoff, this.m_store.length - this.m_stoff);
            off += this.m_store.length - this.m_stoff;
            len -= this.m_store.length - this.m_stoff;
            this.m_stoff = this.m_store.length;
            this.flush();
        }
        while (len >= this.m_store.length) {
            System.arraycopy(buf, off, this.m_store, 0, this.m_store.length);
            off += this.m_store.length;
            len -= this.m_store.length;
            this.m_stoff = this.m_store.length;
            this.flush();
        }
        if (len > 0) {
            System.arraycopy(buf, off, this.m_store, 0, len);
            this.m_stoff = len;
        }
    }

    public void flush() throws IOException {
        if (this.m_stoff == 0) {
            return;
        }
        if (this.m_hexbuf == null || this.m_hexbuf.length < this.m_stoff * 2) {
            this.m_hexbuf = new byte[this.m_stoff * 2];
        }
        int i = 0;
        while (i < this.m_stoff) {
            int lo = this.m_store[i] & 0xF;
            int hi = this.m_store[i] >>> 4 & 0xF;
            this.m_hexbuf[i * 2] = hi < 10 ? (byte)(48 + hi) : (byte)(65 + hi - 10);
            this.m_hexbuf[i * 2 + 1] = lo < 10 ? (byte)(48 + lo) : (byte)(65 + lo - 10);
            ++i;
        }
        switch (this.m_format) {
            case 2: {
                int i2 = 0;
                while (i2 < this.m_stoff) {
                    if (!HexPrintStream.isPrintable((byte)(this.m_store[i2] & 0x7F))) {
                        this.m_store[i2] = 46;
                    }
                    ++i2;
                }
                int i3 = this.m_stoff;
                while (i3 < this.m_store.length) {
                    this.m_store[i3] = 32;
                    ++i3;
                }
                this.out.write(this.m_store, 0, 8);
                this.out.write(32);
                this.out.write(this.m_store, 8, 8);
                this.out.write(32);
                this.out.write(32);
            }
            case 1: {
                int i4 = 0;
                while (i4 < this.m_stoff - 3) {
                    this.out.write(this.m_hexbuf, i4 * 2, 8);
                    this.out.write(32);
                    i4 += 4;
                }
                if (this.m_stoff % 4 != 0) {
                    this.out.write(this.m_hexbuf, this.m_stoff / 4 * 8, this.m_stoff % 4 * 2);
                }
                this.out.write(LINE_SEPARATOR);
                break;
            }
            case 3: {
                int i5 = 0;
                while (i5 < this.m_stoff) {
                    if (Character.isISOControl((char)(this.m_store[i5] & 0x7F))) {
                        this.out.write(45);
                        this.out.write(45);
                    } else {
                        this.out.write(this.m_store[i5]);
                        this.out.write(32);
                    }
                    if ((i5 + 1) % 4 == 0) {
                        this.out.write(32);
                    }
                    ++i5;
                }
                this.out.write(LINE_SEPARATOR);
                int i6 = 0;
                while (i6 < this.m_stoff - 3) {
                    this.out.write(this.m_hexbuf, i6 * 2, 8);
                    this.out.write(32);
                    i6 += 4;
                }
                if (this.m_stoff % 4 != 0) {
                    this.out.write(this.m_hexbuf, this.m_stoff / 4 * 8, this.m_stoff % 4 * 2);
                }
                this.out.write(LINE_SEPARATOR);
                break;
            }
            default: {
                this.out.write(this.m_hexbuf, 0, 2 * this.m_stoff);
            }
        }
        this.m_stoff = 0;
    }

    public void close() throws IOException {
        this.flush();
        this.out.close();
    }

    public int getFormat() {
        return this.m_format;
    }

    public void setFormat(int format) {
        try {
            this.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.m_format = format;
        switch (format) {
            case 2: {
                this.m_store = new byte[16];
                break;
            }
            case 1: 
            case 3: {
                this.m_store = new byte[32];
                break;
            }
            default: {
                this.m_store = null;
            }
        }
    }

    public static String toHex(int val) {
        byte[] bytes = new byte[]{(byte)(val >>> 24), (byte)(val >>> 16), (byte)(val >>> 8), (byte)val};
        char[] m_hexbuf = new char[8];
        int i = 0;
        while (i < 4) {
            int lo = bytes[i] & 0xF;
            int hi = bytes[i] >>> 4 & 0xF;
            m_hexbuf[i * 2] = hi < 10 ? (char)(48 + hi) : (char)(65 + hi - 10);
            m_hexbuf[i * 2 + 1] = lo < 10 ? (char)(48 + lo) : (char)(65 + lo - 10);
            ++i;
        }
        return new String(m_hexbuf);
    }

    public static String toHex(short val) {
        byte[] bytes = new byte[]{(byte)(val >>> 8), (byte)val};
        char[] m_hexbuf = new char[4];
        int i = 0;
        while (i < 2) {
            int lo = bytes[i] & 0xF;
            int hi = bytes[i] >>> 4 & 0xF;
            m_hexbuf[i * 2] = hi < 10 ? (char)(48 + hi) : (char)(65 + hi - 10);
            m_hexbuf[i * 2 + 1] = lo < 10 ? (char)(48 + lo) : (char)(65 + lo - 10);
            ++i;
        }
        return new String(m_hexbuf);
    }

    public static String toHex(byte val) {
        byte[] bytes = new byte[]{val};
        char[] m_hexbuf = new char[2];
        int lo = bytes[0] & 0xF;
        int hi = bytes[0] >>> 4 & 0xF;
        m_hexbuf[0] = hi < 10 ? (char)(48 + hi) : (char)(65 + hi - 10);
        m_hexbuf[1] = lo < 10 ? (char)(48 + lo) : (char)(65 + lo - 10);
        return new String(m_hexbuf);
    }

    public static String toHex(byte[] arr) {
        String result = null;
        if (arr != null && arr.length > 0) {
            StringBuffer buf = new StringBuffer(arr.length + 1);
            int i = 0;
            while (i < arr.length) {
                if (!Character.isISOControl((char)arr[i])) {
                    buf.append((char)arr[i]);
                } else {
                    buf.append(".");
                }
                ++i;
            }
            result = buf.toString();
        }
        return result;
    }

    public static boolean isPrintable(byte value) {
        switch (Character.getType((char)value)) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 26: 
            case 27: {
                return true;
            }
        }
        return false;
    }

    public static void main(String[] args) {
        try {
            int len = Integer.parseInt(args[0]);
            byte[] buf = new byte[len];
            int i = 0;
            while (i < buf.length) {
                buf[i] = (byte)i;
                ++i;
            }
            HexPrintStream ps = new HexPrintStream(System.out);
            int i2 = 0;
            while (i2 < 4) {
                System.out.println("Format: " + i2);
                ps.setFormat(i2);
                ps.write(buf);
                ps.flush();
                System.out.println();
                ++i2;
            }
        }
        catch (IOException ex) {
            System.out.println(ex);
        }
    }
}

