/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.util;

import java.util.AbstractSequentialList;
import java.util.ConcurrentModificationException;
import java.util.ListIterator;
import java.util.NoSuchElementException;

public class MergeStack
extends AbstractSequentialList {
    private static final int DEFAULT_ALLOC_INC = 10;
    private static final Object LIST_EMPTY_OBJ = new Object();
    private int m_allocInc;
    private int m_size = 0;
    private PartialList m_head = null;
    private PartialList m_tail = null;
    private int m_modCount = 0;

    public MergeStack() {
        this(10);
    }

    public MergeStack(int allocInc) {
        this.m_allocInc = allocInc;
        this.m_tail = this.m_head = new PartialList(this.m_allocInc);
    }

    public void clear() {
        this.m_tail = this.m_head = new PartialList(this.m_allocInc);
        this.m_size = 0;
    }

    public ListIterator listIterator(int index) {
        if (index > this.m_size || index < 0) {
            throw new IndexOutOfBoundsException();
        }
        return new MSListIterator(index);
    }

    public int size() {
        return this.m_size;
    }

    public boolean add(Object obj) {
        this.addLast(obj);
        return true;
    }

    public Object getFirst() throws NoSuchElementException {
        if (this.m_size == 0) {
            throw new NoSuchElementException();
        }
        Object ret = this.m_head.getFirst();
        if (ret == LIST_EMPTY_OBJ) {
            throw new Error("Illegal condition detected in MergerStack(" + System.identityHashCode(this) + ").getFirst() : [ret == LIST_EMPTY_OBJ]");
        }
        return ret;
    }

    public void addFirst(Object obj) {
        if (!this.m_head.addFirst(obj)) {
            PartialList n = this.m_head.setPrev(new PartialList(this.m_allocInc));
            n.setNext(this.m_head);
            this.m_head = n;
            this.m_head.addFirst(obj);
        }
        ++this.m_size;
        ++this.m_modCount;
    }

    /*
     * Unable to fully structure code
     */
    public Object removeFirst() throws NoSuchElementException {
        if (this.m_size != 0) ** GOTO lbl6
        throw new NoSuchElementException();
lbl-1000:
        // 1 sources

        {
            this.m_head = this.m_head.getNext();
            this.m_head.setPrev(null);
lbl6:
            // 2 sources

            ** while ((ret = this.m_head.removeFirst()) == MergeStack.LIST_EMPTY_OBJ)
        }
lbl7:
        // 1 sources

        --this.m_size;
        ++this.m_modCount;
        return ret;
    }

    public Object getLast() throws NoSuchElementException {
        if (this.m_size == 0) {
            throw new NoSuchElementException();
        }
        Object ret = this.m_tail.getLast();
        if (ret == LIST_EMPTY_OBJ) {
            throw new Error("Illegal condition detected in MergerStack(" + System.identityHashCode(this) + ").getLast() : [ret == LIST_EMPTY_OBJ]");
        }
        return ret;
    }

    public void addLast(Object obj) {
        if (!this.m_tail.addLast(obj)) {
            PartialList n = this.m_tail.setNext(new PartialList(this.m_allocInc));
            n.setPrev(this.m_tail);
            this.m_tail = n;
            this.m_tail.addLast(obj);
        }
        ++this.m_size;
        ++this.m_modCount;
    }

    /*
     * Unable to fully structure code
     */
    public Object removeLast() throws NoSuchElementException {
        if (this.m_size != 0) ** GOTO lbl6
        throw new NoSuchElementException();
lbl-1000:
        // 1 sources

        {
            this.m_tail = this.m_tail.getPrev();
            this.m_tail.setNext(null);
lbl6:
            // 2 sources

            ** while ((ret = this.m_tail.removeLast()) == MergeStack.LIST_EMPTY_OBJ)
        }
lbl7:
        // 1 sources

        --this.m_size;
        ++this.m_modCount;
        return ret;
    }

    public void append(MergeStack next) {
        if (next.m_size == 0) {
            return;
        }
        this.m_size += next.m_size;
        ++this.m_modCount;
        this.m_tail.append(next.m_head);
        if (this.m_tail.getNext() != null) {
            this.m_tail = next.m_tail;
        }
        next.clear();
    }

    private static void testList(MergeStack s, int c) {
        ListIterator itt = s.listIterator(0);
        int i = 0;
        while (i < c) {
            if (itt.nextIndex() != i) {
                throw new Error("itt.nextIndex() != i");
            }
            if ((Integer)itt.next() != i) {
                throw new Error("((Integer)itt.next()).intValue() != i");
            }
            ++i;
        }
        if (itt.hasNext()) {
            throw new Error("itt.hasNext()");
        }
        int i2 = 0;
        while (i2 < c) {
            if ((Integer)s.removeFirst() != i2) {
                throw new Error("((Integer)s.removeFirst()).intValue() != i");
            }
            ++i2;
        }
        if (!s.isEmpty()) {
            throw new Error("!s.isEmpty()");
        }
    }

    private class MSListIterator
    implements ListIterator {
        private int m_mod;
        private int m_index;
        private PartialList m_curr;
        private int m_currIdx;
        private int m_repl = 1;

        MSListIterator(int index) {
            this.m_mod = MergeStack.this.m_modCount;
            this.m_index = index;
            if (index < MergeStack.this.m_size / 2) {
                this.m_curr = MergeStack.this.m_head;
                this.m_currIdx = 0;
                while (index > this.m_curr.size()) {
                    index -= this.m_curr.size();
                    this.m_curr = this.m_curr.getNext();
                }
                this.m_currIdx = index;
            } else {
                this.m_curr = MergeStack.this.m_tail;
                index = MergeStack.this.m_size - index;
                while (index > this.m_curr.size()) {
                    index -= this.m_curr.size();
                    this.m_curr = this.m_curr.getPrev();
                }
                this.m_currIdx = this.m_curr.size() - index;
            }
        }

        public int previousIndex() {
            if (this.m_mod != MergeStack.this.m_modCount) {
                throw new ConcurrentModificationException();
            }
            return this.m_index - 1;
        }

        public boolean hasNext() {
            if (this.m_mod != MergeStack.this.m_modCount) {
                throw new ConcurrentModificationException();
            }
            return this.m_index < MergeStack.this.m_size;
        }

        public void set(Object o) {
            if (this.m_mod != MergeStack.this.m_modCount) {
                throw new ConcurrentModificationException();
            }
            if (this.m_repl > 0) {
                throw new IllegalStateException();
            }
            this.m_curr.set(this.m_currIdx + this.m_repl, o);
        }

        public Object next() {
            if (this.m_mod != MergeStack.this.m_modCount) {
                throw new ConcurrentModificationException();
            }
            if (this.m_index == MergeStack.this.m_size) {
                throw new NoSuchElementException();
            }
            Object ret = this.m_curr.get(this.m_currIdx);
            if (++this.m_currIdx >= this.m_curr.size()) {
                this.m_curr = this.m_curr.getNext();
                this.m_currIdx = 0;
            }
            ++this.m_index;
            this.m_repl = 0;
            return ret;
        }

        public int nextIndex() {
            if (this.m_mod != MergeStack.this.m_modCount) {
                throw new ConcurrentModificationException();
            }
            return this.m_index;
        }

        public void remove() {
            if (this.m_index == 0) {
                MergeStack.this.removeFirst();
                this.m_curr = MergeStack.this.m_head;
                this.m_mod = MergeStack.this.m_modCount;
            } else if (this.m_index == MergeStack.this.m_size) {
                MergeStack.this.removeLast();
                this.m_curr = MergeStack.this.m_tail;
                this.m_mod = MergeStack.this.m_modCount;
            } else {
                throw new UnsupportedOperationException();
            }
        }

        public boolean hasPrevious() {
            if (this.m_mod != MergeStack.this.m_modCount) {
                throw new ConcurrentModificationException();
            }
            return this.m_index > 0;
        }

        public void add(Object o) {
            if (this.m_index == 0) {
                MergeStack.this.addFirst(o);
                this.m_curr = MergeStack.this.m_head;
                this.m_mod = MergeStack.this.m_modCount;
            } else if (this.m_index == MergeStack.this.m_size) {
                MergeStack.this.addLast(o);
                this.m_curr = MergeStack.this.m_tail;
                this.m_mod = MergeStack.this.m_modCount;
            } else {
                throw new UnsupportedOperationException();
            }
        }

        public Object previous() {
            if (this.m_mod != MergeStack.this.m_modCount) {
                throw new ConcurrentModificationException();
            }
            if (this.m_index == 0) {
                throw new NoSuchElementException();
            }
            if (--this.m_currIdx < 0) {
                this.m_curr = this.m_curr.getPrev();
                this.m_currIdx = this.m_curr.size() - 1;
            }
            --this.m_index;
            this.m_repl = -1;
            return this.m_curr.get(this.m_currIdx);
        }
    }

    private static final class PartialList {
        private final Object[] m_objects;
        private final int m_capacity;
        private int m_start = 0;
        private int m_end = 0;
        private PartialList m_prev = null;
        private PartialList m_next = null;

        PartialList(int capacity) {
            this.m_capacity = capacity;
            this.m_objects = new Object[this.m_capacity];
        }

        public PartialList getPrev() {
            return this.m_prev;
        }

        public PartialList setPrev(PartialList prev) {
            this.m_prev = prev;
            return this.m_prev;
        }

        public PartialList getNext() {
            return this.m_next;
        }

        public PartialList setNext(PartialList next) {
            this.m_next = next;
            return this.m_next;
        }

        boolean full() {
            return this.m_end == this.m_start + this.m_capacity;
        }

        boolean empty() {
            return this.m_end == this.m_start;
        }

        int size() {
            return this.m_end - this.m_start;
        }

        Object getLast() {
            if (this.empty()) {
                return LIST_EMPTY_OBJ;
            }
            return this.m_objects[(this.m_end - 1) % this.m_capacity];
        }

        boolean addLast(Object obj) {
            if (this.full()) {
                return false;
            }
            this.m_objects[this.m_end % this.m_capacity] = obj;
            ++this.m_end;
            return true;
        }

        Object removeLast() {
            if (this.empty()) {
                return LIST_EMPTY_OBJ;
            }
            int p = --this.m_end % this.m_capacity;
            Object ret = this.m_objects[p];
            this.m_objects[p] = null;
            return ret;
        }

        Object getFirst() {
            if (this.empty()) {
                return LIST_EMPTY_OBJ;
            }
            return this.m_objects[this.m_start];
        }

        boolean addFirst(Object obj) {
            if (this.full()) {
                return false;
            }
            if (--this.m_start < 0) {
                this.m_start = this.m_capacity - 1;
                this.m_end += this.m_capacity;
            }
            this.m_objects[this.m_start] = obj;
            return true;
        }

        Object removeFirst() {
            if (this.empty()) {
                return LIST_EMPTY_OBJ;
            }
            Object ret = this.m_objects[this.m_start];
            this.m_objects[this.m_start] = null;
            if (++this.m_start == this.m_capacity) {
                this.m_start = 0;
                this.m_end -= this.m_capacity;
            }
            return ret;
        }

        Object get(int pos) {
            if (pos >= this.size()) {
                throw new IndexOutOfBoundsException();
            }
            return this.m_objects[(this.m_start + pos) % this.m_capacity];
        }

        Object set(int pos, Object repl) {
            if (pos >= this.size()) {
                throw new IndexOutOfBoundsException();
            }
            Object ret = this.m_objects[(this.m_start + pos) % this.m_capacity];
            this.m_objects[(this.m_start + pos) % this.m_capacity] = repl;
            return ret;
        }

        void append(PartialList next) {
            int nsize = next.size();
            if (this.m_capacity - this.size() >= nsize) {
                int i = 0;
                while (i < nsize) {
                    this.m_objects[(this.m_end + i) % this.m_capacity] = next.m_objects[(next.m_start + i) % next.m_capacity];
                    ++i;
                }
                this.m_end += nsize;
                this.m_next = next.m_next;
            } else {
                this.m_next = next;
            }
            if (this.m_next != null) {
                this.m_next.m_prev = this;
            }
        }
    }
}

