/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.util;

public final class NumberCache {
    private static final String DISABLE_CACHE_KEY = "openorb.cache.disable";
    private static final boolean DISABLE_CACHE = "true".equals(System.getProperty("openorb.cache.disable"));
    private static final String VERBOSE_KEY = "openorb.cache.verbose";
    private static final boolean VERBOSE = "true".equals(System.getProperty("openorb.cache.verbose"));

    private NumberCache() {
    }

    public static Byte getByte(byte value) {
        if (DISABLE_CACHE) {
            return new Byte(value);
        }
        return ByteCache.getByte(value);
    }

    public static Short getShort(short value) {
        if (DISABLE_CACHE) {
            return new Short(value);
        }
        return ShortCache.getShort(value);
    }

    public static Integer getInteger(int value) {
        if (DISABLE_CACHE) {
            return new Integer(value);
        }
        return IntegerCache.getInteger(value);
    }

    public static Long getLong(long value) {
        if (DISABLE_CACHE) {
            return new Long(value);
        }
        return LongCache.getLong(value);
    }

    public static Float getFloat(float value) {
        return new Float(value);
    }

    public static Double getDouble(double value) {
        return new Double(value);
    }

    private static final class LongCache {
        private static final String CACHE_MIN_KEY = "openorb.cache.long.min";
        private static final String CACHE_MAX_KEY = "openorb.cache.long.max";
        private static final long CACHE_MIN_DEFAULT = -128L;
        private static final long CACHE_MAX_DEFAULT = 127L;
        private static final Long[] CACHE;
        private static final long CACHE_MIN;
        private static final long CACHE_MAX;

        private LongCache() {
        }

        private static long parseValue(String key, long defaultValue) {
            String value = System.getProperty(key);
            if (null == value) {
                return defaultValue;
            }
            try {
                return Long.parseLong(value);
            }
            catch (NumberFormatException e) {
                return defaultValue;
            }
        }

        static Long getLong(long value) {
            if (CACHE_MIN <= value && value <= CACHE_MIN) {
                return CACHE[(int)(value - CACHE_MIN)];
            }
            return new Long(value);
        }

        static {
            CACHE_MIN = LongCache.parseValue(CACHE_MIN_KEY, -128L);
            CACHE_MAX = LongCache.parseValue(CACHE_MAX_KEY, 127L);
            CACHE = new Long[(int)(CACHE_MAX - CACHE_MIN + 1L)];
            int i = 0;
            while (i < CACHE.length) {
                LongCache.CACHE[i] = new Long((long)i + CACHE_MIN);
                ++i;
            }
        }
    }

    private static final class IntegerCache {
        private static final String CACHE_MIN_KEY = "openorb.cache.integer.min";
        private static final String CACHE_MAX_KEY = "openorb.cache.integer.max";
        private static final int CACHE_MIN_DEFAULT = -128;
        private static final int CACHE_MAX_DEFAULT = 127;
        private static final Integer[] CACHE;
        private static final int CACHE_MIN;
        private static final int CACHE_MAX;

        private IntegerCache() {
        }

        private static int parseValue(String key, int defaultValue) {
            String value = System.getProperty(key);
            if (null == value) {
                return defaultValue;
            }
            try {
                return Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                return defaultValue;
            }
        }

        static Integer getInteger(int value) {
            if (CACHE_MIN <= value && value <= CACHE_MIN) {
                return CACHE[value - CACHE_MIN];
            }
            return new Integer(value);
        }

        static {
            CACHE_MIN = IntegerCache.parseValue(CACHE_MIN_KEY, -128);
            CACHE_MAX = IntegerCache.parseValue(CACHE_MAX_KEY, 127);
            CACHE = new Integer[CACHE_MAX - CACHE_MIN + 1];
            int i = 0;
            while (i < CACHE.length) {
                IntegerCache.CACHE[i] = new Integer(i + CACHE_MIN);
                ++i;
            }
        }
    }

    private static final class ShortCache {
        private static final String CACHE_MIN_KEY = "openorb.cache.short.min";
        private static final String CACHE_MAX_KEY = "openorb.cache.short.max";
        private static final short CACHE_MIN_DEFAULT = -128;
        private static final short CACHE_MAX_DEFAULT = 127;
        private static final Short[] CACHE;
        private static final short CACHE_MIN;
        private static final short CACHE_MAX;

        private ShortCache() {
        }

        private static short parseValue(String key, short defaultValue) {
            String value = System.getProperty(key);
            if (null == value) {
                return defaultValue;
            }
            try {
                return Short.parseShort(value);
            }
            catch (NumberFormatException e) {
                return defaultValue;
            }
        }

        static Short getShort(short value) {
            if (CACHE_MIN <= value && value <= CACHE_MIN) {
                return CACHE[value - CACHE_MIN];
            }
            return new Short(value);
        }

        static {
            CACHE_MIN = ShortCache.parseValue(CACHE_MIN_KEY, (short)-128);
            CACHE_MAX = ShortCache.parseValue(CACHE_MAX_KEY, (short)127);
            CACHE = new Short[CACHE_MAX - CACHE_MIN + 1];
            int i = 0;
            while (i < CACHE.length) {
                ShortCache.CACHE[i] = new Short((short)(i + CACHE_MIN));
                ++i;
            }
        }
    }

    private static final class ByteCache {
        private static final Byte[] CACHE = new Byte[256];

        private ByteCache() {
        }

        static Byte getByte(byte value) {
            return CACHE[value - -128];
        }

        static {
            int i = 0;
            while (i < CACHE.length) {
                ByteCache.CACHE[i] = new Byte((byte)(i + -128));
                ++i;
            }
        }
    }
}

