/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;

public abstract class ORBUtils {
    public static final String ORB_CLASS_KEY = "org.omg.CORBA.ORBClass";
    public static final String ORB_SINGLETON_CLASS_KEY = "org.omg.CORBA.ORBSingletonClass";
    public static final String OPENORB_ORB_CLASS = "org.openorb.orb.core.ORB";
    public static final String OPENORB_ORB_SINGLETON_CLASS = "org.openorb.orb.core.ORBSingleton";
    public static final String ORB_ARG_PREFIX = "-ORB";
    public static final String[] ORB_FLAG_ARGS = new String[]{"-ORBNoProprietaryActivation"};
    private static final Vector ORB_FLAG_ARG_LIST = new Vector(ORB_FLAG_ARGS.length);
    public static final String[] ORB_VALUE_ARGS = new String[]{"-ORBPort", "-ORBid", "-ORBServerid", "-ORBListenEndpoints", "-ORBInitRef", "-ORBDefaultInitRef"};
    private static final Vector ORB_VALUE_ARG_LIST = new Vector(ORB_VALUE_ARGS.length);
    private static final String PROPERTY_OO_HOME = "openorb.home.path";
    private static final String PROPERTY_USER_HOME = "user.home";
    private static final String PROPERTY_TMP_DIR = "java.io.tmpdir";
    private static final String OO_TMP_DIRNAME = ".OpenORB";
    public static final String IOR_FILE_EXT = ".ior";
    public static final String URL_FILE_EXT = ".url";
    public static final int MAJOR = 1;
    public static final int MINOR = 4;
    public static final int BUGFIX = 0;
    public static final String VERSION = "1.4.0";
    public static final String NAME = "The Community OpenORB";
    public static final String YEAR = "2002-2005";
    public static final String COPYRIGHT = "Copyright (c) 2002-2005 The Community OpenORB";
    public static final String OPENORB_PKG_PREFIX = "org.openorb";
    private static final java.lang.Object SYNC_MAP = new java.lang.Object();
    private static final HashMap RIR_MAP = new HashMap();
    private static final HashMap SHORT_LONG_MAP = new HashMap();
    private static final HashMap VERSION_MAP = new HashMap();

    private ORBUtils() {
    }

    public static boolean isFlagArg(String arg) {
        return ORB_FLAG_ARG_LIST.contains(arg);
    }

    public static boolean isValueArg(String arg) {
        return ORB_VALUE_ARG_LIST.contains(arg);
    }

    public static String[] extractORBArgs(String[] args) {
        Vector<String> v = new Vector<String>(args.length);
        int i = 0;
        while (i < args.length) {
            if (args[i].startsWith(ORB_ARG_PREFIX)) {
                v.add(args[i]);
                if (ORBUtils.isValueArg(args[i]) && i + 1 <= args.length) {
                    v.add(args[++i]);
                }
            }
            ++i;
        }
        return v.toArray(new String[v.size()]);
    }

    public static String[] extractNonORBArgs(String[] args) {
        Vector<String> v = new Vector<String>(args.length);
        int i = 0;
        while (i < args.length) {
            if (args[i].startsWith(ORB_ARG_PREFIX)) {
                if (ORBUtils.isValueArg(args[i])) {
                    ++i;
                }
            } else {
                v.add(args[i]);
            }
            ++i;
        }
        return v.toArray(new String[v.size()]);
    }

    public static String getShortNameFromClass(Class clz) {
        String result = null;
        if (clz != null && clz.getName().startsWith(OPENORB_PKG_PREFIX)) {
            int skip = OPENORB_PKG_PREFIX.length() + 1;
            String clzName = clz.getName();
            int len = clzName.length();
            String suffix = clzName.substring(skip, len);
            int dot = suffix.indexOf(46);
            result = suffix.substring(0, dot);
        }
        return result;
    }

    public static String getLongFromShortName(String short_name) {
        java.lang.Object object = SYNC_MAP;
        synchronized (object) {
            if (SHORT_LONG_MAP.isEmpty()) {
                SHORT_LONG_MAP.put("ins", "NameService");
                SHORT_LONG_MAP.put("tns", "NameService");
                SHORT_LONG_MAP.put("ccs", "ConcurrencyControlService");
                SHORT_LONG_MAP.put("event", "EventService");
                SHORT_LONG_MAP.put("ir", "InterfaceRepository");
                SHORT_LONG_MAP.put("notify", "NotificationService");
                SHORT_LONG_MAP.put("property", "PropertyService");
                SHORT_LONG_MAP.put("time", "TimeService");
                SHORT_LONG_MAP.put("trader", "TradingService");
                SHORT_LONG_MAP.put("ots", "TransactionService");
            }
        }
        return (String)SHORT_LONG_MAP.get(short_name);
    }

    public static String getVersionFromShortName(String short_name) {
        java.lang.Object object = SYNC_MAP;
        synchronized (object) {
            if (VERSION_MAP.isEmpty()) {
                // empty if block
            }
        }
        String version = (String)VERSION_MAP.get(short_name);
        if (version == null) {
            version = VERSION;
        }
        return version;
    }

    public static boolean checkAddress(String addr) {
        int start;
        int end = addr.length();
        do {
            String strHost;
            int host;
            int proto;
            if ((start = addr.lastIndexOf(",", end)) < 0) {
                start = 0;
            }
            if ((proto = addr.indexOf(":", start)) < 0 || proto > end) {
                return false;
            }
            String strProtocol = addr.substring(start + 1, proto);
            if (strProtocol != null && strProtocol.length() > 0 && !strProtocol.equals("iiop")) {
                return false;
            }
            int vers = addr.indexOf("@", proto);
            if (vers > 0 && vers < end) {
                int min;
                int maj;
                int major = addr.indexOf(".", proto);
                if (major < 0 || major > vers) {
                    return false;
                }
                try {
                    maj = Integer.parseInt(addr.substring(proto + 1, major));
                    min = Integer.parseInt(addr.substring(major + 1, vers));
                }
                catch (NumberFormatException ex) {
                    return false;
                }
                if (maj != 1) {
                    return false;
                }
                if (min < 0 || min > 2) {
                    return false;
                }
            } else {
                vers = proto;
            }
            if ((host = addr.indexOf(":", vers + 1)) > 0 && host < end) {
                int iPort;
                try {
                    iPort = Integer.parseInt(addr.substring(host + 1, end));
                }
                catch (NumberFormatException ex) {
                    return false;
                }
                if (iPort < 0 || iPort > 65535) {
                    return false;
                }
            } else {
                host = end;
            }
            if ((strHost = addr.substring(vers + 1, host)) == null || strHost.length() == 0) {
                return false;
            }
            end = start;
        } while (start > 0);
        return true;
    }

    public static void writeURLToFile(String name, String url) {
        String fileName = name + URL_FILE_EXT;
        System.out.println("Exporting URL into " + fileName + " file.");
        try {
            FileOutputStream file = new FileOutputStream(fileName);
            PrintWriter pfile = new PrintWriter(file);
            pfile.println(url);
            pfile.close();
        }
        catch (IOException ex) {
            System.err.println("Unable to generate " + fileName + ": " + ex.getMessage());
        }
    }

    public static void writeIORToFile(ORB orb, String name, Object obj) {
        ORBUtils.writeIORToFileName(orb, name + IOR_FILE_EXT, obj);
    }

    public static String getIORFileName(String arg, String name) {
        String fileName;
        if (arg == null || arg.length() == 0) {
            fileName = name + IOR_FILE_EXT;
        } else {
            fileName = arg;
            File file = new File(fileName);
            if (file.isDirectory()) {
                if (!fileName.endsWith(File.separator)) {
                    fileName = fileName + File.separator;
                }
                fileName = fileName + name + IOR_FILE_EXT;
            }
        }
        return fileName;
    }

    public static void writeIORToFileName(ORB orb, String fileName, Object obj) {
        System.out.println("Exporting IOR into " + fileName + " file.");
        try {
            FileOutputStream file = new FileOutputStream(fileName);
            PrintWriter pfile = new PrintWriter(file);
            pfile.println(orb.object_to_string(obj));
            pfile.close();
        }
        catch (IOException ex) {
            System.err.println("Unable to generate " + fileName + ": " + ex.getMessage());
        }
    }

    public static File getTemporaryDir(String firstDirName, String subdirName) throws IOException {
        File dir;
        String rootdirName;
        if (firstDirName != null && (rootdirName = firstDirName) != null && rootdirName.length() != 0 && (dir = ORBUtils.makeOpenORBTempDirectory(rootdirName, subdirName)) != null) {
            return dir;
        }
        rootdirName = System.getProperty(PROPERTY_OO_HOME);
        if (rootdirName != null && rootdirName.length() != 0 && (dir = ORBUtils.makeOpenORBTempDirectory(rootdirName, subdirName)) != null) {
            return dir;
        }
        rootdirName = System.getProperty(PROPERTY_USER_HOME);
        if (rootdirName != null && rootdirName.length() != 0 && (dir = ORBUtils.makeOpenORBTempDirectory(rootdirName, subdirName)) != null) {
            return dir;
        }
        rootdirName = ".";
        if (rootdirName != null && rootdirName.length() != 0 && (dir = ORBUtils.makeOpenORBTempDirectory(rootdirName, subdirName)) != null) {
            return dir;
        }
        throw new IOException("unable to create OpenORB temporary directory:" + subdirName);
    }

    private static File makeOpenORBTempDirectory(String rootdirName, String subdirName) {
        boolean isSuccess;
        File dir;
        String fullname = rootdirName;
        if (!rootdirName.endsWith(File.separator)) {
            fullname = fullname + File.separator;
        }
        fullname = fullname + OO_TMP_DIRNAME;
        if (subdirName != null) {
            fullname = fullname + File.separator + subdirName;
            if (!subdirName.endsWith(File.separator)) {
                fullname = fullname + File.separator;
            }
        }
        if (!(dir = new File(fullname)).exists() && !(isSuccess = dir.mkdirs())) {
            return null;
        }
        return dir;
    }

    public static ORB createORB(String[] args, Properties props) {
        Properties p = null;
        p = props == null ? new Properties() : (Properties)((Hashtable)props).clone();
        String orbclass = (String)((Hashtable)p).get(ORB_CLASS_KEY);
        if (orbclass == null || orbclass.length() == 0) {
            boolean haveOpenORBClass = false;
            try {
                haveOpenORBClass = Thread.currentThread().getContextClassLoader().loadClass(OPENORB_ORB_CLASS) != null;
            }
            catch (ClassNotFoundException ex) {
                haveOpenORBClass = false;
            }
            if (haveOpenORBClass) {
                ((Hashtable)p).put(ORB_CLASS_KEY, OPENORB_ORB_CLASS);
                ((Hashtable)p).put(ORB_SINGLETON_CLASS_KEY, OPENORB_ORB_SINGLETON_CLASS);
            }
        }
        return ORB.init((String[])args, (Properties)p);
    }

    static {
        int i = 0;
        while (i < ORB_FLAG_ARGS.length) {
            ORB_FLAG_ARG_LIST.add(ORB_FLAG_ARGS[i]);
            ++i;
        }
        int i2 = 0;
        while (i2 < ORB_VALUE_ARGS.length) {
            ORB_VALUE_ARG_LIST.add(ORB_VALUE_ARGS[i2]);
            ++i2;
        }
    }
}

