/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.util;

import java.io.PrintStream;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public class ObjectDumper {
    private Object m_targetObject;
    private Class m_targetClass;
    private Constructor[] m_constructors;
    private Field[] m_fields;
    private Method[] m_methods;

    public ObjectDumper(Object obj) {
        this.m_targetObject = obj;
        this.m_targetClass = obj.getClass();
        this.m_constructors = this.m_targetClass.getDeclaredConstructors();
        this.m_fields = this.m_targetClass.getDeclaredFields();
        this.m_methods = this.m_targetClass.getDeclaredMethods();
    }

    public void dumpClass(PrintStream stream) {
        Class<?>[] interfaces;
        stream.println("                          CLASS:");
        stream.println("==================================================================");
        stream.print("NAME:                     ");
        stream.println(this.m_targetClass.getName());
        int m = this.m_targetClass.getModifiers();
        String modifier = "";
        if ((m & 2) != 0) {
            modifier = modifier + "private ";
        }
        if ((m & 4) != 0) {
            modifier = modifier + "protected ";
        }
        if ((m & 1) != 0) {
            modifier = modifier + "public ";
        }
        if ((m & 8) != 0) {
            modifier = modifier + "static ";
        }
        if ((m & 0x20) != 0) {
            modifier = modifier + "synchronized ";
        }
        if ((m & 0x400) != 0) {
            modifier = modifier + "abstract ";
        }
        if ((m & 0x10) != 0) {
            modifier = modifier + "final ";
        }
        if ((m & 0x200) != 0) {
            modifier = modifier + "interface ";
        }
        stream.print("MODIFIER:                 ");
        stream.println(modifier);
        String superClass = this.m_targetClass.getSuperclass().getName();
        if (superClass != null && superClass.length() > 0) {
            stream.print("SUPER CLASS:              ");
            stream.println(superClass);
        }
        if ((interfaces = this.m_targetClass.getInterfaces()) != null && interfaces.length > 0) {
            stream.print("INTERFACES:               ");
            int i = 0;
            while (i < interfaces.length) {
                stream.print(interfaces[i].getName());
                if (i < interfaces.length - 1) {
                    stream.print(", ");
                }
                ++i;
            }
        }
        stream.flush();
    }

    public void dumpConstructors(PrintStream stream) {
        stream.println("                          CONSTRUCTORS:");
        stream.println("==================================================================");
        int i = 0;
        while (i < this.m_constructors.length) {
            Class<?>[] exceptions;
            Constructor constructor = this.m_constructors[i];
            String name = constructor.getName();
            int m = constructor.getModifiers();
            String modifier = "";
            if ((m & 2) != 0) {
                modifier = modifier + "private ";
            }
            if ((m & 4) != 0) {
                modifier = modifier + "protected ";
            }
            if ((m & 1) != 0) {
                modifier = modifier + "public ";
            }
            if ((m & 8) != 0) {
                modifier = modifier + "static ";
            }
            if ((m & 0x20) != 0) {
                modifier = modifier + "synchronized ";
            }
            if ((m & 0x400) != 0) {
                modifier = modifier + "abstract ";
            }
            if ((m & 0x10) != 0) {
                modifier = modifier + "final ";
            }
            if ((m & 0x80) != 0) {
                modifier = modifier + "transient ";
            }
            if ((m & 0x40) != 0) {
                modifier = modifier + "volatile ";
            }
            if ((m & 0x100) != 0) {
                modifier = modifier + "native ";
            }
            if ((m & 0x800) != 0) {
                modifier = modifier + "strict ";
            }
            stream.print("MODIFIER:                 ");
            stream.println(modifier);
            stream.print("NAME:                     ");
            stream.println(name);
            Class<?>[] parameters = constructor.getParameterTypes();
            if (parameters != null && parameters.length > 0) {
                stream.print("PARAMETERS:               ");
                int j = 0;
                while (j < parameters.length) {
                    stream.print(parameters[j].getName());
                    if (j < parameters.length - 1) {
                        stream.print(", ");
                    }
                    ++j;
                }
                stream.println();
            }
            if ((exceptions = constructor.getExceptionTypes()) != null && exceptions.length > 0) {
                stream.print("EXCEPTIONS:               ");
                int j = 0;
                while (j < exceptions.length) {
                    stream.print(exceptions[j].getName());
                    if (j < exceptions.length - 1) {
                        stream.print(", ");
                    }
                    ++j;
                }
                stream.println();
            }
            if (i < this.m_constructors.length - 1) {
                stream.println("------------------------------------------------------------------");
            }
            ++i;
        }
        stream.flush();
    }

    public void dumpFields(PrintStream stream) {
        stream.println("                          FIELDS:");
        stream.println("==================================================================");
        int i = 0;
        while (i < this.m_fields.length) {
            block25: {
                try {
                    Field field = this.m_fields[i];
                    String name = field.getName();
                    int m = field.getModifiers();
                    String modifier = "";
                    if ((m & 2) != 0) {
                        modifier = modifier + "private ";
                    }
                    if ((m & 4) != 0) {
                        modifier = modifier + "protected ";
                    }
                    if ((m & 1) != 0) {
                        modifier = modifier + "public ";
                    }
                    if ((m & 8) != 0) {
                        modifier = modifier + "static ";
                    }
                    if ((m & 0x20) != 0) {
                        modifier = modifier + "synchronized ";
                    }
                    if ((m & 0x400) != 0) {
                        modifier = modifier + "abstract ";
                    }
                    if ((m & 0x10) != 0) {
                        modifier = modifier + "final ";
                    }
                    if ((m & 0x80) != 0) {
                        modifier = modifier + "transient ";
                    }
                    if ((m & 0x40) != 0) {
                        modifier = modifier + "volatile ";
                    }
                    String className = field.getType().getName();
                    stream.print("MODIFIER:                 ");
                    stream.println(modifier);
                    stream.print("CLASS:                    ");
                    stream.println(className);
                    stream.print("NAME:                     ");
                    stream.println(name);
                    Object value = field.get(this.m_targetObject);
                    stream.println("VALUE:");
                    if (className.startsWith("[")) {
                        this.printArray(value, stream);
                        stream.println();
                    } else {
                        stream.println(value);
                    }
                    if (i < this.m_fields.length - 1) {
                        stream.println("------------------------------------------------------------------");
                    }
                }
                catch (IllegalAccessException iae) {
                    String fieldName = this.m_fields[i].getName();
                    fieldName = fieldName.length() > 1 ? fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1) : fieldName.toUpperCase();
                    Method m = null;
                    try {
                        m = this.m_targetClass.getDeclaredMethod("get" + fieldName, null);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    if (m == null) {
                        try {
                            m = this.m_targetClass.getDeclaredMethod("is" + fieldName, null);
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                    if (m != null) {
                        try {
                            Object o = m.invoke(this.m_targetObject, null);
                            String n = o.getClass().getName();
                            stream.println("VALUE:");
                            if (n.startsWith("[")) {
                                this.printArray(o, stream);
                            } else {
                                stream.print(o);
                            }
                            stream.println();
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                    if (i >= this.m_fields.length - 1) break block25;
                    stream.println("------------------------------------------------------------------");
                }
            }
            ++i;
        }
        stream.flush();
    }

    private void printArray(Object obj, PrintStream stream) {
        int i = 0;
        boolean first = true;
        stream.print('{');
        try {
            while (true) {
                Object o = Array.get(obj, i);
                if (!first) {
                    stream.print(", ");
                } else {
                    first = false;
                }
                String n = o.getClass().getName();
                if (n.startsWith("[")) {
                    this.printArray(o, stream);
                } else {
                    stream.print(o);
                }
                if (++i % 50 != 0) continue;
                stream.println();
            }
        }
        catch (Exception e) {
            stream.print('}');
            return;
        }
    }

    public void dumpMethods(PrintStream stream) {
        stream.println("                          METHODS:");
        stream.println("==================================================================");
        int i = 0;
        while (i < this.m_methods.length) {
            Class<?>[] exceptions;
            Method method = this.m_methods[i];
            String name = method.getName();
            int m = method.getModifiers();
            String modifier = "";
            if ((m & 2) != 0) {
                modifier = modifier + "private ";
            }
            if ((m & 4) != 0) {
                modifier = modifier + "protected ";
            }
            if ((m & 1) != 0) {
                modifier = modifier + "public ";
            }
            if ((m & 8) != 0) {
                modifier = modifier + "static ";
            }
            if ((m & 0x20) != 0) {
                modifier = modifier + "synchronized ";
            }
            if ((m & 0x400) != 0) {
                modifier = modifier + "abstract ";
            }
            if ((m & 0x10) != 0) {
                modifier = modifier + "final ";
            }
            if ((m & 0x80) != 0) {
                modifier = modifier + "transient ";
            }
            if ((m & 0x40) != 0) {
                modifier = modifier + "volatile ";
            }
            if ((m & 0x100) != 0) {
                modifier = modifier + "native ";
            }
            if ((m & 0x800) != 0) {
                modifier = modifier + "strict ";
            }
            String returnType = method.getReturnType().getName();
            stream.print("MODIFIER:                 ");
            stream.println(modifier);
            stream.print("RETURN TYPE:              ");
            stream.println(returnType);
            stream.print("NAME:                     ");
            stream.println(name);
            Class<?>[] parameters = method.getParameterTypes();
            if (parameters != null && parameters.length > 0) {
                stream.print("PARAMETERS:               ");
                int j = 0;
                while (j < parameters.length) {
                    stream.print(parameters[j].getName());
                    if (j < parameters.length - 1) {
                        stream.print(", ");
                    }
                    ++j;
                }
                stream.println();
            }
            if ((exceptions = method.getExceptionTypes()) != null && exceptions.length > 0) {
                stream.print("EXCEPTIONS:               ");
                int j = 0;
                while (j < exceptions.length) {
                    stream.print(exceptions[j].getName());
                    if (j < exceptions.length - 1) {
                        stream.print(", ");
                    }
                    ++j;
                }
                stream.println();
            }
            if (i < this.m_methods.length - 1) {
                stream.println("------------------------------------------------------------------");
            }
            ++i;
        }
        stream.flush();
    }

    public void dumpAll(PrintStream stream) {
        this.dumpClass(stream);
        stream.println("------------------------------------------------------------------");
        this.dumpConstructors(stream);
        stream.println("------------------------------------------------------------------");
        this.dumpFields(stream);
        stream.println("------------------------------------------------------------------");
        this.dumpMethods(stream);
    }
}

