/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.util.launcher;

import java.io.File;
import java.io.PrintStream;
import java.lang.reflect.Method;
import org.openorb.util.launcher.LibraryClassLoader;

public final class Build {
    private static final String TCOO_HOME = "openorb.home.path";
    private static final String MODULE_NAME = "openorb.module.name";
    private static final PrintStream LOG_STREAM = System.out;
    private static final Object SYNC = new byte[0];
    private static File s_openOrbHomeDir;

    private Build() {
    }

    public static void main(String[] args) throws Exception {
        File openOrbHomeDir = Build.getOpenOrbHomeDir();
        File toolsHome = new File(openOrbHomeDir, "tools");
        File libDir = new File(toolsHome, "lib");
        File extDir = new File(libDir, "ext");
        File buildDir = new File(extDir, "build");
        File jdkDir = new File(System.getProperty("java.home")).getParentFile();
        File[] roots = new File[]{new File(new File(jdkDir, "lib"), "tools.jar"), new File(extDir, "xml-apis.jar"), new File(extDir, "xercesImpl.jar"), buildDir};
        LibraryClassLoader classLoader = new LibraryClassLoader(roots, LibraryClassLoader.JAR_FILE_FILTER, LibraryClassLoader.REJECT_ALL_FILE_FILTER, false);
        Thread.currentThread().setContextClassLoader(classLoader);
        System.setProperty("ant.home", buildDir.getPath());
        Class<?> mainClass = classLoader.loadClass("org.apache.tools.ant.Main");
        Method mainMethod = mainClass.getMethod("main", args.getClass());
        String[] args2 = new String[args.length + 2];
        System.arraycopy(args, 0, args2, 2, args.length);
        Build.addBuildfileArg(args2, openOrbHomeDir);
        mainMethod.invoke(null, new Object[]{args2});
    }

    private static void log(Object msg) {
        LOG_STREAM.println(msg);
    }

    private static void log(Object prefix, Object msg) {
        LOG_STREAM.print(prefix);
        LOG_STREAM.print(": ");
        LOG_STREAM.println(msg);
    }

    private static File getOpenOrbHomeDir() {
        Object object = SYNC;
        synchronized (object) {
            if (null != s_openOrbHomeDir) {
                File file = s_openOrbHomeDir;
                return file;
            }
            String pathname = System.getProperty(TCOO_HOME);
            if (null != pathname) {
                File file = s_openOrbHomeDir = new File(pathname);
                return file;
            }
            File currentDir = new File(System.getProperty("user.dir"));
            Build.log("Warning", "Property [openorb.home.path] was not set.");
            Build.log("Info", "Searching for OpenORB Home down from [" + currentDir + "].");
            while (null != currentDir) {
                if (new File(currentDir, "tools").exists()) {
                    Build.log("Info", "Found OpenORB Home [" + currentDir + "]");
                    File file = s_openOrbHomeDir = currentDir;
                    return file;
                }
                currentDir = currentDir.getParentFile();
            }
            Build.log("Error", "Could not find OpenORB Home.");
            throw new IllegalStateException("Property [openorb.home.path] was not set.");
        }
    }

    private static void addBuildfileArg(String[] args, File openOrbHomeDir) {
        File moduleDir;
        args[0] = "-buildfile";
        String moduleName = System.getProperty(MODULE_NAME);
        if (null == moduleName) {
            Build.log("Warning", "Property [openorb.module.name] was not set.");
            moduleDir = new File(System.getProperty("user.dir"));
        } else {
            moduleDir = new File(openOrbHomeDir, moduleName);
        }
        args[1] = new File(new File(moduleDir, "src"), "build.xml").getPath();
    }
}

