/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.util.logger;

import org.apache.avalon.framework.logger.Logger;

public final class PrefixingLogger
implements Logger {
    private final Logger m_logger;
    private final String m_prefix;
    private final String m_prefixString;

    public PrefixingLogger(Logger logger) {
        this(logger, null);
    }

    public PrefixingLogger(Logger logger, String prefix) {
        this.m_logger = logger;
        this.m_prefix = prefix;
        this.m_prefixString = null == prefix ? null : "(" + prefix + ") ";
    }

    public Logger getChildLogger(String name) {
        return new PrefixingLogger(this.m_logger, null == this.m_prefix ? name : this.m_prefix + name);
    }

    private String prefixMessage(String message) {
        return null == this.m_prefixString ? message : this.m_prefixString + message;
    }

    public void debug(String message) {
        if (!this.isDebugEnabled()) {
            return;
        }
        this.m_logger.debug(this.prefixMessage(message));
    }

    public void debug(String message, Throwable throwable) {
        if (!this.isDebugEnabled()) {
            return;
        }
        this.m_logger.debug(this.prefixMessage(message), throwable);
    }

    public boolean isDebugEnabled() {
        return this.m_logger.isDebugEnabled();
    }

    public void info(String message) {
        if (!this.isInfoEnabled()) {
            return;
        }
        this.m_logger.info(this.prefixMessage(message));
    }

    public void info(String message, Throwable throwable) {
        if (!this.isInfoEnabled()) {
            return;
        }
        this.m_logger.info(this.prefixMessage(message), throwable);
    }

    public boolean isInfoEnabled() {
        return this.m_logger.isInfoEnabled();
    }

    public void warn(String message) {
        if (!this.isWarnEnabled()) {
            return;
        }
        this.m_logger.warn(this.prefixMessage(message));
    }

    public void warn(String message, Throwable throwable) {
        if (!this.isWarnEnabled()) {
            return;
        }
        this.m_logger.warn(this.prefixMessage(message), throwable);
    }

    public boolean isWarnEnabled() {
        return this.m_logger.isWarnEnabled();
    }

    public void error(String message) {
        if (!this.isErrorEnabled()) {
            return;
        }
        this.m_logger.error(this.prefixMessage(message));
    }

    public void error(String message, Throwable throwable) {
        if (!this.isErrorEnabled()) {
            return;
        }
        this.m_logger.error(this.prefixMessage(message), throwable);
    }

    public boolean isErrorEnabled() {
        return this.m_logger.isErrorEnabled();
    }

    public void fatalError(String message) {
        if (!this.isFatalErrorEnabled()) {
            return;
        }
        this.m_logger.fatalError(this.prefixMessage(message));
    }

    public void fatalError(String message, Throwable throwable) {
        if (!this.isFatalErrorEnabled()) {
            return;
        }
        this.m_logger.fatalError(this.prefixMessage(message), throwable);
    }

    public boolean isFatalErrorEnabled() {
        return this.m_logger.isFatalErrorEnabled();
    }
}

