/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.util.service;

import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.activity.Startable;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.logger.LogEnabled;
import org.apache.avalon.framework.logger.Logger;
import org.apache.avalon.framework.parameters.Parameterizable;
import org.apache.avalon.framework.parameters.Parameters;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.openorb.util.NamingUtils;
import org.openorb.util.ORBUtils;

public abstract class ServiceBase
implements LogEnabled,
Contextualizable,
Parameterizable,
Initializable,
Startable,
Disposable {
    public static final String OPT_HELP = "h";
    public static final String OPT_HELP_LONG = "help";
    public static final String OPT_HELP_DESCRIP = "print this message and exit";
    public static final String OPT_DEBUG = "d";
    public static final String OPT_DEBUG_ARG = "level";
    public static final String OPT_DEBUG_LONG = "debug";
    public static final String OPT_DEBUG_DESCRIP = "enable debugging output. (Optional) Level values: none, debug, info, warn, error. Default is debug.";
    public static final String OPT_BIND_CORBALOC = "bindCorbaloc";
    public static final String OPT_BIND_NS = "bindNaming";
    public static final String OPT_NOBIND = "n";
    public static final String OPT_NOBIND_ARG = "service";
    public static final String OPT_NOBIND_LONG = "noBind";
    public static final String OPT_NOBIND_DESCRIP = "do not bind to the specified service. Service values: Naming, Corbaloc.";
    public static final String OPT_DEFAULT_CS = "e";
    public static final String OPT_DEFAULT_CS_LONG = "default";
    public static final String OPT_DEFAULT_CS_DESCRIP = "use the DefaultCorbalocService (IIOP port 683).";
    public static final String OPT_VERSION = "v";
    public static final String OPT_VERSION_LONG = "version";
    public static final String OPT_VERSION_DESCRIP = "print the version information and exit";
    public static final String OPT_PRINT_URL = "u";
    public static final String OPT_PRINT_URL_LONG = "printCorbalocURL";
    public static final String OPT_PRINT_URL_DESCRIP = "print the corbaloc url for the service";
    public static final String OPT_WRITE_URL_FILE = "U";
    public static final String OPT_WRITE_URL_FILE_ARG = "directory";
    public static final String OPT_WRITE_URL_FILE_LONG = "writeCorbalocURL";
    public static final String OPT_WRITE_URL_FILE_DESCRIP = "write the corbaloc url to a file in the specified directory. Default is current working folder.";
    public static final String OPT_PRINT_IOR = "i";
    public static final String OPT_PRINT_IOR_LONG = "printIOR";
    public static final String OPT_PRINT_IOR_DESCRIP = "print the ior of the service";
    public static final String OPT_WRITE_IOR_FILE = "f";
    public static final String OPT_WRITE_IOR_FILE_ARG = "directory";
    public static final String OPT_WRITE_IOR_FILE_LONG = "writeIORFile";
    public static final String OPT_WRITE_IOR_FILE_DESCRIP = "write the ior to a file in the specified directory. Default is current working folder.";
    public static final String OPT_LOG_FILE = "l";
    public static final String OPT_LOG_FILE_ARG = "logfile";
    public static final String OPT_LOG_FILE_LONG = "logfile";
    public static final String OPT_LOG_FILE_DESCRIP = "log to a file in the current working folder. Default file is <service>.log";
    private boolean m_logenabled = false;
    private Logger m_logger = null;
    private boolean m_contextualized = false;
    private Context m_context = null;
    private boolean m_parameterized = false;
    private Parameters m_parameters = null;
    private boolean m_initialized = false;
    private boolean m_started = false;
    private String m_long_name = null;
    private String m_short_name = null;
    private String m_version = null;
    private ORB m_orb;
    private final HashMap m_nameObjectMap = new HashMap();

    public void enableLogging(Logger logger) {
        this.m_logger = logger;
        this.m_logenabled = true;
    }

    public Logger getLogger() {
        return this.m_logger;
    }

    protected void contextualizeService(Context context) throws ContextException {
    }

    public final synchronized void contextualize(Context context) throws ContextException {
        if (!this.m_logenabled) {
            throw new IllegalStateException("not log enabled");
        }
        this.m_contextualized = true;
        this.m_context = context;
        this.getLogger().debug("Contextualizing the service");
        this.m_orb = (ORB)this.getContext().get((java.lang.Object)"ORB");
        if (this.m_orb == null) {
            throw new ContextException("null or missing ORB");
        }
        this.contextualizeService(context);
    }

    protected Context getContext() {
        if (!this.m_contextualized) {
            throw new IllegalStateException("not contextualized");
        }
        return this.m_context;
    }

    protected void parameterizeService(Parameters params) {
    }

    public final synchronized void parameterize(Parameters params) {
        if (!this.m_contextualized) {
            throw new IllegalStateException("not contextualized");
        }
        this.m_parameterized = true;
        this.m_parameters = params;
        this.getLogger().debug("Parameterizing the service");
        this.parameterizeService(params);
    }

    protected Parameters getParameters() {
        if (!this.m_parameterized) {
            throw new IllegalStateException("not parameterized");
        }
        return this.m_parameters;
    }

    protected void initializeService() {
    }

    public final synchronized void initialize() {
        if (!this.m_parameterized) {
            throw new IllegalStateException("not parameterized");
        }
        this.m_initialized = true;
        this.getLogger().debug("Initializing the service");
        this.initializeService();
    }

    protected void startService() {
    }

    public final synchronized void start() {
        if (!this.m_initialized) {
            throw new IllegalStateException("not initialized");
        }
        this.m_started = true;
        this.getLogger().debug("Starting the service");
        this.startService();
    }

    protected void stopService() {
    }

    public final synchronized void stop() {
        if (!this.m_started) {
            throw new IllegalStateException("not started");
        }
        this.m_started = false;
        this.getLogger().debug("Stopping the service");
        this.stopService();
    }

    protected void disposeService() {
    }

    public final synchronized void dispose() {
        if (!this.m_initialized) {
            throw new IllegalStateException("not initialized");
        }
        if (this.m_initialized && this.m_started) {
            throw new IllegalStateException("not stopped yet");
        }
        this.m_initialized = false;
        this.getLogger().debug("Disposing the service");
        this.deregisterObjects();
        this.disposeService();
    }

    public boolean isLogEnabled() {
        return this.m_logenabled;
    }

    public boolean isContextualized() {
        return this.m_contextualized;
    }

    public boolean isParameterized() {
        return this.m_parameterized;
    }

    public boolean isInitialized() {
        return this.m_initialized;
    }

    public boolean isStarted() {
        return this.m_started;
    }

    public ORB getORB() {
        return this.m_orb;
    }

    public final String getLongName() {
        if (this.m_long_name == null) {
            this.m_long_name = ORBUtils.getLongFromShortName(this.getShortName());
        }
        return this.m_long_name;
    }

    public final String getShortName() {
        if (this.m_short_name == null) {
            this.m_short_name = ORBUtils.getShortNameFromClass(this.getClass());
        }
        return this.m_short_name;
    }

    public final String getVersion() {
        if (this.m_version == null) {
            this.m_version = ORBUtils.getVersionFromShortName(this.getShortName());
        }
        return this.m_version;
    }

    protected java.lang.Object createPOA() {
        java.lang.Object poa = null;
        try {
            poa = this.getContext().get((java.lang.Object)"POA");
        }
        catch (ContextException ex) {
            // empty catch block
        }
        if (poa == null) {
            try {
                poa = this.m_orb.resolve_initial_references("RootPOA");
            }
            catch (Exception ex) {
                this.getLogger().error("Getting the parent poa failed", (Throwable)ex);
            }
        }
        return poa;
    }

    protected final void registerObject(String name, Object obj) {
        this.m_nameObjectMap.put(name, obj);
        try {
            boolean bForcePrintIOR = false;
            String corbaloc = null;
            if (this.m_parameters.getParameterAsBoolean(OPT_BIND_NS, true)) {
                bForcePrintIOR = this.bindToNamingService(name, obj, this.m_orb);
            }
            if (this.m_parameters.getParameterAsBoolean(OPT_BIND_CORBALOC, true)) {
                corbaloc = this.bindToCorbalocService(obj, this.m_orb);
            }
            if (this.m_parameters.isParameter(OPT_WRITE_IOR_FILE)) {
                String arg = this.m_parameters.getParameter(OPT_WRITE_IOR_FILE, "");
                String fileName = ORBUtils.getIORFileName(arg, name);
                ORBUtils.writeIORToFileName(this.m_orb, fileName, obj);
            }
            if (this.m_parameters.getParameterAsBoolean(OPT_PRINT_IOR, false) || bForcePrintIOR) {
                String ior = this.m_orb.object_to_string(obj);
                this.consolePrintln(name + "=" + ior);
            }
            if (corbaloc != null && this.m_parameters.isParameter(OPT_WRITE_URL_FILE)) {
                String dirname = this.m_parameters.getParameter(OPT_WRITE_URL_FILE, "");
                if (dirname.length() != 0 && !dirname.endsWith(File.separator)) {
                    dirname = dirname + File.separator;
                }
                ORBUtils.writeURLToFile(dirname + this.getLongName(), corbaloc);
            }
            if (corbaloc != null && this.m_parameters.getParameterAsBoolean(OPT_PRINT_URL, false)) {
                this.consolePrintln(this.getLongName() + "=" + corbaloc);
            }
        }
        catch (Exception ex) {
            this.getLogger().error("An unexpected exception occured", (Throwable)ex);
        }
    }

    private String bindToCorbalocService(Object obj, ORB orb) {
        String corbaloc = null;
        try {
            corbaloc = NamingUtils.bindObjectToCorbalocService(orb, this.getLongName(), obj);
            if (corbaloc == null) {
                this.getLogger().warn("Cannot bind '" + this.getLongName() + "' to the CorbalocService." + " This service is only available with the OpenORB orb.");
            }
        }
        catch (Exception ex) {
            this.getLogger().error("Binding to CorbalocService failed", (Throwable)ex);
        }
        return corbaloc;
    }

    protected boolean bindToNamingService(String name, Object obj, ORB orb) {
        String long_name = this.getLongName();
        boolean bNoNS = "NameService".equals(long_name);
        boolean bForcePrintIOR = false;
        try {
            String ns_name = "COS/" + long_name + "/" + name;
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Trying to bind: '" + ns_name + "' ( NoNS = " + bNoNS + " )");
            }
            boolean result = false;
            if (!bNoNS && !(result = NamingUtils.dynamicRebind(orb, ns_name, obj))) {
                this.getLogger().warn("Failed to bind '" + name + "' to the NamingService." + " Check whether your NamingService is running!");
            }
            if (!result && !(result = NamingUtils.bindObjectToFileSystem(orb, ns_name, obj))) {
                this.getLogger().warn("Failed to write the '" + name + "' IOR to the File System.");
                if (!this.m_parameters.isParameter(OPT_WRITE_IOR_FILE)) {
                    bForcePrintIOR = true;
                }
            }
        }
        catch (Exception ex) {
            this.getLogger().error("Binding to NamingService failed", (Throwable)ex);
        }
        return bForcePrintIOR;
    }

    private void deregisterObjects() {
        String long_name = this.getLongName();
        boolean bNoNS = "NameService".equals(long_name);
        Iterator iter = this.m_nameObjectMap.keySet().iterator();
        while (iter.hasNext()) {
            String dirname;
            String filename;
            File f;
            String name = (String)iter.next();
            if (this.m_parameters.getParameterAsBoolean(OPT_BIND_NS, true)) {
                boolean result;
                String ns_name = "COS/" + long_name + "/" + name;
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Trying to unbind: " + ns_name + " ( NoNS = " + bNoNS + " )");
                }
                if (!(result = NamingUtils.unbindObjectFromNamingService(this.m_orb, ns_name, bNoNS))) {
                    this.getLogger().warn("Cannot unbind '" + name + "' from the NamingService." + " Check whether your NamingService is running!");
                }
            }
            if (!this.m_parameters.isParameter(OPT_WRITE_IOR_FILE) || (f = new File(filename = ORBUtils.getIORFileName(dirname = this.m_parameters.getParameter(OPT_WRITE_IOR_FILE, ""), name))).delete()) continue;
            this.getLogger().warn("Couldn't delete file: " + filename);
        }
    }

    protected void consolePrintln(String msg) {
        if (this.m_logger != null && this.m_logger.isInfoEnabled()) {
            this.getLogger().info(msg);
        } else {
            System.out.println(msg);
        }
    }
}

