/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.util.test;

import junit.framework.Assert;
import junit.framework.TestCase;
import org.openorb.util.NumberCache;

public class NumberCacheTest
extends TestCase {
    public NumberCacheTest(String name) {
        super(name);
    }

    public void testByte() {
        int i = 0;
        int base = 0;
        while (i <= 255) {
            byte n = (byte)(base + i);
            Assert.assertEquals((byte)n, (byte)NumberCache.getByte((byte)n));
            ++i;
        }
    }

    public void testShort() {
        this.testShortSequence(0, 255);
        this.testShortSequence(32512, 255);
        this.testShortSequence(32768, 255);
        this.testShortSequence(65280, 255);
    }

    public void testInteger() {
        this.testIntegerSequence(0, 255);
        this.testIntegerSequence(0x7FFFFF00, 255);
        this.testIntegerSequence(Integer.MIN_VALUE, 255);
        this.testIntegerSequence(-256, 255);
    }

    public void testLong() {
        this.testLongSequence(0L, 255L);
        this.testLongSequence(0x7FFFFF0000000000L, 255L);
        this.testLongSequence(Long.MIN_VALUE, 255L);
        this.testLongSequence(-1099511627776L, 255L);
    }

    public void testFloat() {
        this.testFloatSequence(0, 255);
        this.testFloatSequence(Integer.MIN_VALUE, 255);
        this.testFloatSequence(0x7FF00000, 255);
        this.testFloatSequence(-1048576, 255);
    }

    public void testDouble() {
        this.testDoubleSequence(0L, 255L);
        this.testDoubleSequence(Long.MIN_VALUE, 255L);
        this.testDoubleSequence(0x7FF0000000000000L, 255L);
        this.testDoubleSequence(-4503599627370496L, 255L);
    }

    private void testShortSequence(int base, int maxOffset) {
        int i = 0;
        while (i <= maxOffset) {
            short n = (short)(base + i);
            Assert.assertEquals((short)n, (short)NumberCache.getShort((short)n));
            ++i;
        }
    }

    private void testIntegerSequence(int base, int maxOffset) {
        int i = 0;
        while (i <= maxOffset) {
            int n = base + i;
            Assert.assertEquals((int)n, (int)NumberCache.getInteger((int)n));
            ++i;
        }
    }

    private void testLongSequence(long base, long maxOffset) {
        long i = 0L;
        while (i <= maxOffset) {
            long n = base + i;
            Assert.assertEquals((long)n, (long)NumberCache.getLong((long)n));
            ++i;
        }
    }

    private void testFloatSequence(int base, int maxOffset) {
        int i = 0;
        while (i <= maxOffset) {
            float n = Float.intBitsToFloat(base + i);
            float cached = NumberCache.getFloat((float)n).floatValue();
            Assert.assertEquals((int)Float.floatToRawIntBits(n), (int)Float.floatToRawIntBits(cached));
            ++i;
        }
    }

    private void testDoubleSequence(long base, long maxOffset) {
        long i = 0L;
        while (i <= maxOffset) {
            double n = Double.longBitsToDouble(base + i);
            double cached = NumberCache.getDouble((double)n);
            Assert.assertEquals((long)Double.doubleToRawLongBits(n), (long)Double.doubleToRawLongBits(cached));
            ++i;
        }
    }
}

