/*
 * Decompiled with CFR 0.152.
 */
package com.n2bb.SSModule;

import com.n2bb.SSModule.Settings;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

class FileSettings
implements Settings {
    private String configFile = null;
    private boolean m_caseSensitive = false;
    private Hashtable m_hashtable = new Hashtable(1000);
    private Vector m_vector = new Vector();

    public FileSettings(String settingsFile, boolean caseSensitive) {
        if (settingsFile.compareTo("") != 0) {
            this.configFile = settingsFile;
        }
        this.m_caseSensitive = caseSensitive;
        this.readFile();
    }

    public Map getSettings() {
        Hashtable<String, String> retval = new Hashtable<String, String>();
        Set entries = this.m_hashtable.keySet();
        for (String entry : entries) {
            retval.put(entry, this.get(entry));
        }
        return retval;
    }

    public boolean putSettings(Map settingsMap) {
        return true;
    }

    public String get(String name) {
        StringBuffer line = null;
        String retval = null;
        line = this.m_caseSensitive ? (StringBuffer)this.m_hashtable.get(name) : (StringBuffer)this.m_hashtable.get(name.toLowerCase());
        if (line != null) {
            retval = this.getValue(line.toString());
        }
        return retval;
    }

    public synchronized boolean put(String name, String value) {
        StringBuffer line = null;
        line = this.m_caseSensitive ? (StringBuffer)this.m_hashtable.get(name) : (StringBuffer)this.m_hashtable.get(name.toLowerCase());
        if (line != null) {
            line.replace(line.toString().indexOf(61) + 1, line.toString().length(), value);
        } else {
            line = new StringBuffer(name + "=" + value);
            this.m_vector.add(line);
            if (this.m_caseSensitive) {
                this.m_hashtable.put(name, line);
            } else {
                this.m_hashtable.put(name.toLowerCase(), line);
            }
        }
        this.writeFile();
        return true;
    }

    public synchronized boolean remove(String name) {
        boolean retval = true;
        String newname = null;
        StringBuffer line = null;
        StringBuffer linebuf = null;
        newname = this.m_caseSensitive ? name : name.toLowerCase();
        line = (StringBuffer)this.m_hashtable.get(newname);
        if (line != null) {
            linebuf = (StringBuffer)this.m_hashtable.remove(newname);
            boolean res = this.m_vector.remove(line);
            this.writeFile();
        }
        return retval;
    }

    public synchronized void reload() {
        this.m_hashtable = new Hashtable(1000);
        this.readFile();
    }

    public String getFilename() {
        return this.configFile;
    }

    private String getName(String line) {
        String retval = null;
        int separator = line.indexOf(61);
        if (separator != -1) {
            retval = line.substring(0, separator).trim();
        }
        return retval;
    }

    private String getValue(String line) {
        String retval = null;
        int separator = line.indexOf(61);
        if (separator != -1) {
            retval = line.substring(separator + 1).trim();
        }
        return retval;
    }

    private synchronized Map readFile() {
        try {
            String line;
            BufferedReader configReader = new BufferedReader(new FileReader(this.configFile));
            while ((line = configReader.readLine()) != null) {
                StringBuffer existingValue;
                StringBuffer sb = new StringBuffer(line);
                this.m_vector.add(sb);
                String name = this.getName(line);
                String value = this.getValue(line);
                if (name == null || name.length() <= 0 || name.charAt(0) == '#' || value == null) continue;
                if (!this.m_caseSensitive) {
                    name = name.toLowerCase();
                }
                if ((existingValue = (StringBuffer)this.m_hashtable.get(name)) != null) {
                    System.err.println("Duplicate value for " + name + ". Replacing " + existingValue + " with " + line);
                }
                this.m_hashtable.put(name, sb);
            }
        }
        catch (FileNotFoundException ex) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.m_hashtable;
    }

    private synchronized void writeFile() {
        try {
            FileWriter configWriter = new FileWriter(this.configFile);
            for (int i = 0; i < this.m_vector.size(); ++i) {
                try {
                    StringBuffer sb = (StringBuffer)this.m_vector.elementAt(i);
                    configWriter.write(sb.toString() + System.getProperty("line.separator", "\n"));
                    continue;
                }
                catch (ClassCastException cce) {
                    System.err.println("Caught ClassCastException in writeFile");
                    cce.printStackTrace(System.err);
                    continue;
                }
                catch (IOException ex) {
                    System.err.println("Caught IOException in writeFile inner loop");
                    ex.printStackTrace(System.err);
                }
            }
            configWriter.flush();
        }
        catch (IOException ex) {
            System.err.println("Caught IOException in writeFile");
            ex.printStackTrace(System.err);
        }
    }
}

