/*
 * Decompiled with CFR 0.152.
 */
package com.n2bb.SSModule;

import com.n2bb.SSModule.InvalidName;
import com.n2bb.SSModule.NotFound;
import com.n2bb.SSModule.SS;
import com.n2bb.SSModule.Setting;
import com.n2bb.SSModule.SettingExists;
import com.n2bb.SSModule.WrongType;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Properties;
import org.omg.CORBA.Context;
import org.omg.CORBA.ContextList;
import org.omg.CORBA.DomainManager;
import org.omg.CORBA.ExceptionList;
import org.omg.CORBA.NVList;
import org.omg.CORBA.NamedValue;
import org.omg.CORBA.Object;
import org.omg.CORBA.Policy;
import org.omg.CORBA.Request;
import org.omg.CORBA.SetOverrideType;

public class PropertiesSS
implements SS {
    private static final String CONFIG_FACADE = "PropertiesSS";
    private Properties props = new Properties();

    public PropertiesSS() {
        this.loadConfigInfo();
    }

    private void loadConfigInfo() {
        String configLocation;
        String configInfoSource = System.getProperty("CONFIG_INFO_SOURCE", "memory");
        Properties newProps = new Properties();
        if (configInfoSource.equalsIgnoreCase("file")) {
            configLocation = System.getProperty("CONFIG_LOCATION");
            File configurationFile = new File(configLocation);
            try {
                FileInputStream fis = new FileInputStream(configurationFile);
                newProps.load(fis);
                fis.close();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        } else if (configInfoSource.equalsIgnoreCase("resource")) {
            configLocation = System.getProperty("CONFIG_LOCATION");
            ClassLoader loader = this.getClass().getClassLoader();
            try {
                InputStream is = loader.getResourceAsStream(configLocation);
                newProps.load(is);
                is.close();
            }
            catch (IOException e) {
                // empty catch block
            }
            this.displayProperties(this.props, CONFIG_FACADE, "loadConfigInfo");
        }
        Enumeration<?> keys = newProps.propertyNames();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            String value = (String)newProps.get(key);
            this.props.put(key.toLowerCase(), value);
        }
        this.displayProperties(this.props, CONFIG_FACADE, "loadConfigInfo");
    }

    public void displayProperties(Properties properties, String className, String methodName) {
        ArrayList<java.lang.Object> al = new ArrayList<java.lang.Object>(properties.keySet());
        Collections.sort(al);
        for (int i = 0; i < al.size(); ++i) {
            String key = (String)al.get(i);
            String value = (String)properties.get(key);
        }
    }

    public String getString(String instance, String application, String settingName) throws NotFound, InvalidName {
        String value = null;
        String vstring = null;
        if (!instance.equals("") && !application.equals("")) {
            vstring = instance + "/" + application + "/" + settingName;
            value = (String)this.props.get(instance.toLowerCase() + "/" + application.toLowerCase() + "/" + settingName.toLowerCase());
        }
        if (value == null && !application.equals("") || instance.equals("") && !application.equals("")) {
            if (vstring == null) {
                vstring = application + "/" + settingName;
            }
            value = (String)this.props.get(application.toLowerCase() + "/" + settingName.toLowerCase());
        }
        if (value == null) {
            if (vstring == null) {
                vstring = settingName;
            }
            value = (String)this.props.get(settingName.toLowerCase());
        }
        if (value == null) {
            throw new NotFound(vstring, "Setting not found");
        }
        return value;
    }

    public void setString(String instance, String application, String settingName, String settingValue) throws SettingExists, InvalidName {
        this.props.put(instance + "/" + application + "/" + settingName, settingValue);
    }

    public void resetString(String instance, String application, String settingName, String settingValue) throws InvalidName {
        this.props.put(instance + "/" + application + "/" + settingName, settingValue);
    }

    public int getLong(String instance, String application, String settingName) throws NotFound, InvalidName, WrongType {
        Long value = null;
        String longString = this.getString(instance, application, settingName);
        try {
            value = new Long(longString);
        }
        catch (NumberFormatException nfe) {
            throw new WrongType(settingName, "Number format eror encountered when retrieving setting");
        }
        int nativeValue = 0;
        if (value != null) {
            nativeValue = value.intValue();
        }
        return nativeValue;
    }

    public void setLong(String instance, String application, String settingName, int settingValue) throws SettingExists, InvalidName, WrongType {
        this.props.put(instance + "/" + application + "/" + settingName, new Long(settingValue));
    }

    public void resetLong(String instance, String application, String settingName, int settingValue) throws InvalidName, WrongType {
        this.props.put(instance + "/" + application + "/" + settingName, new Long(settingValue));
    }

    public boolean getBoolean(String instance, String application, String settingName) throws NotFound, InvalidName {
        Boolean value = (Boolean)this.props.get(instance + "/" + application + "/" + settingName);
        boolean nativeValue = false;
        if (value != null) {
            nativeValue = value;
        }
        return nativeValue;
    }

    public void setBoolean(String instance, String application, String settingName, boolean settingValue) throws SettingExists, InvalidName {
        this.props.put(instance + "/" + application + "/" + settingName, new Boolean(settingValue));
    }

    public void resetBoolean(String instance, String application, String settingName, boolean settingValue) throws InvalidName {
        this.props.put(instance + "/" + application + "/" + settingName, new Boolean(settingValue));
    }

    public Setting[] getAllSettings() {
        Setting[] settings = new Setting[this.props.size()];
        ArrayList<java.lang.Object> al = new ArrayList<java.lang.Object>(this.props.keySet());
        Collections.sort(al);
        for (int i = 0; i < al.size(); ++i) {
            String key = (String)al.get(i);
            String value = (String)this.props.get(key);
            settings[i] = new Setting(key, value);
        }
        return settings;
    }

    public void reloadSettings() {
        this.props.clear();
        this.loadConfigInfo();
    }

    public void deleteSetting(String instance, String application, String settingName) throws NotFound, InvalidName {
        this.props.remove(instance + "/" + application + "/" + settingName);
    }

    public void _release() {
    }

    public boolean _non_existent() {
        return false;
    }

    public int _hash(int maximum) {
        return 0;
    }

    public boolean _is_a(String repositoryIdentifier) {
        return false;
    }

    public DomainManager[] _get_domain_managers() {
        return null;
    }

    public Object _duplicate() {
        return null;
    }

    public Object _get_interface_def() {
        return null;
    }

    public boolean _is_equivalent(Object other) {
        return false;
    }

    public Policy _get_policy(int policy_type) {
        return null;
    }

    public Request _request(String operation) {
        return null;
    }

    public Object _set_policy_override(Policy[] policies, SetOverrideType set_add) {
        return null;
    }

    public Request _create_request(Context ctx, String operation, NVList arg_list, NamedValue result) {
        return null;
    }

    public Request _create_request(Context ctx, String operation, NVList arg_list, NamedValue result, ExceptionList exclist, ContextList ctxlist) {
        return null;
    }

    public static void main(String[] args) {
    }
}

