/*
 * Decompiled with CFR 0.152.
 */
package com.n2bb.SSModule;

import com.n2bb.LogModule.N2BB_LogClient;
import com.n2bb.SSModule.InvalidName;
import com.n2bb.SSModule.NotFound;
import com.n2bb.SSModule.PropertiesSS;
import com.n2bb.SSModule.SS;
import com.n2bb.SSModule.SSHelper;
import com.n2bb.SSModule.Setting;
import com.n2bb.SSModule.SettingExists;
import com.n2bb.SSModule.WrongType;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CosNaming.NamingContextExt;
import org.omg.CosNaming.NamingContextExtHelper;
import org.omg.CosNaming.NamingContextPackage.CannotProceed;

public class SClient {
    private static final String myclass = "SClient";
    protected static final String SETTINGSSERVICE = "SettingsService";
    protected static final String NAMESERVICE = "NameService";
    protected static final String DEFAULTNAMESERVICE = "corbaloc::NameServer:5000/NameService";
    protected static final String GLOBAL = "";
    protected String application = null;
    protected String instance = null;
    protected SS ss = null;

    public SClient(String instName, String appName) throws org.omg.CosNaming.NamingContextPackage.NotFound, org.omg.CORBA.ORBPackage.InvalidName {
        this(instName, appName, null);
    }

    public SClient(String instName, String appName, ORB orb) throws org.omg.CosNaming.NamingContextPackage.NotFound, org.omg.CORBA.ORBPackage.InvalidName {
        this.instance = instName;
        this.application = appName;
        this.ss = this.manufactureSS(orb);
    }

    private SS manufactureSS(ORB orb) throws org.omg.CosNaming.NamingContextPackage.NotFound, org.omg.CORBA.ORBPackage.InvalidName {
        SS ss = null;
        if (null != orb) {
            NamingContextExt nc;
            block16: {
                nc = null;
                try {
                    nc = NamingContextExtHelper.narrow((Object)orb.resolve_initial_references(NAMESERVICE));
                    if (nc == null) break block16;
                    try {
                        ss = SSHelper.narrow(nc.resolve(nc.to_name(SETTINGSSERVICE)));
                        if (ss != null) {
                            return ss;
                        }
                    }
                    catch (org.omg.CosNaming.NamingContextPackage.InvalidName in) {
                    }
                    catch (CannotProceed cp) {}
                }
                catch (org.omg.CORBA.ORBPackage.InvalidName in) {
                    // empty catch block
                }
            }
            if (nc == null) {
                try {
                    nc = NamingContextExtHelper.narrow((Object)orb.string_to_object(DEFAULTNAMESERVICE));
                }
                catch (Exception exc) {
                    // empty catch block
                }
            }
            if (nc != null) {
                try {
                    ss = SSHelper.narrow(nc.resolve(nc.to_name(SETTINGSSERVICE)));
                }
                catch (org.omg.CosNaming.NamingContextPackage.InvalidName in) {
                }
                catch (CannotProceed cp) {}
            } else {
                System.err.println("Unable to connect to Name Service");
            }
        } else {
            ss = new PropertiesSS();
        }
        return ss;
    }

    public SS getSS() {
        return this.ss;
    }

    public ArrayList getEmbeddedList(String key) throws NotFound, InvalidName {
        ArrayList<String> al = new ArrayList<String>();
        String propList = this.getString(key);
        if (propList == null) {
            return al;
        }
        StringTokenizer st = new StringTokenizer(propList, ",", false);
        while (st.hasMoreTokens()) {
            String property = st.nextToken().trim();
            al.add(property);
        }
        return al;
    }

    public ArrayList getIntList(String key) throws NotFound, InvalidName {
        ArrayList<Integer> al = new ArrayList<Integer>();
        String propList = this.getString(key);
        if (propList == null) {
            return al;
        }
        StringTokenizer st = new StringTokenizer(propList, ",", false);
        while (st.hasMoreTokens()) {
            String property = st.nextToken().trim();
            try {
                al.add(new Integer(property));
            }
            catch (Throwable e) {
                e.printStackTrace(System.err);
            }
        }
        return al;
    }

    public String getString(String settingName) throws NotFound, InvalidName {
        String mymethod = "getString";
        String settingValue = GLOBAL;
        try {
            settingValue = this.ss.getString(this.instance, this.application, settingName);
            N2BB_LogClient.instance().debug(myclass, "getString", "Successfully retrieved setting '" + settingName + "=" + settingValue + "'");
        }
        catch (NotFound e) {
            N2BB_LogClient.instance().debug(myclass, "getString", "Setting '" + settingName + "' not found.  Throwing NotFound exception");
            throw e;
        }
        catch (InvalidName e) {
            N2BB_LogClient.instance().debug(myclass, "getString", "Setting '" + settingName + "' invalid name.  Throwing InvalidName exception");
            throw e;
        }
        return settingValue;
    }

    public String getString(String settingName, String defaultValue) {
        String mymethod = "getString";
        String retval = defaultValue;
        try {
            retval = this.ss.getString(this.instance, this.application, settingName);
            N2BB_LogClient.instance().debug(myclass, "getString", "Successfully retrieved setting '" + settingName + "=" + retval + "'");
        }
        catch (Exception ex) {
            N2BB_LogClient.instance().debug(myclass, "getString", "Unable to retrieve setting '" + settingName + "', returning application default '" + defaultValue + "'");
        }
        return retval;
    }

    public String getString(String inst, String app, String settingName) throws NotFound, InvalidName {
        String mymethod = "getString";
        try {
            String retval = this.ss.getString(inst, app, settingName);
            N2BB_LogClient.instance().debug(myclass, "getString", "Successfully retrieved setting '" + settingName + "=" + retval + "'");
            return retval;
        }
        catch (NotFound e) {
            N2BB_LogClient.instance().debug(myclass, "getString", "Setting '" + settingName + "' not found.  Throwing NotFound exception");
            throw e;
        }
        catch (InvalidName e) {
            N2BB_LogClient.instance().debug(myclass, "getString", "Setting '" + settingName + "' invalid name.  Throwing InvalidName exception");
            throw e;
        }
    }

    public String getString(String inst, String app, String settingName, String defaultValue) {
        String mymethod = "getString";
        String retval = defaultValue;
        try {
            retval = this.ss.getString(inst, app, settingName);
            N2BB_LogClient.instance().debug(myclass, "getString", "Successfully retrieved setting '" + settingName + "=" + retval + "'");
        }
        catch (Exception ex) {
            N2BB_LogClient.instance().debug(myclass, "getString", "Unable to retrieve setting '" + settingName + "', returning application default '" + defaultValue + "'");
        }
        return retval;
    }

    public void setString(String settingName, String settingValue) throws NotFound, InvalidName, SettingExists {
        this.ss.setString(this.instance, this.application, settingName, settingValue);
    }

    public void setString(String inst, String app, String settingName, String settingValue) throws NotFound, InvalidName, SettingExists {
        this.ss.setString(inst, app, settingName, settingValue);
    }

    public void resetString(String settingName, String settingValue) throws InvalidName {
        this.ss.resetString(this.instance, this.application, settingName, settingValue);
    }

    public void resetString(String inst, String app, String settingName, String settingValue) throws InvalidName {
        this.ss.resetString(inst, app, settingName, settingValue);
    }

    public int getLong(String settingName) throws NotFound, InvalidName, WrongType {
        int settingValue;
        String mymethod = "getLong";
        try {
            settingValue = this.ss.getLong(this.instance, this.application, settingName);
            N2BB_LogClient.instance().debug(myclass, "getLong", "Successfully retrieved setting '" + settingName + "=" + settingValue + "'");
        }
        catch (NotFound e) {
            N2BB_LogClient.instance().debug(myclass, "getLong", "Setting '" + settingName + "' not found.  Throwing NotFound exception");
            throw e;
        }
        catch (InvalidName e) {
            N2BB_LogClient.instance().debug(myclass, "getLong", "Setting '" + settingName + "' invalid name.  Throwing InvalidName exception");
            throw e;
        }
        catch (WrongType e) {
            N2BB_LogClient.instance().debug(myclass, "getLong", "Setting '" + settingName + "' not a long.  Throwing WrongType exception");
            throw e;
        }
        return settingValue;
    }

    public int getLong(String settingName, int defaultValue) {
        String mymethod = "getLong";
        int retval = defaultValue;
        try {
            retval = this.ss.getLong(this.instance, this.application, settingName);
            N2BB_LogClient.instance().debug(myclass, "getLong", "Successfully retrieved setting '" + settingName + "=" + retval + "'");
        }
        catch (Exception ex) {
            N2BB_LogClient.instance().debug(myclass, "getLong", "Unable to retrieve setting '" + settingName + "', returning application default '" + defaultValue + "'");
        }
        return retval;
    }

    public int getLong(String inst, String app, String settingName) throws NotFound, InvalidName, WrongType {
        String mymethod = "getLong";
        int retval = 0;
        try {
            retval = this.ss.getLong(inst, app, settingName);
            N2BB_LogClient.instance().debug(myclass, "getLong", "Successfully retrieved setting '" + settingName + "=" + retval + "'");
        }
        catch (NotFound e) {
            N2BB_LogClient.instance().debug(myclass, "getLong", "Setting '" + settingName + "' not found.  Throwing NotFound exception");
            throw e;
        }
        catch (InvalidName e) {
            N2BB_LogClient.instance().debug(myclass, "getLong", "Setting '" + settingName + "' invalid name.  Throwing InvalidName exception");
            throw e;
        }
        catch (WrongType e) {
            N2BB_LogClient.instance().debug(myclass, "getLong", "Setting '" + settingName + "' not a long.  Throwing WrongType exception");
            throw e;
        }
        return retval;
    }

    public int getLong(String inst, String app, String settingName, int defaultValue) {
        String mymethod = "getLong";
        int retval = defaultValue;
        try {
            retval = this.ss.getLong(inst, app, settingName);
            N2BB_LogClient.instance().debug(myclass, "getLong", "Successfully retrieved setting '" + settingName + "=" + retval + "'");
        }
        catch (Exception ex) {
            N2BB_LogClient.instance().debug(myclass, "getLong", "Unable to retrieve setting '" + settingName + "', returning application default '" + defaultValue + "'");
        }
        return retval;
    }

    public void setLong(String settingName, int settingValue) throws InvalidName, SettingExists, WrongType {
        this.ss.setLong(this.instance, this.application, settingName, settingValue);
    }

    public void setLong(String inst, String app, String settingName, int settingValue) throws InvalidName, SettingExists, WrongType {
        this.ss.setLong(inst, app, settingName, settingValue);
    }

    public void resetLong(String settingName, int settingValue) throws InvalidName, WrongType {
        this.ss.resetLong(this.instance, this.application, settingName, settingValue);
    }

    public void resetLong(String inst, String app, String settingName, int settingValue) throws InvalidName, WrongType {
        this.ss.resetLong(inst, app, settingName, settingValue);
    }

    public boolean getBoolean(String settingName) throws NotFound, InvalidName {
        boolean settingValue;
        String mymethod = "getBoolean";
        try {
            settingValue = this.ss.getBoolean(this.instance, this.application, settingName);
            N2BB_LogClient.instance().debug(myclass, "getBoolean", "Successfully retrieved setting '" + settingName + "=" + settingValue + "'");
        }
        catch (NotFound e) {
            N2BB_LogClient.instance().debug(myclass, "getBoolean", "Setting '" + settingName + "' not found.  Throwing NotFound exception");
            throw e;
        }
        catch (InvalidName e) {
            N2BB_LogClient.instance().debug(myclass, "getBoolean", "Setting '" + settingName + "' invalid name.  Throwing InvalidName exception");
            throw e;
        }
        return settingValue;
    }

    public boolean getBoolean(String settingName, boolean defaultValue) {
        String mymethod = "getBoolean";
        boolean retval = defaultValue;
        try {
            retval = this.ss.getBoolean(this.instance, this.application, settingName);
            N2BB_LogClient.instance().debug(myclass, "getBoolean", "Successfully retrieved setting '" + settingName + "=" + retval + "'");
        }
        catch (Exception ex) {
            N2BB_LogClient.instance().debug(myclass, "getBoolean", "Unable to retrieve setting '" + settingName + "', returning application default '" + defaultValue + "'");
        }
        return retval;
    }

    public boolean getBoolean(String inst, String app, String settingName) throws NotFound, InvalidName {
        boolean settingValue;
        String mymethod = "getBoolean";
        try {
            settingValue = this.ss.getBoolean(inst, app, settingName);
            N2BB_LogClient.instance().debug(myclass, "getBoolean", "Successfully retrieved setting '" + settingName + "=" + settingValue + "'");
        }
        catch (NotFound e) {
            N2BB_LogClient.instance().debug(myclass, "getBoolean", "Setting '" + settingName + "' not found.  Throwing NotFound exception");
            throw e;
        }
        catch (InvalidName e) {
            N2BB_LogClient.instance().debug(myclass, "getBoolean", "Setting '" + settingName + "' invalid name.  Throwing InvalidName exception");
            throw e;
        }
        return settingValue;
    }

    public boolean getBoolean(String inst, String app, String settingName, boolean defaultValue) {
        String mymethod = "getBoolean";
        boolean retval = defaultValue;
        try {
            retval = this.ss.getBoolean(inst, app, settingName);
            N2BB_LogClient.instance().debug(myclass, "getBoolean", "Successfully retrieved setting '" + settingName + "=" + retval + "'");
        }
        catch (Exception ex) {
            N2BB_LogClient.instance().debug(myclass, "getBoolean", "Unable to retrieve setting '" + settingName + "', returning application default '" + defaultValue + "'");
        }
        return retval;
    }

    public void setBoolean(String settingName, boolean settingValue) throws InvalidName, SettingExists {
        this.ss.setBoolean(this.instance, this.application, settingName, settingValue);
    }

    public void setBoolean(String inst, String app, String settingName, boolean settingValue) throws InvalidName, SettingExists {
        this.ss.setBoolean(inst, app, settingName, settingValue);
    }

    public void resetBoolean(String settingName, boolean settingValue) throws InvalidName {
        this.ss.resetBoolean(this.instance, this.application, settingName, settingValue);
    }

    public void resetBoolean(String inst, String app, String settingName, boolean settingValue) throws InvalidName {
        this.ss.resetBoolean(inst, app, settingName, settingValue);
    }

    public Setting[] getAllSettings() {
        return this.ss.getAllSettings();
    }

    public int getLicense(String licenseKey) {
        String mymethod = "getLicense";
        int retval = 0;
        String licenseStr = this.getString(licenseKey, null);
        if (licenseStr != null) {
            try {
                StringBuilder sessionLimit = new StringBuilder(9);
                int checksum = 0;
                int index = 0;
                for (int i = 0; i < 4; ++i) {
                    checksum += Integer.parseInt(GLOBAL + licenseStr.charAt(index++));
                    sessionLimit.append(licenseStr.charAt(index++));
                    sessionLimit.append(licenseStr.charAt(index++));
                }
                if (checksum % 10 == Integer.parseInt(GLOBAL + licenseStr.charAt(index))) {
                    retval = Integer.parseInt(sessionLimit.toString());
                } else {
                    N2BB_LogClient.instance().LogInvalidLicenseKey(myclass, "getLicense");
                }
            }
            catch (Exception e) {
                N2BB_LogClient.instance().LogInvalidLicenseKey(myclass, "getLicense");
            }
        }
        return retval;
    }

    public void deleteSetting(String inst, String app, String settingName) throws NotFound, InvalidName {
        this.ss.deleteSetting(inst, app, settingName);
    }

    public void deleteSetting(String settingName) throws NotFound, InvalidName {
        this.ss.deleteSetting(this.instance, this.application, settingName);
    }

    public void reloadSettings() {
        this.ss.reloadSettings();
    }
}

