/*
 * Decompiled with CFR 0.152.
 */
package com.n2bb.SSModule;

import com.n2bb.SSModule.ConfigHandler;
import com.n2bb.SSModule.FileSettings;
import com.n2bb.SSModule.Settings_impl;
import com.n2bb.corba.orb.OrbFactory;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.Policy;
import org.omg.CosNaming.NamingContextExt;
import org.omg.CosNaming.NamingContextExtHelper;
import org.omg.CosNaming.NamingContextPackage.CannotProceed;
import org.omg.CosNaming.NamingContextPackage.InvalidName;
import org.omg.CosNaming.NamingContextPackage.NotFound;
import org.omg.PortableServer.IdAssignmentPolicyValue;
import org.omg.PortableServer.LifespanPolicyValue;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAHelper;
import org.omg.PortableServer.POAManager;
import org.omg.PortableServer.POAManagerPackage.AdapterInactive;
import org.omg.PortableServer.POAPackage.AdapterAlreadyExists;
import org.omg.PortableServer.POAPackage.InvalidPolicy;
import org.omg.PortableServer.POAPackage.ObjectAlreadyActive;
import org.omg.PortableServer.POAPackage.ObjectNotActive;
import org.omg.PortableServer.POAPackage.ServantAlreadyActive;
import org.omg.PortableServer.POAPackage.WrongPolicy;
import org.omg.PortableServer.Servant;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class SettingsServer {
    private Settings_impl settings_impl = null;
    public static final String GLOBAL = "GlobalProperties";
    public static final String SETTINGSSERVICE = "SettingsService";
    public static final String LOCALFILE = "/usr/local/n2bb/conf/local.conf";

    public static void main(String[] args) {
        int status = 0;
        String settingsFile = "";
        boolean caseSensitive = false;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].compareTo("-help") == 0) {
                SettingsServer.usage();
                continue;
            }
            if (args[i].compareTo("-config") == 0) {
                if (args.length - i > 1) {
                    settingsFile = args[++i];
                    continue;
                }
                SettingsServer.usage();
                continue;
            }
            if (args[i].compareTo("-case") != 0) continue;
            caseSensitive = true;
        }
        SettingsServer server = new SettingsServer(caseSensitive);
        status = server.run(args, settingsFile);
        System.out.println("server.run() returned");
        System.exit(status);
    }

    public SettingsServer(boolean caseSensitive) {
        ArrayList<FileSettings> settingsMaps = new ArrayList<FileSettings>();
        try {
            FileSettings lastfile;
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser saxParser = factory.newSAXParser();
            ConfigHandler configHandler = new ConfigHandler(settingsMaps);
            saxParser.parse(new File("/usr/local/n2bb/conf/SettingsServer.xml"), (DefaultHandler)configHandler);
            File settingsFile = new File(LOCALFILE);
            if (!settingsFile.exists()) {
                settingsFile.createNewFile();
            }
            if (!(lastfile = (FileSettings)settingsMaps.get(settingsMaps.size() - 1)).getFilename().equals(LOCALFILE)) {
                FileSettings settings = new FileSettings(LOCALFILE, false);
                settingsMaps.add(settings);
            }
        }
        catch (SAXException exc) {
            exc.printStackTrace();
        }
        catch (ParserConfigurationException exc) {
            exc.printStackTrace();
        }
        catch (IOException exc) {
            exc.printStackTrace();
        }
        this.settings_impl = new Settings_impl(settingsMaps, caseSensitive);
    }

    protected int run(String[] args, String settingsFile) {
        int status = 0;
        String orbVendor = "JacORB";
        OrbFactory orbFactory = OrbFactory.getOrbFactory((String)orbVendor);
        ORB orb = orbFactory.createOrb(args, null);
        POA rootPoa = null;
        POA poa = null;
        POAManager manager = null;
        try {
            rootPoa = POAHelper.narrow((Object)orb.resolve_initial_references("RootPOA"));
            manager = rootPoa.the_POAManager();
            manager.activate();
        }
        catch (org.omg.CORBA.ORBPackage.InvalidName ex) {
            System.err.println("Error:  cannot find object:  Invalid Name");
            throw new RuntimeException();
        }
        catch (AdapterInactive ex) {
            System.err.println("Error:  POA inactive");
            throw new RuntimeException();
        }
        try {
            Policy[] policies = new Policy[]{rootPoa.create_lifespan_policy(LifespanPolicyValue.PERSISTENT), rootPoa.create_id_assignment_policy(IdAssignmentPolicyValue.USER_ID)};
            poa = rootPoa.create_POA("SettingsServicePOA", manager, policies);
        }
        catch (AdapterAlreadyExists ex) {
        }
        catch (InvalidPolicy ex) {
            // empty catch block
        }
        this.settings_impl.setPOA(poa);
        byte[] oid = SETTINGSSERVICE.getBytes();
        try {
            poa.activate_object_with_id(oid, (Servant)this.settings_impl);
        }
        catch (WrongPolicy ex) {
            throw new RuntimeException();
        }
        catch (ObjectAlreadyActive ex) {
            throw new RuntimeException();
        }
        catch (ServantAlreadyActive ex) {
            throw new RuntimeException();
        }
        try {
            Object obj = null;
            obj = poa.id_to_reference(oid);
            NamingContextExt nc = NamingContextExtHelper.narrow((Object)orb.resolve_initial_references("NameService"));
            nc.rebind(nc.to_name(SETTINGSSERVICE), obj);
        }
        catch (ObjectNotActive one) {
            one.printStackTrace();
        }
        catch (WrongPolicy wp) {
            wp.printStackTrace();
        }
        catch (org.omg.CORBA.ORBPackage.InvalidName in) {
            in.printStackTrace();
        }
        catch (InvalidName in) {
            in.printStackTrace();
        }
        catch (NotFound nf) {
            nf.printStackTrace();
        }
        catch (CannotProceed cp) {
            cp.printStackTrace();
        }
        orb.run();
        if (orb != null) {
            try {
                orbFactory.destroyOrb(orb);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                status = 1;
            }
        }
        return status;
    }

    protected static void usage() {
        System.out.println("BMS Settings Server");
        System.out.println(" Options:");
        System.out.println("   -config <file> : use <file> as config file");
        System.out.println("   -case : use case-sensitive setting names");
        System.out.println("   -help : this message");
        System.exit(1);
    }
}

