/*
 * Decompiled with CFR 0.152.
 */
package com.n2bb.SSModule;

import com.n2bb.SSModule.InvalidName;
import com.n2bb.SSModule.NotFound;
import com.n2bb.SSModule.SSPOA;
import com.n2bb.SSModule.Setting;
import com.n2bb.SSModule.SettingExists;
import com.n2bb.SSModule.Settings;
import com.n2bb.SSModule.WrongType;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import org.omg.PortableServer.POA;

public class Settings_impl
extends SSPOA {
    private POA poa_;
    private ArrayList m_settings = null;
    private static boolean caseSensitive_ = false;

    public Settings_impl(POA poa) {
        this.poa_ = poa;
    }

    public Settings_impl(ArrayList settings, boolean caseSensitive) {
        this.m_settings = settings;
        caseSensitive_ = caseSensitive;
    }

    public void setPOA(POA poa) {
        this.poa_ = poa;
    }

    public POA _default_POA() {
        if (this.poa_ != null) {
            return this.poa_;
        }
        return super._default_POA();
    }

    public String getString(String instance, String application, String settingName) throws NotFound, InvalidName {
        Settings settings;
        int i;
        String propertyName;
        String anyValue = null;
        if (!instance.equals("")) {
            propertyName = instance + "/" + application + "/" + settingName;
            for (i = this.m_settings.size() - 1; i >= 0 && (anyValue = (settings = (Settings)this.m_settings.get(i)).get(propertyName)) == null; --i) {
            }
        }
        if (anyValue == null && !application.equals("")) {
            propertyName = application + "/" + settingName;
            for (i = this.m_settings.size() - 1; i >= 0 && (anyValue = (settings = (Settings)this.m_settings.get(i)).get(propertyName)) == null; --i) {
            }
        }
        if (anyValue == null) {
            propertyName = settingName;
            for (i = this.m_settings.size() - 1; i >= 0 && (anyValue = (settings = (Settings)this.m_settings.get(i)).get(propertyName)) == null; --i) {
            }
        }
        String settingValue = null;
        if (anyValue == null) {
            throw new NotFound(settingName, "Setting not found");
        }
        settingValue = this.expandSetting(instance, application, anyValue);
        return settingValue;
    }

    public synchronized void setString(String instance, String application, String settingName, String settingValue) throws InvalidName, SettingExists {
        StringBuffer context = new StringBuffer(application);
        if (application.compareTo("") != 0) {
            context.append("/");
            if (instance.compareTo("") != 0) {
                context.insert(0, instance + "/");
            }
        }
        String propertyName = context.toString() + settingName;
        for (int i = this.m_settings.size() - 1; i >= 0; --i) {
            Settings settings = (Settings)this.m_settings.get(i);
            String result = settings.get(propertyName);
            if (result == null) continue;
            throw new SettingExists(propertyName, result);
        }
        ((Settings)this.m_settings.get(this.m_settings.size() - 1)).put(propertyName, settingValue);
    }

    public synchronized void resetString(String instance, String application, String settingName, String settingValue) throws InvalidName {
        StringBuffer context = new StringBuffer(application);
        if (application.compareTo("") != 0) {
            context.append("/");
            if (instance.compareTo("") != 0) {
                context.insert(0, instance + "/");
            }
        }
        String propertyName = context.toString() + settingName;
        ((Settings)this.m_settings.get(this.m_settings.size() - 1)).put(propertyName, settingValue);
    }

    public int getLong(String instance, String application, String settingName) throws NotFound, InvalidName, WrongType {
        try {
            return Integer.parseInt(this.getString(instance, application, settingName));
        }
        catch (NumberFormatException ex) {
            throw new WrongType();
        }
    }

    public synchronized void setLong(String instance, String application, String settingName, int settingValue) throws InvalidName, SettingExists, WrongType {
        this.setString(instance, application, settingName, Integer.toString(settingValue));
    }

    public synchronized void resetLong(String instance, String application, String settingName, int settingValue) throws InvalidName, WrongType {
        this.resetString(instance, application, settingName, Integer.toString(settingValue));
    }

    public boolean getBoolean(String instance, String application, String settingName) throws NotFound, InvalidName {
        return Boolean.valueOf(this.getString(instance, application, settingName));
    }

    public synchronized void setBoolean(String instance, String application, String settingName, boolean settingValue) throws InvalidName, SettingExists {
        Boolean value = new Boolean(settingValue);
        this.setString(instance, application, settingName, value.toString());
    }

    public synchronized void resetBoolean(String instance, String application, String settingName, boolean settingValue) throws InvalidName {
        Boolean value = new Boolean(settingValue);
        this.resetString(instance, application, settingName, value.toString());
    }

    public Setting[] getAllSettings() {
        Setting[] retval = new Setting[]{};
        if (this.m_settings.size() > 0) {
            Settings settings = (Settings)this.m_settings.get(0);
            Map settingsMap = settings.getSettings();
            for (int i = 1; i < this.m_settings.size(); ++i) {
                Settings nextSettings = (Settings)this.m_settings.get(i);
                Map nextSettingsMap = nextSettings.getSettings();
                Set nextEntries = nextSettingsMap.keySet();
                String nextEntry2 = null;
                for (String nextEntry2 : nextEntries) {
                    settingsMap.put(nextEntry2, nextSettings.get(nextEntry2));
                }
            }
            Set entries = settingsMap.keySet();
            retval = new Setting[settingsMap.size()];
            int i = 0;
            for (String entry : entries) {
                Setting s = new Setting();
                s.name = entry;
                String[] context = new String[3];
                this.parseContext(entry, context);
                s.value = this.expandSetting(context[0], context[1], (String)settingsMap.get(entry));
                retval[i++] = s;
            }
        }
        return retval;
    }

    public synchronized void reloadSettings() {
        for (int i = 0; i < this.m_settings.size(); ++i) {
            Settings settings = (Settings)this.m_settings.get(i);
            settings.reload();
        }
    }

    public synchronized void deleteSetting(String instance, String application, String settingName) throws NotFound, InvalidName {
        StringBuffer context = new StringBuffer(application);
        String propertyName = settingName;
        if (application.compareTo("") != 0) {
            context.append("/");
            if (instance.compareTo("") != 0) {
                context.insert(0, instance + "/");
            }
        }
        propertyName = context.toString() + settingName;
        this.m_settings.remove(propertyName);
    }

    private void parseContext(String origSetting, String[] context) {
        String instance = null;
        String application = null;
        String setting = null;
        int sep = origSetting.lastIndexOf(47);
        if (sep == -1) {
            setting = origSetting;
            application = "";
            instance = "";
        } else {
            String embContext = origSetting.substring(0, sep);
            setting = origSetting.substring(sep + 1);
            int contextsep = embContext.indexOf(47);
            if (contextsep == -1) {
                instance = "";
                application = embContext;
            } else {
                instance = embContext.substring(0, contextsep);
                application = embContext.substring(contextsep + 1);
            }
        }
        context[0] = instance;
        context[1] = application;
        context[2] = setting;
    }

    private String expandSetting(String instance, String application, String settingValue) {
        int index = 0;
        StringBuffer settingValueBuf = new StringBuffer(settingValue);
        while ((index = settingValueBuf.toString().indexOf("$(")) != -1) {
            String insertee;
            int endex = settingValueBuf.toString().indexOf(")", index);
            String in = settingValueBuf.substring(index + 2, endex);
            String[] context = new String[3];
            this.parseContext(in, context);
            try {
                insertee = context[1].compareTo("") == 0 ? this.getString(instance, application, context[2]) : this.getString(context[0], context[1], context[2]);
            }
            catch (Exception e) {
                insertee = "";
            }
            settingValueBuf.delete(index, endex + 1);
            settingValueBuf.insert(index, insertee);
        }
        return settingValueBuf.toString();
    }
}

