/*
 * Decompiled with CFR 0.152.
 */
package com.n2bb.AlertsModule.db;

import com.n2bb.AlertsModule.Action;
import com.n2bb.AlertsModule.ActionType;
import com.n2bb.AlertsModule.AlertData;
import com.n2bb.AlertsModule.AlertName;
import com.n2bb.AlertsModule.Hertz;
import com.n2bb.AlertsModule.containers.AbsAlertContainer;
import com.n2bb.AlertsModule.containers.AlertContainer;
import com.n2bb.AlertsModule.containers.EventAlertContainer;
import com.n2bb.AlertsModule.containers.LogAlertContainer;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Vector;
import javax.sql.DataSource;
import org.apache.commons.dbcp.ConnectionFactory;
import org.apache.commons.dbcp.DriverManagerConnectionFactory;
import org.apache.commons.dbcp.PoolableConnectionFactory;
import org.apache.commons.dbcp.PoolingDataSource;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.apache.log4j.Logger;

public class AlertsPersist {
    private static Logger n2bbLog = Logger.getLogger(AlertsPersist.class);
    private static AlertsPersist alertsPersist = null;
    private DataSource dataSource;
    private static final String GET_ALERT_NAMES_STMT = "select * from alert_names";
    private static final String WRITE_ALERT_NAME_STMT = "insert into alert_names values (?, ?)";
    private static final String UPDATE_ALERT_NAME_STMT = "update alert_names set pattern=? where alert_name=?";
    private static final String DELETE_ALERT_NAME_STMT = "delete from alert_names where alert_name=?";
    private static final String GET_ALERTS_STMT = "select a.identifier, a.alert_name, b.pattern, a.thresh_count, a.thresh_secs, a.freq_count, a.freq_secs from alerts a, alert_names b where a.type=? and a.alert_name = b.alert_name";
    private static final String WRITE_ALERT_STMT = "insert into alerts values (?, ?, ?, ?, ?, ?, ?)";
    private static final String DELETE_ALERT_STMT = "delete from alerts where identifier=?";
    private static final String GET_ALERT_ACTIONS_STMT = "select * from alert_actions where identifier=?";
    private static final String WRITE_ALERT_ACTION_STMT = "insert into alert_actions values (?, ?, ?)";
    private static final String DELETE_ALERT_ACTION_STMT = "delete from alert_actions where identifier=?";
    private static final String connTest = "select 1 from dual";

    private AlertsPersist(String dbDriver, String dbURL, String dbUser, String dbPwd) throws Exception {
        n2bbLog.debug((Object)"enter");
        n2bbLog.info((Object)("dbUser... " + dbUser));
        n2bbLog.info((Object)("dbPwd... " + dbPwd));
        n2bbLog.info((Object)("dbURL... " + dbURL));
        n2bbLog.info((Object)("dbDriver... " + dbDriver));
        System.setProperty("jdbc.drivers", dbDriver);
        GenericObjectPool connPool = new GenericObjectPool(null);
        DriverManagerConnectionFactory connFactory = new DriverManagerConnectionFactory(dbURL, dbUser, dbPwd);
        PoolableConnectionFactory poolableConnFactory = new PoolableConnectionFactory((ConnectionFactory)connFactory, (ObjectPool)connPool, null, connTest, false, true);
        this.dataSource = new PoolingDataSource((ObjectPool)connPool);
    }

    public static AlertsPersist getInstance(String dbDriver, String dbURL, String dbUser, String dbPwd) throws Exception {
        if (alertsPersist == null) {
            alertsPersist = new AlertsPersist(dbDriver, dbURL, dbUser, dbPwd);
        }
        return alertsPersist;
    }

    public static AlertsPersist getInstance() {
        if (alertsPersist == null) {
            n2bbLog.error((Object)"alertsPersist is null - call getInstance() with database variables to initialize");
        }
        return alertsPersist;
    }

    public Vector getAlerts(String type) throws Exception {
        n2bbLog.debug((Object)"enter");
        Connection conn = null;
        Statement ps = null;
        ResultSet rs = null;
        try {
            AlertData ad;
            Vector alertNames = this.getAlertNames();
            n2bbLog.debug((Object)"getting db connection...");
            conn = this.dataSource.getConnection();
            Vector<AbsAlertContainer> alerts = new Vector<AbsAlertContainer>();
            ps = conn.prepareStatement(GET_ALERTS_STMT);
            ps.setString(1, type);
            rs = ps.executeQuery();
            while (rs.next()) {
                ad = new AlertData();
                ad.identifier = rs.getString(1);
                AlertName an = new AlertName();
                an.name = rs.getString(2);
                an.type = rs.getString(3);
                ad.name = an;
                Hertz hz = new Hertz();
                hz.count = rs.getInt(4);
                hz.seconds = rs.getInt(5);
                ad.threshold = hz;
                hz = new Hertz();
                hz.count = rs.getInt(6);
                hz.seconds = rs.getInt(7);
                ad.frequency = hz;
                if (type.equals("LOG")) {
                    alerts.add(new LogAlertContainer(ad));
                    continue;
                }
                if (type.equals("EVENT")) {
                    alerts.add(new EventAlertContainer(ad));
                    continue;
                }
                n2bbLog.warn((Object)("unknown alert type... " + type));
            }
            rs.close();
            ps.close();
            n2bbLog.info((Object)("alerts count of type '" + type + "'... " + alerts.size()));
            ps = conn.prepareStatement(GET_ALERT_ACTIONS_STMT);
            for (int i = 0; i < alerts.size(); ++i) {
                Vector<Action> actions = new Vector<Action>();
                ad = ((AlertContainer)alerts.get(i)).getAlertData();
                ps.setString(1, ad.identifier);
                rs = ps.executeQuery();
                while (rs.next()) {
                    Action act = new Action();
                    act.type = ActionType.from_int(rs.getInt(2));
                    act.detail = rs.getString(3);
                    actions.add(act);
                }
                rs.close();
                Action[] action = new Action[actions.size()];
                action = actions.toArray(action);
                ad.action = action;
            }
            ps.close();
            Vector<AbsAlertContainer> vector = alerts;
            return vector;
        }
        catch (Exception e) {
            n2bbLog.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        finally {
            try {
                rs.close();
            }
            catch (Exception e) {}
            try {
                ps.close();
            }
            catch (Exception e) {}
            try {
                conn.close();
            }
            catch (Exception e) {}
        }
    }

    public void writeAlert(AlertData ad) throws Exception {
        n2bbLog.debug((Object)"enter");
        Connection conn = null;
        Statement ps = null;
        try {
            n2bbLog.debug((Object)"getting db connection...");
            conn = this.dataSource.getConnection();
            ps = conn.prepareStatement(WRITE_ALERT_STMT);
            ps.setString(1, ad.identifier);
            ps.setString(2, ad.name.name);
            ps.setInt(3, ad.threshold.count);
            ps.setInt(4, ad.threshold.seconds);
            ps.setInt(5, ad.frequency.count);
            ps.setInt(6, ad.frequency.seconds);
            ps.setString(7, "LOG");
            ps.executeUpdate();
            ps.close();
            ps = conn.prepareStatement(WRITE_ALERT_ACTION_STMT);
            ps.setString(1, ad.identifier);
            Action[] actions = ad.action;
            for (int i = 0; i < actions.length; ++i) {
                if (ActionType.a_email == actions[i].type) {
                    ps.setInt(2, 0);
                } else {
                    ps.setInt(2, 1);
                }
                ps.setString(3, actions[i].detail);
                ps.executeUpdate();
            }
            ps.close();
        }
        catch (Exception e) {
            n2bbLog.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        finally {
            try {
                ps.close();
            }
            catch (Exception e) {}
            try {
                conn.close();
            }
            catch (Exception e) {}
        }
    }

    public void deleteAlert(String identifier) throws Exception {
        n2bbLog.debug((Object)"enter");
        Connection conn = null;
        Statement ps = null;
        try {
            n2bbLog.debug((Object)"getting db connection...");
            conn = this.dataSource.getConnection();
            ps = conn.prepareStatement(DELETE_ALERT_ACTION_STMT);
            ps.setString(1, identifier);
            ps.executeUpdate();
            ps.close();
            ps = conn.prepareStatement(DELETE_ALERT_STMT);
            ps.setString(1, identifier);
            ps.executeUpdate();
            ps.close();
        }
        catch (Exception e) {
            n2bbLog.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        finally {
            try {
                ps.close();
            }
            catch (Exception e) {}
            try {
                conn.close();
            }
            catch (Exception e) {}
        }
    }

    public Vector getAlertNames() throws Exception {
        n2bbLog.debug((Object)"enter");
        Connection conn = null;
        Statement ps = null;
        ResultSet rs = null;
        try {
            n2bbLog.debug((Object)"getting db connection...");
            conn = this.dataSource.getConnection();
            ps = conn.prepareStatement(GET_ALERT_NAMES_STMT);
            rs = ps.executeQuery();
            Vector<AlertName> names = new Vector<AlertName>();
            while (rs.next()) {
                AlertName an = new AlertName();
                an.name = rs.getString(1);
                an.type = rs.getString(2);
                names.add(an);
            }
            rs.close();
            ps.close();
            Vector<AlertName> vector = names;
            return vector;
        }
        catch (Exception e) {
            n2bbLog.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        finally {
            try {
                rs.close();
            }
            catch (Exception e) {}
            try {
                ps.close();
            }
            catch (Exception e) {}
            try {
                conn.close();
            }
            catch (Exception e) {}
        }
    }

    public void writeAlertName(AlertName an) throws Exception {
        n2bbLog.debug((Object)"enter");
        Connection conn = null;
        Statement ps = null;
        try {
            n2bbLog.debug((Object)"getting db connection...");
            conn = this.dataSource.getConnection();
            ps = conn.prepareStatement(WRITE_ALERT_NAME_STMT);
            ps.setString(1, an.name);
            ps.setString(2, an.type);
            ps.executeUpdate();
            ps.close();
        }
        catch (Exception e) {
            n2bbLog.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        finally {
            try {
                ps.close();
            }
            catch (Exception e) {}
            try {
                conn.close();
            }
            catch (Exception e) {}
        }
    }

    public void updateAlertName(AlertName an) throws Exception {
        n2bbLog.debug((Object)"enter");
        Connection conn = null;
        Statement ps = null;
        try {
            n2bbLog.debug((Object)"getting db connection...");
            conn = this.dataSource.getConnection();
            ps = conn.prepareStatement(UPDATE_ALERT_NAME_STMT);
            ps.setString(1, an.type);
            ps.setString(2, an.name);
            ps.executeUpdate();
            ps.close();
        }
        catch (Exception e) {
            n2bbLog.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        finally {
            try {
                ps.close();
            }
            catch (Exception e) {}
            try {
                conn.close();
            }
            catch (Exception e) {}
        }
    }

    public void deleteAlertName(String name) throws Exception {
        n2bbLog.debug((Object)"enter");
        Connection conn = null;
        Statement ps = null;
        try {
            n2bbLog.debug((Object)"getting db connection...");
            conn = this.dataSource.getConnection();
            ps = conn.prepareStatement(DELETE_ALERT_NAME_STMT);
            ps.setString(1, name);
            ps.executeUpdate();
            ps.close();
        }
        catch (Exception e) {
            n2bbLog.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        finally {
            try {
                ps.close();
            }
            catch (Exception e) {}
            try {
                conn.close();
            }
            catch (Exception e) {}
        }
    }
}

