/*
 * Decompiled with CFR 0.152.
 */
package com.n2bb.AlertsModule.util;

import com.n2bb.SSModule.SClient;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.log4j.Logger;
import org.omg.CORBA.ORB;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CosNaming.NamingContextPackage.NotFound;

public class SettingsClient {
    private static Logger log = Logger.getLogger(SettingsClient.class);
    private SClient m_client;
    public static String dbUser = null;
    public static String dbPwd = null;
    public static String dbURL = null;
    public static String dbDriver = null;
    public static String dbUserRpt = null;
    public static String dbPwdRpt = null;
    public static String dbURLRpt = null;
    public static String dbDriverRpt = null;
    public static int centralLoggerConsumerThreads;
    public static int centralLoggerListenPort;
    public static int eventsConsumerThreads;
    public static int eventsListenPort;
    public static int smpConsumerThreads;
    public static int smpListenPort;
    public static int smpReaperThreadInterval;
    public static int smpCacheExpireTimeout;
    public static String smpArg1;
    public static String smpArg2;
    public static String smpArg3;
    public static String smpArg4;
    public static int emailMaxThreads;
    public static int snmpMaxThreads;
    public static int alertHistMaxThreads;
    public static String emailHost;
    public static String emailFromAddr;
    public static String snmpExec;
    public static String snmpAgent;
    public static String snmpTrapDestination;
    public static String snmpEnterpriseOID;
    public static String snmpTrapMessageOID;
    public static String snmpTrapSendCommunity;

    public SettingsClient(ORB orb) throws NotFound, InvalidName, UnknownHostException {
        this.m_client = new SClient("", "alerts", orb);
        snmpAgent = InetAddress.getLocalHost().getHostAddress();
        this.getSettings();
    }

    private void getSettings() {
        log.debug((Object)"enter");
        dbUser = this.getString("n2bb.bms.Oracle.UserName", "bms");
        dbPwd = this.getString("n2bb.bms.Oracle.PassWord", "bms");
        dbURL = this.getString("n2bb.bms.Oracle.ConnectionURL", "jdbc:oracle:thin:@bmsdb:1521:BMS");
        dbDriver = this.getString("n2bb.bms.Oracle.driver", "oracle.jdbc.driver.OracleDriver");
        dbUserRpt = this.getString("", "bmsrpt", "n2bb.bms.user", "bms");
        dbPwdRpt = this.getString("", "bmsrpt", "n2bb.bms.password", "bms");
        dbURLRpt = this.getString("", "bmsrpt", "n2bb.bms.url", "jdbc:oracle:thin:@bmsrptdb:1521:BMSRPT");
        dbDriverRpt = this.getString("", "bmsrpt", "n2bb.bms.drivers", "oracle.jdbc.driver.OracleDriver");
        centralLoggerConsumerThreads = this.getLong("centralLoggerConsumerThreads", 5);
        centralLoggerListenPort = this.getLong("centralLoggerListenPort", 4489);
        eventsConsumerThreads = this.getLong("eventsConsumerThreads", 1);
        eventsListenPort = this.getLong("eventsListenPort", 4490);
        smpListenPort = this.getLong("smpListenPort", 4491);
        smpConsumerThreads = this.getLong("smpConsumerThreads", 1);
        smpReaperThreadInterval = this.getLong("smpReaperThreadInterval", 1);
        smpCacheExpireTimeout = this.getLong("smpCacheExpireTimeout", 1);
        smpArg1 = this.getString("smpArg1", "java.lang.String");
        smpArg2 = this.getString("smpArg2", "java.sql.Connection");
        smpArg3 = this.getString("smpArg3", "java.lang.Integer");
        smpArg4 = this.getString("smpArg4", "com.n2bb.smp.FaultEvent");
        emailMaxThreads = this.getLong("emailMaxThreads", 10);
        emailHost = this.getString("emailHost", "127.0.0.1");
        emailFromAddr = this.getString("emailFromAddr", "N2BB Alert");
        snmpMaxThreads = this.getLong("snmpMaxThreads", 10);
        snmpExec = this.getString("snmpExecutable", "/usr/local/bin/snmptrap");
        snmpTrapDestination = this.getString("snmpTrapDestination", "127.0.0.1");
        snmpEnterpriseOID = this.getString("snmpOID", ".1.3.6.1.4.1.11021.3.0");
        snmpTrapMessageOID = this.getString("snmpTrapMessageOID", ".1.3.6.1.4.1.11021.3.43.1.0");
        snmpTrapSendCommunity = this.getString("snmpTrapSendCommunity", "public");
        alertHistMaxThreads = this.getLong("alertHistMaxThreads", 10);
    }

    public String getString(String setting, String defaultValue) {
        log.debug((Object)"enter");
        try {
            String value = this.m_client.getString(setting);
            log.info((Object)("retrieved setting '" + setting + "' with value '" + value + "'"));
            return value;
        }
        catch (com.n2bb.SSModule.NotFound e) {
            log.warn((Object)("unable to get setting '" + setting + "' returning default value... '" + defaultValue + "'"));
        }
        catch (Exception e) {
            log.warn((Object)("unable to get setting '" + setting + "' - message... " + e.getMessage()), (Throwable)e);
            log.warn((Object)("returning default for '" + setting + "'... '" + defaultValue + "'"));
        }
        return defaultValue;
    }

    public int getLong(String setting, int defaultValue) {
        log.debug((Object)"enter");
        try {
            int value = this.m_client.getLong(setting);
            log.info((Object)("retrieved setting '" + setting + "' with value '" + value + "'"));
            return value;
        }
        catch (com.n2bb.SSModule.NotFound e) {
            log.warn((Object)("unable to get setting '" + setting + "' returning default value... '" + defaultValue + "'"));
        }
        catch (Exception e) {
            log.warn((Object)("unable to get setting '" + setting + "' - message... " + e.getMessage()), (Throwable)e);
            log.warn((Object)("returning default for '" + setting + "'... '" + defaultValue + "'"));
        }
        return defaultValue;
    }

    public String getString(String instance, String application, String setting, String defaultValue) {
        log.debug((Object)"enter");
        try {
            String value = this.m_client.getString(instance, application, setting);
            log.info((Object)("retrieved setting '" + setting + "' with value '" + value + "' (instance - '" + instance + "' application - '" + application + "'"));
            return value;
        }
        catch (com.n2bb.SSModule.NotFound e) {
            log.warn((Object)("unable to get setting '" + setting + "' with instance '" + instance + "' and application '" + application + "' returning default value... '" + defaultValue + "'"));
        }
        catch (Exception e) {
            log.warn((Object)("unable to get setting '" + setting + "' with instance '" + instance + "' and application '" + application + "' - message... " + e.getMessage()), (Throwable)e);
            log.warn((Object)("returning default for '" + setting + "'... '" + defaultValue + "'"));
        }
        return defaultValue;
    }

    static {
        smpArg1 = null;
        smpArg2 = null;
        smpArg3 = null;
        smpArg4 = null;
        emailHost = null;
        emailFromAddr = null;
        snmpExec = null;
        snmpAgent = null;
        snmpTrapDestination = null;
        snmpEnterpriseOID = null;
        snmpTrapMessageOID = null;
        snmpTrapSendCommunity = null;
    }
}

