/*
 * Decompiled with CFR 0.152.
 */
package com.n2bb.LogModule;

import com.n2bb.LogModule.N2BB_LogClient;

public class LogMessage {
    public static void main(String[] args) {
        if (args.length < 3) {
            LogMessage.usage();
            return;
        }
        String facility = args[0];
        int logLevel = LogMessage.convertLogLevel(args[1]);
        StringBuffer message = new StringBuffer("");
        for (int i = 2; i < args.length; ++i) {
            message.append(args[i] + " ");
        }
        N2BB_LogClient.instance(facility).logMessage("commandline", "logmessage", message.toString(), logLevel);
    }

    private static int convertLogLevel(String logLevel) {
        if (logLevel.equalsIgnoreCase("EMERGENCY")) {
            return 0;
        }
        if (logLevel.equalsIgnoreCase("ALERT")) {
            return 1;
        }
        if (logLevel.equalsIgnoreCase("CRITICAL")) {
            return 2;
        }
        if (logLevel.equalsIgnoreCase("ERROR")) {
            return 3;
        }
        if (logLevel.equalsIgnoreCase("WARNING")) {
            return 4;
        }
        if (logLevel.equalsIgnoreCase("NOTICE")) {
            return 5;
        }
        if (logLevel.equalsIgnoreCase("INFO")) {
            return 6;
        }
        if (logLevel.equalsIgnoreCase("CORBAMETHOD")) {
            return 7;
        }
        if (logLevel.equalsIgnoreCase("STACKTRACE")) {
            return 8;
        }
        if (logLevel.equalsIgnoreCase("DEBUG")) {
            return 9;
        }
        return 10;
    }

    private static void usage() {
        System.out.println("logmessage");
        System.out.println("  Usage:  logmessage <facility> <level> <message>");
        System.out.println("    where <facility> is the facility you wish to log as");
        System.out.println("          <level> is EMERGENCY, ALERT, CRITICAL, ERROR, WARNING, NOTICE, INFO, CORBAMETHOD, STACKTRACE, DEBUG or ALL");
        System.out.println("          <message> is the message you wish to log");
    }
}

