/*
 * Decompiled with CFR 0.152.
 */
package com.n2bb.smp;

import com.n2bb.LogModule.N2BB_LogClient;
import com.n2bb.smp.Constants.Events;
import com.n2bb.smp.Constants.Keys;
import com.n2bb.smp.SmpEvent;
import com.n2bb.smp.UDPLogger;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import org.apache.log4j.Logger;

public class LogClient {
    private static final Logger log = Logger.getLogger(LogClient.class);
    private static final String myClass = "com.n2bb.smp.LogClient";
    private static LogClient instance = null;
    private static SimpleDateFormat eventSdf = null;

    private LogClient() {
        eventSdf = new SimpleDateFormat("yyyyMMddHHmm");
    }

    public static LogClient instance() {
        return instance;
    }

    public void LogAssetPlay(String sessionId, String assetId) {
        SmpEvent smpEvent = new SmpEvent(0);
        smpEvent.addEventCode(39);
        smpEvent.addTransactionID("Session_ID", sessionId);
        smpEvent.addOperand("Asset_ID", assetId);
        UDPLogger.instance().logSMPEvent(smpEvent);
    }

    public void LogAssetPlay(String sessionId, String assetId, String streamId, Integer duration) {
        SmpEvent smpEvent = new SmpEvent(0);
        smpEvent.addEventCode(39);
        smpEvent.addTransactionID("Session_ID", sessionId);
        smpEvent.addOperand("Asset_ID", assetId);
        smpEvent.addOperand("Stream_ID", streamId);
        smpEvent.setDuration((int)duration);
        UDPLogger.instance().logSMPEvent(smpEvent);
    }

    public void LogStreamId(String sessionId, String streamId) {
        SmpEvent smpEvent = new SmpEvent(0);
        smpEvent.addEventCode(39);
        smpEvent.addTransactionID("Session_ID", sessionId);
        smpEvent.addOperand("Stream_ID", streamId);
        smpEvent.addDataDescriptor("Session_Start_Time", System.currentTimeMillis());
        UDPLogger.instance().logSMPEvent(smpEvent);
    }

    public void LogStreamSetupDuration(String sessionId, String startTime, String endTime) {
        SmpEvent smpEvent = new SmpEvent(1);
        smpEvent.addEventCode(41);
        smpEvent.addTransactionID("Session_ID", sessionId);
        smpEvent.addDataDescriptor("Session_Start_Time", startTime);
        smpEvent.addDataDescriptor("End_Time", endTime);
        UDPLogger.instance().logSMPEvent(smpEvent);
    }

    public void LogAssetPlayFailed(String sessionId) {
        SmpEvent smpEvent = new SmpEvent(2);
        smpEvent.addEventCode(42);
        smpEvent.addTransactionID("Session_ID", sessionId);
        smpEvent.addDataDescriptor("Session_Start_Time", System.currentTimeMillis());
        UDPLogger.instance().logSMPEvent(smpEvent);
    }

    public void LogStreamFailure(String sessionId) {
        SmpEvent smpEvent = new SmpEvent(2);
        smpEvent.addEventCode(43);
        smpEvent.addTransactionID("Session_ID", sessionId);
        smpEvent.addDataDescriptor("Session_Start_Time", System.currentTimeMillis());
        UDPLogger.instance().logSMPEvent(smpEvent);
    }

    public void LogStream(String sessionId, String streamId, String startTime, String endTime) {
        String myMethod = "LogStream";
        N2BB_LogClient.instance().logMessage(myClass, "LogStream", "Entering logStream " + startTime + " " + endTime, 9);
        if (streamId != null) {
            this.LogStreamId(sessionId, streamId);
        }
        if (sessionId != null && startTime != null && endTime != null) {
            this.LogStreamSetupDuration(sessionId, startTime, endTime);
        }
        if (streamId == null) {
            this.LogStreamFailure(sessionId);
        }
        N2BB_LogClient.instance().logMessage(myClass, "LogStream", "Exiting logStream", 9);
    }

    public void LogSessionGWSSSIDropped(String sessionId) {
        SmpEvent smpEvent = new SmpEvent(2);
        smpEvent.addEventCode(23);
        smpEvent.addTransactionID("Session_ID", sessionId);
        smpEvent.addDataDescriptor("Session_Start_Time", System.currentTimeMillis());
        UDPLogger.instance().logSMPEvent(smpEvent);
    }

    public void LogSessionGWSSSI(String sessionId, String svcGrp, String svcGWId, String serviceId, String offeringId, String macAddress) {
        SmpEvent smpEvent = new SmpEvent(1);
        smpEvent.addEventCode(13);
        smpEvent.addTransactionID("Session_ID", sessionId);
        smpEvent.addDataDescriptor("Service_Group", svcGrp);
        smpEvent.addDataDescriptor("SvcGW_ID", svcGWId);
        smpEvent.addDataDescriptor("Service_ID", serviceId);
        smpEvent.addDataDescriptor("Offering", offeringId);
        smpEvent.addOperand("Terminal_ID", macAddress);
        smpEvent.addDataDescriptor("Session_Start_Time", System.currentTimeMillis());
        UDPLogger.instance().logSMPEvent(smpEvent);
        smpEvent.setType(0);
        UDPLogger.instance().logSMPEvent(smpEvent);
    }

    public void LogSessionGWServiceGatewayNonexistent(String sessionId) {
        SmpEvent smpEvent = new SmpEvent(2);
        smpEvent.addEventCode(25);
        smpEvent.addTransactionID("Session_ID", sessionId);
        smpEvent.addDataDescriptor("Session_Start_Time", System.currentTimeMillis());
        UDPLogger.instance().logSMPEvent(smpEvent);
    }

    public void LogSessionGWServiceGatewayOutOfservice(String sessionId) {
        SmpEvent smpEvent = new SmpEvent(2);
        smpEvent.addEventCode(24);
        smpEvent.addTransactionID("Session_ID", sessionId);
        smpEvent.addDataDescriptor("Session_Start_Time", System.currentTimeMillis());
        UDPLogger.instance().logSMPEvent(smpEvent);
    }

    public void LogSessionGWCallingAttach(String sessionId) {
        SmpEvent smpEvent = new SmpEvent(1);
        smpEvent.addEventCode(21);
        smpEvent.addTransactionID("Session_ID", sessionId);
        smpEvent.addDataDescriptor("Session_Start_Time", System.currentTimeMillis());
        UDPLogger.instance().logSMPEvent(smpEvent);
    }

    public void LogSessionGWSSRI(String sessionId) {
        SmpEvent smpEvent = new SmpEvent(1);
        smpEvent.addEventCode(22);
        smpEvent.addTransactionID("Session_ID", sessionId);
        smpEvent.addDataDescriptor("End_Time", System.currentTimeMillis());
        UDPLogger.instance().logSMPEvent(smpEvent);
    }

    public void LogSessionGWSSRR(String sessionId) {
        SmpEvent smpEvent = new SmpEvent(1);
        smpEvent.addEventCode(20);
        smpEvent.addTransactionID("Session_ID", sessionId);
        smpEvent.addDataDescriptor("End_Time", System.currentTimeMillis());
        UDPLogger.instance().logSMPEvent(smpEvent);
        smpEvent.setType(0);
        UDPLogger.instance().logSMPEvent(smpEvent);
    }

    public void LogSessionGWSSSIInternalError(String sessionId) {
        SmpEvent smpEvent = new SmpEvent(2);
        smpEvent.addEventCode(32);
        smpEvent.addTransactionID("Session_ID", sessionId);
        smpEvent.addDataDescriptor("Session_Start_Time", System.currentTimeMillis());
        UDPLogger.instance().logSMPEvent(smpEvent);
    }

    public void LogSessionGWServiceGatewayNotRegistered(String sessionId) {
        SmpEvent smpEvent = new SmpEvent(2);
        smpEvent.addEventCode(26);
        smpEvent.addTransactionID("Session_ID", sessionId);
        smpEvent.addDataDescriptor("Session_Start_Time", System.currentTimeMillis());
        UDPLogger.instance().logSMPEvent(smpEvent);
    }

    public void LogSessionCAID(String sessionId, String ID) {
        SmpEvent smpEvent = new SmpEvent(0);
        smpEvent.addEventCode(39);
        smpEvent.addTransactionID("Session_ID", sessionId);
        smpEvent.addOperand("CA_ID", ID);
        UDPLogger.instance().logSMPEvent(smpEvent);
    }

    public void logEventCounter(Timestamp ts, int eventCode, long count) {
        String eventTs = eventSdf.format(ts);
        SmpEvent smpEvent = new SmpEvent(100);
        smpEvent.addKey(Keys.EVENT, eventCode + "");
        smpEvent.addKey(Keys.TIMEKEY, eventTs.substring(0, 10));
        smpEvent.addKey(Keys.COUNT, count + "");
        UDPLogger.instance().logSMPEvent(smpEvent);
    }

    public static void main(String[] args) {
        Date date = new Date(System.currentTimeMillis());
        System.out.println(date.toString());
        LogClient.instance().logEventCounter(null, Events.PASSTHRU_RECEIPT_CONFIRM.getCode(), 1L);
        LogClient.instance().LogSessionGWSSRR("01231212311");
        LogClient.instance().LogSessionGWSSSIDropped("01231212311");
    }

    static {
        instance = new LogClient();
    }
}

