/*
 * Decompiled with CFR 0.152.
 */
package com.n2bb.smp;

import com.n2bb.smp.Constants.Keys;
import com.n2bb.smp.PropertyMap;
import java.io.Serializable;
import java.sql.Connection;
import java.util.HashMap;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public class SmpEvent
implements Serializable {
    private static Logger log = Logger.getLogger(SmpEvent.class);
    static final int SESSION_HISTORY = 0;
    static final int SESSION_EVENT = 1;
    static final int SESSION_ERROR = 2;
    static final int EVENT_COUNTER = 100;
    private HashMap<String, String> hmap;
    public int eventCode;
    public int type = -1;
    PropertyMap transID;
    PropertyMap operands;
    private PropertyMap dataDescriptors;
    private Integer duration;
    private PropertyMap xRef;
    private String ipAddress;

    public SmpEvent(int type) {
        this.type = type;
        this.hmap = new HashMap();
        this.hmap.put("TYPE", type + "");
    }

    public SmpEvent(String raw) {
        int pos = raw.indexOf("}{");
        String header = raw.substring(1, pos);
        this.parseHeader(header);
        ++pos;
        pos = raw.indexOf(" ", pos) + 1;
        String body = raw.substring(pos);
        this.parseBody(body);
    }

    public SmpEvent(String raw, Connection c) {
        this(raw);
    }

    public SmpEvent(String raw, Connection c, int type, Integer transId) {
        this(raw);
        this.addType(type);
        this.addTransactionID("Unique_Session_ID", transId.toString());
    }

    public void parseHeader(String header) {
        int curPos = header.indexOf(" ");
        if (curPos == 0) {
            curPos = header.indexOf(" ", 2);
        }
        this.type = Integer.parseInt(header.substring(0, curPos));
        log.debug((Object)("Type code " + this.type + header));
        ++curPos;
        while (curPos > 0) {
            curPos = this.parseNextToken(curPos, header);
        }
    }

    public void parseBody(String header) {
        int curPos = this.parseNextToken(0, header);
        while (curPos > 0) {
            curPos = this.parseNextToken(curPos, header);
        }
    }

    private int parseEvent(String msg) {
        int spot = msg.indexOf("EVENT{") + 5;
        int end = msg.indexOf("}", spot);
        String typ = msg.substring(spot, end);
        return Integer.parseInt(typ);
    }

    public int parseNextToken(int pos, String raw) {
        try {
            int spot;
            String tid;
            StringTokenizer tok;
            String transId;
            String temp = raw.substring(pos, raw.indexOf("}", pos) + 1);
            if (temp.indexOf("EVENT") >= 0) {
                this.eventCode = this.parseEvent(temp);
            }
            if (temp.indexOf("TRANS") >= 0) {
                transId = this.getStringVal(temp);
                tok = new StringTokenizer(transId);
                tid = null;
                while (tok.hasMoreTokens()) {
                    tid = tok.nextToken(";");
                    spot = tid.indexOf("=");
                    if (spot <= 0) continue;
                    this.addTransactionID(tid.substring(0, spot), tid.substring(spot + 1));
                }
            }
            if (temp.indexOf("OP") >= 0) {
                transId = this.getStringVal(temp);
                tok = new StringTokenizer(transId);
                tid = null;
                while (tok.hasMoreTokens()) {
                    tid = tok.nextToken(";");
                    spot = tid.indexOf("=");
                    if (spot <= 0) continue;
                    this.addOperand(tid.substring(0, spot), tid.substring(spot + 1));
                }
            }
            if (temp.indexOf("DD") >= 0) {
                transId = this.getStringVal(temp);
                tok = new StringTokenizer(transId);
                tid = null;
                while (tok.hasMoreTokens()) {
                    tid = tok.nextToken(";");
                    spot = tid.indexOf("=");
                    if (spot <= 0) continue;
                    this.addDataDescriptor(tid.substring(0, spot), tid.substring(spot + 1));
                }
            }
            if (temp.indexOf("XREF") >= 0) {
                transId = this.getStringVal(temp);
                tok = new StringTokenizer(transId);
                tid = null;
                while (tok.hasMoreTokens()) {
                    tid = tok.nextToken(";");
                    spot = tid.indexOf("=");
                    if (spot <= 0) continue;
                    this.addCrossReference(tid.substring(0, spot), tid.substring(spot + 1));
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return raw.indexOf(" ", pos) + 1;
    }

    public int getIntVal(String s) {
        int start = s.indexOf("{") + 1;
        int end = s.indexOf("}");
        if (start > 0 && end > 0) {
            return Integer.parseInt(s.substring(start, end));
        }
        return -1;
    }

    public String getStringVal(String s) {
        int start = s.indexOf("{") + 1;
        int end = s.indexOf("}");
        if (start > 0 && end > 0) {
            return s.substring(start, end);
        }
        return "";
    }

    public void setIPAddress(String ipAddress) {
    }

    public void addTransactionID(String key, String value) {
        try {
            log.debug((Object)(key + " = key, value = " + value));
            if (null == this.transID) {
                this.transID = new PropertyMap();
            }
            this.transID.setProperty(key, value);
        }
        catch (Exception e) {
            log.error((Object)e);
        }
    }

    public void addType(int type) {
        this.type = type;
    }

    public void addEventCode(int eventCode) {
        this.eventCode = eventCode;
    }

    public void addOperand(String key, String value) {
        if (null == this.operands) {
            this.operands = new PropertyMap();
        }
        this.operands.setProperty(key, value);
    }

    public void addKey(Keys key, String value) {
        this.hmap.put(key.toString(), value);
    }

    public void addDataDescriptor(String key, String value) {
        if (null == this.dataDescriptors) {
            this.dataDescriptors = new PropertyMap();
        }
        this.dataDescriptors.setProperty(key, value);
    }

    public void addDataDescriptor(String key, long value) {
        this.addDataDescriptor(key, Long.toString(value));
    }

    public void setDuration(int duration) {
        this.duration = new Integer(duration);
    }

    public void setDuration(Integer duration) {
        this.duration = duration;
    }

    public void addCrossReference(String key, String value) {
        if (null == this.xRef) {
            this.xRef = new PropertyMap();
        }
        this.xRef.setProperty(key, value);
    }

    public String toSMPString() {
        StringBuilder retVal = new StringBuilder("");
        if (this.type == 100) {
            for (String key : this.hmap.keySet()) {
                retVal.append(String.format("%s%s=%s", retVal.length() == 0 ? "" : " ", key, this.hmap.get(key)));
            }
            return retVal.toString();
        }
        retVal.append("{ ");
        retVal.append(this.type);
        retVal.append(" EVENT{" + this.eventCode + "}");
        if (null != this.ipAddress) {
            retVal.append(" IP{" + this.ipAddress + "}");
        }
        if (null != this.transID) {
            retVal.append(" TRANS{" + this.transID.toSMPString() + "}");
        }
        retVal.append(" }");
        retVal.append("{");
        if (null != this.operands) {
            retVal.append(" OP{" + this.operands.toSMPString() + "}");
        }
        if (null != this.dataDescriptors) {
            retVal.append(" DD{" + this.dataDescriptors.toSMPString() + "}");
        }
        if (null != this.duration) {
            retVal.append(" DUR{" + this.duration + "}");
        }
        if (null != this.xRef) {
            retVal.append(" XREF{" + this.xRef.toSMPString() + "}");
        }
        retVal.append(" }");
        return retVal.toString();
    }

    public int getEventCode() {
        return this.eventCode;
    }

    public static void main(String[] args) {
        SmpEvent SMP = new SmpEvent("{ 100 EVENT{101} TRANS{Time_Key=2005012} }{ OP{Count=1} }");
        System.out.println(SMP.toSMPString());
    }

    public void setType(int type) {
        this.type = type;
    }
}

