/*
 * Decompiled with CFR 0.152.
 */
package com.n2bb.smp;

import com.n2bb.smp.SmpEvent;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Vector;

public class UDPLogger {
    private Vector m_messageQueue = new Vector();
    private DatagramSocket m_dgSocket = null;
    private int m_logServerPort = 4491;
    private String m_ipAddress = "Alerts";
    private InetAddress m_logServerAddress = null;
    private int m_bufferSize = 65535;
    private static UDPLogger instance = null;

    public static UDPLogger instance() {
        if (instance == null) {
            instance = new UDPLogger();
        }
        return instance;
    }

    public void logSMPEvent(SmpEvent smpEvent) {
        boolean retval = true;
        StringBuffer finalMsg = new StringBuffer();
        finalMsg.append(smpEvent.toSMPString());
        this.m_messageQueue.add(finalMsg.toString());
        System.out.println(finalMsg);
        boolean socketValid = true;
        if (this.m_dgSocket == null || this.m_ipAddress == null) {
            socketValid = this.initSocket();
        }
        if (socketValid) {
            String msg = "";
            while (this.m_messageQueue.size() > 0) {
                try {
                    msg = (String)this.m_messageQueue.remove(0);
                    DatagramPacket packet = new DatagramPacket(msg.getBytes(), msg.length(), this.m_logServerAddress, this.m_logServerPort);
                    this.m_dgSocket.send(packet);
                }
                catch (ArrayIndexOutOfBoundsException aioobe) {
                }
                catch (IOException e) {
                    System.out.println("UDPLogger.logSMPEvent: Unable to send message to the logger. Exception caught");
                    System.out.println("Exception : " + e.toString());
                    this.m_messageQueue.add(0, msg);
                    retval = false;
                }
            }
        }
    }

    private boolean initSocket() {
        boolean retval = true;
        try {
            this.m_dgSocket = new DatagramSocket();
            this.m_dgSocket.setSendBufferSize(this.m_bufferSize);
            this.m_logServerAddress = InetAddress.getByName("Alerts");
            if (this.m_logServerAddress != null) {
                this.m_ipAddress = this.m_logServerAddress.getHostAddress();
            }
        }
        catch (SocketException se) {
            System.out.println("UDPLogger.initSocket: Unable to open datagram socket--will retry later.  Caching log messages.");
            retval = false;
        }
        catch (UnknownHostException uhe) {
            System.out.println("UDPLogger.initSocket: Unable to determine host IP address--will retry later.  Caching log messages.");
            retval = false;
        }
        return retval;
    }

    public static void main(String[] args) {
    }
}

