/*
 * Decompiled with CFR 0.152.
 */
package com.n2bb.common.billing;

import com.n2bb.LogModule.N2BB_LogClient;
import com.n2bb.common.billing.ConversionException;
import com.n2bb.common.billing.EquipmentIdPattern;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class BaseSTBFormatter {
    public static final String myclass = "BaseSTBFormatter";
    public static final int HEX = 16;
    public static final int BYTE4_OUTGOING_LEN = 3;
    public static final int BYTE3210_OUTGOING_LEN = 10;
    public static final int BYTE4_INCOMING_LEN = 2;
    public static final int BYTE3210_INCOMING_LEN = 8;
    public static final int CHECKSUM_LEN = 3;
    public String vendorName = null;
    protected static final byte POLYNOMIAL = -101;
    protected final byte INIT_VALUE = (byte)-1;
    protected static byte[] crc_table = new byte[256];

    public BaseSTBFormatter(String vendorName) {
        this.vendorName = vendorName;
        BaseSTBFormatter.gen_crc_table();
    }

    public String getVendor() {
        return this.vendorName;
    }

    public String getSA(String id) throws ConversionException {
        String mymethod = "getSA";
        if (!this.validateInternalId(id)) {
            throw new ConversionException();
        }
        String formattedId = id.toUpperCase();
        N2BB_LogClient.instance().debug(myclass, "getSA", "Converted equipment id: " + id + " to base SA equipment id: " + formattedId);
        return formattedId;
    }

    public String getDAC(String id) throws ConversionException {
        String mymethod = "getDAC";
        if (!this.validateInternalId(id)) {
            throw new ConversionException();
        }
        String formattedId = this.getBaseMoto(id) + this.getMotoChecksum(id);
        N2BB_LogClient.instance().debug(myclass, "getDAC", "Converted equipment id: " + id + " to base Moto DAC equipment id: " + formattedId);
        return formattedId;
    }

    public String getNAS(String id) throws ConversionException {
        String mymethod = "getNAS";
        if (!this.validateInternalId(id)) {
            throw new ConversionException();
        }
        String formattedId = this.addDashes(this.getBaseMoto(id));
        N2BB_LogClient.instance().debug(myclass, "getNAS", "Converted equipment id: " + id + " to base Moto NAS equipment id: " + formattedId);
        return formattedId;
    }

    protected String getMotoChecksum(String macAddr) {
        String mymethod = "getMotoChecksum";
        String crcStr = null;
        byte[] tempMacAddr = new byte[6];
        tempMacAddr = BaseSTBFormatter.stringToByteArray(macAddr);
        int calc_crc = this.update_crc(tempMacAddr, 1, tempMacAddr.length - 1);
        crcStr = this.crcToString(calc_crc);
        N2BB_LogClient.instance().debug(myclass, "getMotoChecksum", "Calculated id checksum of: " + crcStr + " from Moto equipment id: " + macAddr);
        return crcStr;
    }

    protected String getBaseMoto(String id) throws ConversionException {
        String mymethod = "getBaseMoto";
        String formattedId = null;
        if (!id.substring(0, 2).equals("00")) {
            N2BB_LogClient.instance().debug(myclass, "getBaseMoto", "Internal equipment id: " + id + " is not valid. all Moto " + "ids must start with '00'");
            throw new ConversionException();
        }
        String byte4 = Long.toString(Long.parseLong(id.substring(2, 4), 16));
        String byte3210 = Long.toString(Long.parseLong(id.substring(4), 16));
        if (byte4.length() != 3) {
            byte4 = this.padWithZeros(byte4, 3);
        }
        if (byte3210.length() != 10) {
            byte3210 = this.padWithZeros(byte3210, 10);
        }
        formattedId = byte4 + byte3210;
        N2BB_LogClient.instance().debug(myclass, "getBaseMoto", "Converted internal equipment id: " + id + " to base Moto equipment id: " + formattedId);
        return formattedId;
    }

    protected boolean validateInternalId(String id) {
        Pattern p = Pattern.compile(EquipmentIdPattern.INTERNAL.regex());
        Matcher m = p.matcher(id);
        return m.find() && id.length() == EquipmentIdPattern.INTERNAL.length();
    }

    protected String addDashes(String id) {
        StringBuilder formattedId = new StringBuilder(id);
        formattedId.insert(3, "-");
        formattedId.insert(9, "-");
        return formattedId.toString();
    }

    protected String addColons(String id) {
        StringBuilder formattedId = new StringBuilder(id);
        formattedId.insert(2, ":");
        formattedId.insert(5, ":");
        formattedId.insert(8, ":");
        formattedId.insert(11, ":");
        formattedId.insert(14, ":");
        return formattedId.toString();
    }

    public abstract String parseEquipmentId(String var1) throws ConversionException;

    public String parseSA(String id) {
        String mymethod = "parseSA";
        String formattedId = id.toLowerCase();
        N2BB_LogClient.instance().debug(myclass, "parseSA", "Converted SA equipment id: " + id + " to internal equipment id: " + formattedId);
        return formattedId;
    }

    public String parseDAC(String id) throws ConversionException {
        String mymethod = "parseDAC";
        String checksum = id.substring(13);
        String formattedId = this.parseBaseMoto(this.stripChecksum(id));
        N2BB_LogClient.instance().debug(myclass, "parseDAC", "Converted Moto DAC equipment id: " + id + " to internal equipment id: " + formattedId);
        if (this.checkChecksum(formattedId, checksum)) {
            return formattedId;
        }
        N2BB_LogClient.instance().error(myclass, "parseDAC", "Invalid checksum: " + checksum + " for equipment id: " + formattedId);
        throw new ConversionException();
    }

    public String parseNAS(String id) throws ConversionException {
        String mymethod = "parseNAS";
        String formattedId = this.parseBaseMoto(this.stripDashes(id));
        N2BB_LogClient.instance().debug(myclass, "parseNAS", "Converted Moto NAS equipment id: " + id + " to internal equipment id: " + formattedId);
        return formattedId;
    }

    public EquipmentIdPattern getEquipmentIdType(String id) throws ConversionException {
        String mymethod = "getEquipmentIdType";
        for (EquipmentIdPattern pattern : EquipmentIdPattern.values()) {
            Pattern p = Pattern.compile(pattern.regex());
            Matcher m = p.matcher(id);
            if (!m.find() || pattern.length() != id.length()) continue;
            return pattern;
        }
        N2BB_LogClient.instance().error(myclass, "getEquipmentIdType", "Invalid Equipment ID received - ID: " + id + " not matched by any regex for known Equipment ID types");
        throw new ConversionException();
    }

    protected String parseBaseMoto(String id) {
        String mymethod = "parseBaseMotoId";
        String formattedId = null;
        String byte4 = Long.toHexString(Long.parseLong(id.substring(0, 3)));
        String byte3210 = Long.toHexString(Long.parseLong(id.substring(3)));
        if (byte4.length() != 2) {
            byte4 = this.padWithZeros(byte4, 2);
        }
        if (byte3210.length() != 8) {
            byte3210 = this.padWithZeros(byte3210, 8);
        }
        formattedId = "00" + byte4 + byte3210;
        N2BB_LogClient.instance().debug(myclass, "parseBaseMotoId", "Converted base Moto equipment id: " + id + " to internal equipment id: " + formattedId);
        return formattedId;
    }

    protected boolean checkChecksum(String id, String checksum) {
        return this.getMotoChecksum(id).equals(checksum);
    }

    protected String stripColons(String id) {
        return id.replaceAll(":", "");
    }

    protected String stripDashes(String id) {
        return id.replaceAll("-", "");
    }

    protected String stripChecksum(String id) {
        return id.substring(0, 13);
    }

    protected String padWithZeros(String id, int padLength) {
        StringBuilder formattedId = new StringBuilder();
        for (int i = 0; i < padLength - id.length(); ++i) {
            formattedId.append("0");
        }
        formattedId.append(id);
        return formattedId.toString();
    }

    protected static void gen_crc_table() {
        for (int i = 0; i < 256; ++i) {
            int crc_accum;
            int temp_crc = crc_accum = (int)(i & 0xFF);
            for (int j = 0; j < 8; ++j) {
                if ((temp_crc & 0x80) == 128) {
                    temp_crc <<= 1;
                    temp_crc ^= 0xFFFFFF9B;
                    temp_crc &= 0xFF;
                    continue;
                }
                temp_crc <<= 1;
            }
            BaseSTBFormatter.crc_table[i] = crc_accum = (byte)(temp_crc & 0xFF);
        }
    }

    protected int update_crc(byte[] data_blk, int offset, int data_blk_size) {
        int crc_accum = -1;
        for (int j = 0; j < data_blk_size; ++j) {
            int i = (crc_accum ^ data_blk[offset + j]) & 0xFF;
            crc_accum = crc_table[i] & 0xFF;
        }
        return crc_accum;
    }

    protected static byte[] stringToByteArray(String macAddr) {
        byte[] macBytes = new byte[6];
        int size = macAddr.length() / 2;
        int start = 0;
        for (int i = 0; i < size; ++i) {
            long lgb = Long.parseLong(macAddr.substring(start, start + 2), 16);
            start += 2;
            macBytes[i] = (byte)lgb;
        }
        return macBytes;
    }

    protected String crcToString(int crc) {
        String outStr = new String();
        outStr = (crc < 100 ? "0" : "") + (crc < 10 ? "0" : "") + crc;
        return outStr;
    }
}

